/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.screens;

import com.davidm1a2.afraidofthedark.client.gui.customControls.SpellComponentSlot;
import com.davidm1a2.afraidofthedark.client.gui.customControls.SpellScroll;
import com.davidm1a2.afraidofthedark.client.gui.customControls.SpellTablet;
import com.davidm1a2.afraidofthedark.client.gui.events.KeyEvent;
import com.davidm1a2.afraidofthedark.client.gui.layout.Spacing;
import com.davidm1a2.afraidofthedark.client.gui.screens.AOTDScreen;
import com.davidm1a2.afraidofthedark.client.gui.screens.SpellListScreen;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.HChainPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ImagePane;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/screens/SpellCraftingScreen;", "Lcom/davidm1a2/afraidofthedark/client/gui/screens/AOTDScreen;", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "(Lcom/davidm1a2/afraidofthedark/common/spell/Spell;)V", "scroll", "Lcom/davidm1a2/afraidofthedark/client/gui/customControls/SpellScroll;", "tablet", "Lcom/davidm1a2/afraidofthedark/client/gui/customControls/SpellTablet;", "drawGradientBackground", "", "inventoryToCloseGuiScreen", "afraidofthedark"})
public final class SpellCraftingScreen
extends AOTDScreen {
    @NotNull
    private final SpellTablet tablet;
    @NotNull
    private final SpellScroll scroll;

    public SpellCraftingScreen(@NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(spell, "spell");
        super((ITextComponent)new TranslationTextComponent("screen.afraidofthedark.spell_crafting", new Object[0]), true);
        Spell spellClone = new Spell(spell.serializeNBT());
        if (spellClone.getSpellStages().isEmpty()) {
            spellClone.getSpellStages().add(new SpellStage());
        }
        HChainPane layoutPane = new HChainPane(HChainPane.Layout.CLOSE);
        this.getContentPane().add(layoutPane);
        this.getContentPane().setPadding(new Spacing(0.1, false, 2, null));
        this.tablet = new SpellTablet(spellClone);
        layoutPane.add(this.tablet);
        this.scroll = new SpellScroll();
        this.tablet.setComponentEditCallback(new Function1<SpellComponentSlot<?>, Unit>(){

            @Override
            public final void invoke(@NotNull SpellComponentSlot<?> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                scroll.setEditing(it.getComponentInstance());
            }
        });
        layoutPane.add(this.scroll);
        final ImagePane helpOverlay = new ImagePane("afraidofthedark:textures/gui/spell_editor/help_screen.png", ImagePane.DispMode.FIT_TO_PARENT);
        helpOverlay.setVisible(false);
        helpOverlay.addKeyListener(2.INSTANCE);
        this.tablet.setOnHelp(new Function0<Unit>(){

            @Override
            public final void invoke() {
                helpOverlay.setVisible(true);
            }
        });
        this.getContentPane().add(helpOverlay);
        this.getContentPane().addKeyListener((Function1<? super KeyEvent, Unit>)new Function1<KeyEvent, Unit>(){

            @Override
            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == KeyEvent.KeyEventType.Press && tablet.inventoryKeyClosesUI() && scroll.inventoryKeyClosesUI() && this.isInventoryKeybind$afraidofthedark(it.getKey(), it.getScanCode())) {
                    if (scroll.isEditingProps()) {
                        scroll.setEditing(null);
                    } else {
                        Minecraft.func_71410_x().func_147108_a((Screen)new SpellListScreen());
                    }
                }
            }
        });
    }

    @Override
    public boolean inventoryToCloseGuiScreen() {
        return false;
    }

    @Override
    public boolean drawGradientBackground() {
        return true;
    }
}

