/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.standardControls;

import com.davidm1a2.afraidofthedark.client.gui.events.ITextChangeListener;
import com.davidm1a2.afraidofthedark.client.gui.events.KeyEvent;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseEvent;
import com.davidm1a2.afraidofthedark.client.gui.fontLibrary.TrueTypeFont;
import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.layout.Position;
import com.davidm1a2.afraidofthedark.client.gui.layout.Spacing;
import com.davidm1a2.afraidofthedark.client.gui.layout.TextAlignment;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ImagePane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.LabelComponent;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.StackPane;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 62\u00020\u0001:\u00016B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\fH\u0002J\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0015J\b\u0010#\u001a\u00020\u001fH\u0016J\b\u0010$\u001a\u00020\u001fH\u0016J\u0006\u0010%\u001a\u00020\fJ\b\u0010&\u001a\u00020\u0010H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u000e\u0010/\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u00100\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\fJ\u000e\u00101\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0016J\u001a\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\f2\b\b\u0002\u00104\u001a\u00020\fH\u0002J\b\u00105\u001a\u00020\u001fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/TextFieldPane;", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/AOTDPane;", "offset", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Position;", "prefSize", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;", "font", "Lcom/davidm1a2/afraidofthedark/client/gui/fontLibrary/TrueTypeFont;", "(Lcom/davidm1a2/afraidofthedark/client/gui/layout/Position;Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;Lcom/davidm1a2/afraidofthedark/client/gui/fontLibrary/TrueTypeFont;)V", "background", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ImagePane;", "<set-?>", "", "ghostText", "getGhostText", "()Ljava/lang/String;", "", "isFocused", "()Z", "textChangeListeners", "", "Lcom/davidm1a2/afraidofthedark/client/gui/events/ITextChangeListener;", "Ljava/awt/Color;", "textColor", "getTextColor", "()Ljava/awt/Color;", "textContainer", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/StackPane;", "textLabel", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/LabelComponent;", "addText", "", "text", "addTextChangeListener", "listener", "calcChildrenBounds", "draw", "getText", "isShowingGhostText", "keyPressed", "event", "Lcom/davidm1a2/afraidofthedark/client/gui/events/KeyEvent;", "keyTyped", "removeChars", "number", "", "setFocused", "setGhostText", "setText", "setTextColor", "setTextInternal", "rawText", "oldText", "updateScroll", "Companion", "afraidofthedark"})
public final class TextFieldPane
extends AOTDPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ITextChangeListener> textChangeListeners;
    @NotNull
    private final ImagePane background;
    @NotNull
    private final StackPane textContainer;
    @NotNull
    private final LabelComponent textLabel;
    private boolean isFocused;
    @NotNull
    private String ghostText;
    @NotNull
    private Color textColor;
    @NotNull
    private static final Color GHOST_TEXT_COLOR = new Color(128, 128, 128);
    @NotNull
    private static final Color FOCUSED_COLOR_TINT = new Color(230, 230, 230);
    @NotNull
    private static final Color BASE_COLOR_TINT = new Color(255, 255, 255);

    public TextFieldPane(@NotNull Position offset, @NotNull Dimensions prefSize, @NotNull TrueTypeFont font) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        Intrinsics.checkNotNullParameter(prefSize, "prefSize");
        Intrinsics.checkNotNullParameter(font, "font");
        super(offset, prefSize, null, null, null, null, null, 124, null);
        boolean bl = false;
        this.textChangeListeners = new ArrayList();
        this.ghostText = "";
        this.textColor = new Color(255, 255, 255);
        this.background = new ImagePane(new ResourceLocation("afraidofthedark:textures/gui/text_field_background.png"), ImagePane.DispMode.STRETCH);
        this.textContainer = new StackPane(new Dimensions(1.0, 1.0, false, 4, null), null, new Spacing(0.0, 0.0, 0.1, 0.05, false, 16, null), null, null, null, true, 58, null);
        this.textLabel = new LabelComponent(font, new Dimensions(1.0, 1.0, false, 4, null), null, 4, null);
        this.textLabel.setShortenTextToFit(false);
        this.textContainer.add(this.textLabel);
        this.background.add(this.textContainer);
        this.add(this.background);
        this.addMouseListener((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == MouseEvent.EventType.Click && it.getClickedButton() == 0) {
                    this.setFocused(this.isHovered());
                }
            }
        });
        this.addKeyListener((Function1<? super KeyEvent, Unit>)new Function1<KeyEvent, Unit>(){

            @Override
            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == KeyEvent.KeyEventType.Type) {
                    this.keyTyped(it);
                } else if (it.getEventType() == KeyEvent.KeyEventType.Press) {
                    this.keyPressed(it);
                }
            }
        });
    }

    public /* synthetic */ TextFieldPane(Position position, Dimensions dimensions, TrueTypeFont trueTypeFont, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            position = new Position(0.0, 0.0, false, 4, null);
        }
        if ((n & 2) != 0) {
            dimensions = new Dimensions(Double.MAX_VALUE, Double.MAX_VALUE, false, 4, null);
        }
        this(position, dimensions, trueTypeFont);
    }

    public final boolean isFocused() {
        return this.isFocused;
    }

    @NotNull
    public final String getGhostText() {
        return this.ghostText;
    }

    @NotNull
    public final Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            super.draw();
        }
    }

    private final void keyPressed(KeyEvent event) {
        if (this.isFocused && (!event.hasModifier(KeyEvent.Modifier.CONTROL) || event.getKey() != 65)) {
            if (event.hasModifier(KeyEvent.Modifier.CONTROL) && event.getKey() == 67) {
                Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getText());
            } else if (event.hasModifier(KeyEvent.Modifier.CONTROL) && event.getKey() == 86) {
                this.setText("");
                String string = SharedConstants.func_71565_a((String)Minecraft.func_71410_x().field_195559_v.func_197965_a());
                Intrinsics.checkNotNullExpressionValue(string, "filterAllowedCharacters(Minecraft.getInstance().keyboardListener.clipboardString)");
                this.addText(string);
            } else if (event.hasModifier(KeyEvent.Modifier.CONTROL) && event.getKey() == 88) {
                Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getText());
                this.setText("");
            } else {
                int n = event.getKey();
                switch (n) {
                    case 259: {
                        this.removeChars(1);
                    }
                }
            }
        }
    }

    private final void keyTyped(KeyEvent event) {
        if (this.isFocused) {
            String string = SharedConstants.func_71565_a((String)String.valueOf(event.getChar()));
            Intrinsics.checkNotNullExpressionValue(string, "char");
            this.addText(string);
        }
    }

    @NotNull
    public final String getText() {
        String string;
        if (this.isShowingGhostText()) {
            string = "";
        } else if (this.isFocused) {
            String string2 = this.textLabel.getText();
            int n = 0;
            int n2 = this.textLabel.getText().length() - 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = this.textLabel.getText();
        }
        return string;
    }

    public final void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        TextFieldPane.setTextInternal$default(this, text, null, 2, null);
    }

    private final void setTextInternal(String rawText, String oldText) {
        String newText = SharedConstants.func_71565_a((String)rawText);
        if (this.isFocused) {
            this.textLabel.setText(Intrinsics.stringPlus(newText, "_"));
            this.textLabel.setTextColor(this.textColor);
        } else {
            Intrinsics.checkNotNullExpressionValue(newText, "newText");
            CharSequence charSequence = newText;
            boolean bl = false;
            if (charSequence.length() == 0) {
                this.textLabel.setText(this.ghostText);
                this.textLabel.setTextColor(GHOST_TEXT_COLOR);
            } else {
                this.textLabel.setText(newText);
                this.textLabel.setTextColor(this.textColor);
            }
        }
        if (!Intrinsics.areEqual(newText, oldText)) {
            Iterable $this$forEach$iv = this.textChangeListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ITextChangeListener it = (ITextChangeListener)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(newText, "newText");
                it.apply(oldText, newText);
            }
        }
        this.invalidate();
    }

    static /* synthetic */ void setTextInternal$default(TextFieldPane textFieldPane, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = textFieldPane.getText();
        }
        textFieldPane.setTextInternal(string, string2);
    }

    private final void addText(String text) {
        if (!Intrinsics.areEqual(text, "")) {
            this.setText(Intrinsics.stringPlus(this.getText(), text));
        }
    }

    private final void removeChars(int number) {
        String currentText = this.getText();
        int numberClamped = RangesKt.coerceIn(number, 0, currentText.length());
        String string = currentText;
        int n = 0;
        int n2 = currentText.length() - numberClamped;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        this.setText(string3);
    }

    private final void updateScroll() {
        int textWidth = this.textLabel.getFont().getWidth(this.textLabel.getText());
        if (textWidth > this.textLabel.getWidth()) {
            this.textLabel.setTextAlignment(TextAlignment.ALIGN_RIGHT);
        } else {
            this.textLabel.setTextAlignment(TextAlignment.ALIGN_LEFT);
        }
    }

    @Override
    public void calcChildrenBounds() {
        super.calcChildrenBounds();
        this.updateScroll();
    }

    private final void setFocused(boolean isFocused) {
        boolean wasFocused = this.isFocused;
        if (!wasFocused && isFocused) {
            Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
            this.background.setColor(FOCUSED_COLOR_TINT);
            String currentText = this.getText();
            this.isFocused = true;
            this.setTextInternal(currentText, currentText);
        } else if (wasFocused && !isFocused) {
            Minecraft.func_71410_x().field_195559_v.func_197967_a(false);
            this.background.setColor(BASE_COLOR_TINT);
            String currentText = this.getText();
            this.isFocused = false;
            this.setTextInternal(currentText, currentText);
        }
    }

    private final boolean isShowingGhostText() {
        return Intrinsics.areEqual(this.textLabel.getTextColor(), GHOST_TEXT_COLOR) && Intrinsics.areEqual(this.textLabel.getText(), this.ghostText);
    }

    public final void setGhostText(@NotNull String ghostText) {
        Intrinsics.checkNotNullParameter(ghostText, "ghostText");
        boolean ghostTextWasLoaded = this.isShowingGhostText();
        this.ghostText = ghostText;
        if (ghostTextWasLoaded) {
            this.textLabel.setText(this.ghostText);
        } else {
            CharSequence charSequence = this.textLabel.getText();
            boolean bl = false;
            if (charSequence.length() == 0) {
                this.textLabel.setText(this.ghostText);
                this.textLabel.setTextColor(GHOST_TEXT_COLOR);
            }
        }
    }

    public final void setTextColor(@NotNull Color textColor) {
        Intrinsics.checkNotNullParameter(textColor, "textColor");
        this.textColor = textColor;
        if (!this.isShowingGhostText()) {
            this.textLabel.setTextColor(this.textColor);
        }
    }

    public final void addTextChangeListener(@NotNull ITextChangeListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.textChangeListeners.add(listener);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/TextFieldPane$Companion;", "", "()V", "BASE_COLOR_TINT", "Ljava/awt/Color;", "FOCUSED_COLOR_TINT", "GHOST_TEXT_COLOR", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

