/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.standardControls;

import com.davidm1a2.afraidofthedark.client.gui.events.MouseEvent;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseMoveEvent;
import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.layout.Gravity;
import com.davidm1a2.afraidofthedark.client.gui.layout.Position;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ButtonPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ImagePane;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/VScrollBar;", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ImagePane;", "prefSize", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;", "scrollBarTexture", "", "handleTexture", "handleHoveredTexture", "(Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "handle", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ButtonPane;", "handleHeld", "", "onValueChanged", "Ljava/util/function/Consumer;", "", "getOnValueChanged", "()Ljava/util/function/Consumer;", "setOnValueChanged", "(Ljava/util/function/Consumer;)V", "originalMousePressLocation", "", "originalValue", "value", "getValue", "()D", "setValue", "(D)V", "afraidofthedark"})
public final class VScrollBar
extends ImagePane {
    private double value;
    @NotNull
    private final ButtonPane handle;
    private boolean handleHeld;
    private int originalMousePressLocation;
    private double originalValue;
    @NotNull
    private Consumer<Double> onValueChanged;

    @JvmOverloads
    public VScrollBar(@NotNull Dimensions prefSize, @NotNull String scrollBarTexture, @NotNull String handleTexture, @NotNull String handleHoveredTexture) {
        Intrinsics.checkNotNullParameter(prefSize, "prefSize");
        Intrinsics.checkNotNullParameter(scrollBarTexture, "scrollBarTexture");
        Intrinsics.checkNotNullParameter(handleTexture, "handleTexture");
        Intrinsics.checkNotNullParameter(handleHoveredTexture, "handleHoveredTexture");
        super(new ResourceLocation(scrollBarTexture), ImagePane.DispMode.FIT_TO_PARENT);
        this.onValueChanged = VScrollBar::onValueChanged$lambda-0;
        this.setPrefSize(prefSize);
        ImagePane icon = new ImagePane(new ResourceLocation(handleTexture), ImagePane.DispMode.STRETCH);
        ImagePane iconHovered = new ImagePane(new ResourceLocation(handleHoveredTexture), ImagePane.DispMode.STRETCH);
        Gravity gravity = Gravity.CENTER;
        Dimensions dimensions = new Dimensions(1.0, 0.1, false, 4, null);
        this.handle = new ButtonPane(icon, iconHovered, true, null, gravity, null, null, dimensions, null, null, 872, null);
        this.add(this.handle);
        this.handle.addMouseListener((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == MouseEvent.EventType.Click) {
                    if (it.getSource().isHovered() && it.getClickedButton() == 0) {
                        handleHeld = true;
                        originalMousePressLocation = it.getMouseY();
                        originalValue = this.getValue();
                    }
                } else if (it.getEventType() == MouseEvent.EventType.Release && it.getClickedButton() == 0) {
                    handleHeld = false;
                }
            }
        });
        this.handle.addMouseMoveListener((Function1<? super MouseMoveEvent, Unit>)new Function1<MouseMoveEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseMoveEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == MouseMoveEvent.EventType.Move && handleHeld) {
                    int yOffset = it.getMouseY() - originalMousePressLocation;
                    this.setValue(originalValue + (double)yOffset / (double)this.getHeight() / 0.9);
                    this.getOnValueChanged().accept(this.getValue());
                }
            }
        });
        this.setValue(0.0);
    }

    public /* synthetic */ VScrollBar(Dimensions dimensions, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "afraidofthedark:textures/gui/scroll_bar.png";
        }
        if ((n & 4) != 0) {
            string2 = "afraidofthedark:textures/gui/scroll_bar_handle.png";
        }
        if ((n & 8) != 0) {
            string3 = string2;
        }
        this(dimensions, string, string2, string3);
    }

    public final double getValue() {
        return this.value;
    }

    public final void setValue(double value) {
        this.value = RangesKt.coerceIn(value, 0.0, 1.0);
        this.handle.setOffset(new Position(0.0, (this.value - 0.5) * 0.9, false, 4, null));
        this.invalidate();
    }

    @NotNull
    public final Consumer<Double> getOnValueChanged() {
        return this.onValueChanged;
    }

    public final void setOnValueChanged(@NotNull Consumer<Double> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "<set-?>");
        this.onValueChanged = consumer;
    }

    @JvmOverloads
    public VScrollBar(@NotNull Dimensions prefSize, @NotNull String scrollBarTexture, @NotNull String handleTexture) {
        Intrinsics.checkNotNullParameter(prefSize, "prefSize");
        Intrinsics.checkNotNullParameter(scrollBarTexture, "scrollBarTexture");
        Intrinsics.checkNotNullParameter(handleTexture, "handleTexture");
        this(prefSize, scrollBarTexture, handleTexture, null, 8, null);
    }

    @JvmOverloads
    public VScrollBar(@NotNull Dimensions prefSize, @NotNull String scrollBarTexture) {
        Intrinsics.checkNotNullParameter(prefSize, "prefSize");
        Intrinsics.checkNotNullParameter(scrollBarTexture, "scrollBarTexture");
        this(prefSize, scrollBarTexture, null, null, 12, null);
    }

    @JvmOverloads
    public VScrollBar(@NotNull Dimensions prefSize) {
        Intrinsics.checkNotNullParameter(prefSize, "prefSize");
        this(prefSize, null, null, null, 14, null);
    }

    private static final void onValueChanged$lambda-0(Double it) {
        Intrinsics.checkNotNullParameter(it, "it");
    }
}

