/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.block;

import com.davidm1a2.afraidofthedark.common.block.core.AOTDTileEntityBlock;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.tileEntity.EnariaSpawnerTileEntity;
import com.davidm1a2.afraidofthedark.common.tileEntity.GhastlyEnariaSpawnerTileEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.Region;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ToolType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006#"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/EnariaSpawnerBlock;", "Lcom/davidm1a2/afraidofthedark/common/block/core/AOTDTileEntityBlock;", "()V", "createTileEntity", "Lnet/minecraft/tileentity/TileEntity;", "state", "Lnet/minecraft/block/BlockState;", "world", "Lnet/minecraft/world/IBlockReader;", "displayInCreative", "", "fillStateContainer", "", "builder", "Lnet/minecraft/state/StateContainer$Builder;", "Lnet/minecraft/block/Block;", "getHarvestLevel", "", "getHarvestTool", "Lnet/minecraftforge/common/ToolType;", "getRenderType", "Lnet/minecraft/block/BlockRenderType;", "getStateForPlacement", "context", "Lnet/minecraft/item/BlockItemUseContext;", "mirror", "mirrorIn", "Lnet/minecraft/util/Mirror;", "rotate", "rotation", "Lnet/minecraft/util/Rotation;", "Lnet/minecraft/world/IWorld;", "pos", "Lnet/minecraft/util/math/BlockPos;", "Companion", "afraidofthedark"})
public final class EnariaSpawnerBlock
extends AOTDTileEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOGGER = LogManager.getLogger();

    public EnariaSpawnerBlock() {
        Block.Properties properties = Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(10.0f, 50.0f);
        Intrinsics.checkNotNullExpressionValue(properties, "create(Material.ROCK).hardnessAndResistance(10.0f, 50.0f)");
        super("enaria_spawner", properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH));
    }

    @Override
    public boolean displayInCreative() {
        return false;
    }

    public int getHarvestLevel(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        return 3;
    }

    @NotNull
    public ToolType getHarvestTool(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        ToolType toolType = ToolType.PICKAXE;
        Intrinsics.checkNotNullExpressionValue(toolType, "PICKAXE");
        return toolType;
    }

    @NotNull
    public BlockRenderType func_149645_b(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        return BlockRenderType.MODEL;
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull IWorld world, @NotNull BlockPos pos, @NotNull Rotation rotation2) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(rotation2, "rotation");
        Object object = state.func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)rotation2.func_185831_a((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)));
        Intrinsics.checkNotNullExpressionValue(object, "state.with(HorizontalBlock.HORIZONTAL_FACING, rotation.rotate(state.get(HorizontalBlock.HORIZONTAL_FACING)))");
        return (BlockState)object;
    }

    @NotNull
    public BlockState func_185499_a(@NotNull BlockState state, @NotNull Rotation rotation2) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(rotation2, "rotation");
        Object object = state.func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)rotation2.func_185831_a((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)));
        Intrinsics.checkNotNullExpressionValue(object, "state.with(HorizontalBlock.HORIZONTAL_FACING, rotation.rotate(state.get(HorizontalBlock.HORIZONTAL_FACING)))");
        return (BlockState)object;
    }

    @NotNull
    public BlockState func_185471_a(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(mirrorIn, "mirrorIn");
        Object object = state.func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)mirrorIn.func_185803_b((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)));
        Intrinsics.checkNotNullExpressionValue(object, "state.with(HorizontalBlock.HORIZONTAL_FACING, mirrorIn.mirror(state.get(HorizontalBlock.HORIZONTAL_FACING)))");
        return (BlockState)object;
    }

    @NotNull
    public BlockState func_196258_a(@NotNull BlockItemUseContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        Object object = this.func_176223_P().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)context.func_195992_f());
        Intrinsics.checkNotNullExpressionValue(object, "this.defaultState.with(HorizontalBlock.HORIZONTAL_FACING, context.placementHorizontalFacing)");
        return (BlockState)object;
    }

    protected void func_206840_a(@NotNull StateContainer.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        IProperty[] iPropertyArray = new IProperty[]{(IProperty)HorizontalBlock.field_185512_D};
        builder.func_206894_a(iPropertyArray);
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(@NotNull BlockState state, @NotNull IBlockReader world) {
        TileEntity tileEntity;
        DimensionType dimensionType;
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(world, "world");
        IBlockReader iBlockReader = world;
        if (iBlockReader instanceof World) {
            dimensionType = ((World)world).field_73011_w.func_186058_p();
        } else if (iBlockReader instanceof Region) {
            dimensionType = ((Region)world).func_201675_m().func_186058_p();
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Can't determine the world type for IBlockReader ", world.getClass().getSimpleName()));
        }
        DimensionType dimType = dimensionType;
        if (Intrinsics.areEqual(dimType, DimensionType.field_223227_a_)) {
            tileEntity = new EnariaSpawnerTileEntity();
        } else if (Intrinsics.areEqual(dimType.getModType(), (Object)ModDimensions.INSTANCE.getNIGHTMARE())) {
            tileEntity = new GhastlyEnariaSpawnerTileEntity();
        } else {
            LOGGER.warn("BlockEnariaSpawner should not exist in this dimension, defaulting to a NO-OP TileEntity.");
            tileEntity = null;
        }
        return tileEntity;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/EnariaSpawnerBlock$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

