/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.capabilities.world.structureCollisionMap;

import com.davidm1a2.afraidofthedark.common.capabilities.world.structureCollisionMap.BoundingBoxNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u0002H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structureCollisionMap/BoundingBoxTree;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/ListNBT;", "()V", "root", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structureCollisionMap/BoundingBoxNode;", "deserializeNBT", "", "nbt", "insert", "aabb", "Lnet/minecraft/util/math/MutableBoundingBox;", "intersects", "", "aabbOther", "serializeNBT", "afraidofthedark"})
public final class BoundingBoxTree
implements INBTSerializable<ListNBT> {
    @Nullable
    private BoundingBoxNode root;

    public final void insert(@NotNull MutableBoundingBox aabb) {
        Intrinsics.checkNotNullParameter(aabb, "aabb");
        BoundingBoxNode leaf = new BoundingBoxNode(aabb, null, null, 6, null);
        if (this.root == null) {
            this.root = leaf;
            return;
        }
        BoundingBoxNode boundingBoxNode = this.root;
        Intrinsics.checkNotNull(boundingBoxNode);
        if (boundingBoxNode.getLeftChild() == null) {
            boundingBoxNode = this.root;
            Intrinsics.checkNotNull(boundingBoxNode);
            boundingBoxNode.setLeftChild(leaf);
            boundingBoxNode = this.root;
            Intrinsics.checkNotNull(boundingBoxNode);
            boundingBoxNode.recalculateSize();
            return;
        }
        boundingBoxNode = this.root;
        Intrinsics.checkNotNull(boundingBoxNode);
        if (boundingBoxNode.getRightChild() == null) {
            boundingBoxNode = this.root;
            Intrinsics.checkNotNull(boundingBoxNode);
            boundingBoxNode.setRightChild(leaf);
            boundingBoxNode = this.root;
            Intrinsics.checkNotNull(boundingBoxNode);
            boundingBoxNode.recalculateSize();
            return;
        }
        boolean bl = false;
        List nodePath = new ArrayList();
        BoundingBoxNode boundingBoxNode2 = this.root;
        Intrinsics.checkNotNull(boundingBoxNode2);
        BoundingBoxNode currentNode = boundingBoxNode2;
        nodePath.add(currentNode);
        while (!currentNode.isLeaf()) {
            BoundingBoxNode boundingBoxNode3;
            BoundingBoxNode boundingBoxNode4 = currentNode.getLeftChild();
            Intrinsics.checkNotNull(boundingBoxNode4);
            int leftAreaDiff = boundingBoxNode4.computeAreaDiffIfContaining(leaf);
            BoundingBoxNode boundingBoxNode5 = currentNode.getRightChild();
            Intrinsics.checkNotNull(boundingBoxNode5);
            int rightAreaDiff = boundingBoxNode5.computeAreaDiffIfContaining(leaf);
            if (leftAreaDiff < rightAreaDiff) {
                boundingBoxNode5 = currentNode.getLeftChild();
                Intrinsics.checkNotNull(boundingBoxNode5);
                boundingBoxNode3 = boundingBoxNode5;
            } else {
                boundingBoxNode5 = currentNode.getRightChild();
                Intrinsics.checkNotNull(boundingBoxNode5);
                boundingBoxNode3 = boundingBoxNode5;
            }
            currentNode = boundingBoxNode3;
            nodePath.add(currentNode);
        }
        BoundingBoxNode newBranch = new BoundingBoxNode(currentNode, leaf);
        BoundingBoxNode parentNode = (BoundingBoxNode)nodePath.get(nodePath.size() - 2);
        if (Intrinsics.areEqual(parentNode.getLeftChild(), currentNode)) {
            parentNode.setLeftChild(newBranch);
        } else {
            parentNode.setRightChild(newBranch);
        }
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable(nodePath);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BoundingBoxNode it = (BoundingBoxNode)element$iv;
            boolean bl2 = false;
            it.recalculateSize();
        }
    }

    public final boolean intersects(@NotNull MutableBoundingBox aabbOther) {
        Intrinsics.checkNotNullParameter(aabbOther, "aabbOther");
        if (this.root == null) {
            return false;
        }
        Stack<BoundingBoxNode> stack = new Stack<BoundingBoxNode>();
        stack.push(this.root);
        while (true) {
            BoundingBoxNode it;
            boolean bl;
            boolean bl2;
            BoundingBoxNode boundingBoxNode;
            Collection collection = stack;
            boolean bl3 = false;
            if (!(!collection.isEmpty())) break;
            BoundingBoxNode next = (BoundingBoxNode)stack.pop();
            if (!next.intersects(aabbOther)) continue;
            if (next.isLeaf()) {
                return true;
            }
            BoundingBoxNode boundingBoxNode2 = next.getLeftChild();
            if (boundingBoxNode2 != null) {
                boundingBoxNode = boundingBoxNode2;
                bl2 = false;
                bl = false;
                it = boundingBoxNode;
                boolean bl4 = false;
                stack.push(it);
            }
            boundingBoxNode2 = next.getRightChild();
            if (boundingBoxNode2 == null) continue;
            boundingBoxNode = boundingBoxNode2;
            bl2 = false;
            bl = false;
            it = boundingBoxNode;
            boolean bl5 = false;
            stack.push(it);
        }
        return false;
    }

    public void deserializeNBT(@NotNull ListNBT nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        this.root = null;
        int n = nbt.size();
        int n2 = 0;
        int n3 = ProgressionUtilKt.getProgressionLastElement(0, n, 6);
        if (n2 <= n3) {
            int i;
            do {
                i = n2;
                n2 += 6;
                this.insert(new MutableBoundingBox(nbt.func_186858_c(i + 0), nbt.func_186858_c(i + 1), nbt.func_186858_c(i + 2), nbt.func_186858_c(i + 3), nbt.func_186858_c(i + 4), nbt.func_186858_c(i + 5)));
            } while (i != n3);
        }
    }

    @NotNull
    public ListNBT serializeNBT() {
        ListNBT toReturn = new ListNBT();
        if (this.root == null) {
            return toReturn;
        }
        Stack<BoundingBoxNode> stack = new Stack<BoundingBoxNode>();
        Object object = this.root;
        Intrinsics.checkNotNull(object);
        stack.push((BoundingBoxNode)object);
        while (true) {
            BoundingBoxNode it;
            boolean bl;
            boolean bl2;
            BoundingBoxNode boundingBoxNode;
            object = stack;
            boolean bl3 = false;
            if (!(!object.isEmpty())) break;
            BoundingBoxNode node = (BoundingBoxNode)stack.pop();
            if (node.isLeaf()) {
                node.writeToList(toReturn);
                continue;
            }
            BoundingBoxNode boundingBoxNode2 = node.getLeftChild();
            if (boundingBoxNode2 != null) {
                boundingBoxNode = boundingBoxNode2;
                bl2 = false;
                bl = false;
                it = boundingBoxNode;
                boolean bl4 = false;
                stack.push(it);
            }
            boundingBoxNode2 = node.getRightChild();
            if (boundingBoxNode2 == null) continue;
            boundingBoxNode = boundingBoxNode2;
            bl2 = false;
            bl = false;
            it = boundingBoxNode;
            boolean bl5 = false;
            stack.push(it);
        }
        return toReturn;
    }
}

