/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.config;

import com.davidm1a2.afraidofthedark.common.constants.ModCommonConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/davidm1a2/afraidofthedark/common/config/CommonConfig;", "", "builder", "Lnet/minecraftforge/common/ForgeConfigSpec$Builder;", "(Lnet/minecraftforge/common/ForgeConfigSpec$Builder;)V", "cacheStructures", "Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;", "cacheTimeout", "Lnet/minecraftforge/common/ForgeConfigSpec$LongValue;", "cryptMultiplier", "Lnet/minecraftforge/common/ForgeConfigSpec$DoubleValue;", "darkForestMultiplier", "desertOasisMultiplier", "eerieBiomeFrequency", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "gnomishCityMultiplier", "observatoryMultiplier", "voidChestMultiplier", "witchHutMultiplier", "reload", "", "afraidofthedark"})
public final class CommonConfig {
    @NotNull
    private final ForgeConfigSpec.DoubleValue cryptMultiplier;
    @NotNull
    private final ForgeConfigSpec.DoubleValue darkForestMultiplier;
    @NotNull
    private final ForgeConfigSpec.DoubleValue gnomishCityMultiplier;
    @NotNull
    private final ForgeConfigSpec.DoubleValue voidChestMultiplier;
    @NotNull
    private final ForgeConfigSpec.DoubleValue witchHutMultiplier;
    @NotNull
    private final ForgeConfigSpec.DoubleValue desertOasisMultiplier;
    @NotNull
    private final ForgeConfigSpec.DoubleValue observatoryMultiplier;
    @NotNull
    private final ForgeConfigSpec.IntValue eerieBiomeFrequency;
    @NotNull
    private final ForgeConfigSpec.BooleanValue cacheStructures;
    @NotNull
    private final ForgeConfigSpec.LongValue cacheTimeout;

    public CommonConfig(@NotNull ForgeConfigSpec.Builder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        builder.push("dungeon_frequency");
        ForgeConfigSpec.DoubleValue doubleValue = builder.comment("Increases the number of Crypts in the world by the multiplier specified.").translation("config.afraidofthedark:crypt_multiplier").defineInRange("crypt_multiplier", 1.0, 0.0, 100.0);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"Increases the number of Crypts in the world by the multiplier specified.\")\n            .translation(\"config.afraidofthedark:crypt_multiplier\")\n            .defineInRange(\"crypt_multiplier\", 1.0, 0.0, 100.0)");
        this.cryptMultiplier = doubleValue;
        doubleValue = builder.comment("Increases the number of Dark Forests in the world by the multiplier specified.").translation("config.afraidofthedark:dark_forest_multiplier").defineInRange("dark_forest_multiplier", 1.0, 0.0, 100.0);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"Increases the number of Dark Forests in the world by the multiplier specified.\")\n            .translation(\"config.afraidofthedark:dark_forest_multiplier\")\n            .defineInRange(\"dark_forest_multiplier\", 1.0, 0.0, 100.0)");
        this.darkForestMultiplier = doubleValue;
        doubleValue = builder.comment("Increases the number of Gnomish Cities in the world by the multiplier specified.").translation("config.afraidofthedark:gnomish_city_multiplier").defineInRange("gnomish_city_multiplier", 1.0, 0.0, 100.0);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"Increases the number of Gnomish Cities in the world by the multiplier specified.\")\n            .translation(\"config.afraidofthedark:gnomish_city_multiplier\")\n            .defineInRange(\"gnomish_city_multiplier\", 1.0, 0.0, 100.0)");
        this.gnomishCityMultiplier = doubleValue;
        doubleValue = builder.comment("Increases the number of Void Chests in the world by the multiplier specified.").translation("config.afraidofthedark:void_chest_multiplier").defineInRange("void_chest_multiplier", 1.0, 0.0, 100.0);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"Increases the number of Void Chests in the world by the multiplier specified.\")\n            .translation(\"config.afraidofthedark:void_chest_multiplier\")\n            .defineInRange(\"void_chest_multiplier\", 1.0, 0.0, 100.0)");
        this.voidChestMultiplier = doubleValue;
        doubleValue = builder.comment("Increases the number of Witch Huts in the world by the multiplier specified.").translation("config.afraidofthedark:witch_hut_multiplier").defineInRange("witch_hut_multiplier", 1.0, 0.0, 100.0);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"Increases the number of Witch Huts in the world by the multiplier specified.\")\n            .translation(\"config.afraidofthedark:witch_hut_multiplier\")\n            .defineInRange(\"witch_hut_multiplier\", 1.0, 0.0, 100.0)");
        this.witchHutMultiplier = doubleValue;
        doubleValue = builder.comment("Increases the number of Desert Oasis in the world by the multiplier specified.").translation("config.afraidofthedark:desert_oasis_multiplier").defineInRange("desert_oasis_multiplier", 1.0, 0.0, 100.0);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"Increases the number of Desert Oasis in the world by the multiplier specified.\")\n            .translation(\"config.afraidofthedark:desert_oasis_multiplier\")\n            .defineInRange(\"desert_oasis_multiplier\", 1.0, 0.0, 100.0)");
        this.desertOasisMultiplier = doubleValue;
        doubleValue = builder.comment("Increases the number of Observatories in the world by the multiplier specified.").translation("config.afraidofthedark:observatory_multiplier").defineInRange("observatory_multiplier", 1.0, 0.0, 100.0);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"Increases the number of Observatories in the world by the multiplier specified.\")\n            .translation(\"config.afraidofthedark:observatory_multiplier\")\n            .defineInRange(\"observatory_multiplier\", 1.0, 0.0, 100.0)");
        this.observatoryMultiplier = doubleValue;
        builder.pop();
        builder.push("world_generation");
        doubleValue = builder.comment("Increase this value to increase the number of Eerie Biomes. 10 is the default MC forest value.").translation("config.afraidofthedark:eerie_biome_frequency").defineInRange("eerie_biome_frequency", 10, 0, 1000);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"Increase this value to increase the number of Eerie Biomes. 10 is the default MC forest value.\")\n            .translation(\"config.afraidofthedark:eerie_biome_frequency\")\n            .defineInRange(\"eerie_biome_frequency\", 10, 0, 1000)");
        this.eerieBiomeFrequency = doubleValue;
        doubleValue = builder.comment("True means structures will be loaded into computer memory when Minecraft is started up. This will accelerate world generation at the cost of RAM usage. False means structures will be loaded when needed, which will require less RAM but can incur lag spikes when finding structures.").translation("config.afraidofthedark:cache_structures").define("cache_structures", true);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"True means structures will be loaded into computer memory when Minecraft is started up. This will accelerate world generation at the cost of RAM usage. False means structures will be loaded when needed, which will require less RAM but can incur lag spikes when finding structures.\")\n            .translation(\"config.afraidofthedark:cache_structures\")\n            .define(\"cache_structures\", true)");
        this.cacheStructures = doubleValue;
        doubleValue = builder.comment("Required if 'Cache Structures' is set to false, otherwise ignored. If a structure isn't needed for 'Cache Timeout' milliseconds it will be forgotten and cleared from RAM.").translation("config.afraidofthedark:cache_timeout").defineInRange("cache_timeout", 60000L, 10000L, Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue(doubleValue, "builder\n            .comment(\"Required if 'Cache Structures' is set to false, otherwise ignored. If a structure isn't needed for 'Cache Timeout' milliseconds it will be forgotten and cleared from RAM.\")\n            .translation(\"config.afraidofthedark:cache_timeout\")\n            .defineInRange(\"cache_timeout\", 60000L, 10000L, Long.MAX_VALUE)");
        this.cacheTimeout = doubleValue;
        builder.pop();
    }

    public final void reload() {
        Object object = this.cryptMultiplier.get();
        Intrinsics.checkNotNullExpressionValue(object, "cryptMultiplier.get()");
        ModCommonConfiguration.INSTANCE.setCryptMultiplier(((Number)object).doubleValue());
        object = this.darkForestMultiplier.get();
        Intrinsics.checkNotNullExpressionValue(object, "darkForestMultiplier.get()");
        ModCommonConfiguration.INSTANCE.setDarkForestMultiplier(((Number)object).doubleValue());
        object = this.gnomishCityMultiplier.get();
        Intrinsics.checkNotNullExpressionValue(object, "gnomishCityMultiplier.get()");
        ModCommonConfiguration.INSTANCE.setGnomishCityFrequency(((Number)object).doubleValue());
        object = this.voidChestMultiplier.get();
        Intrinsics.checkNotNullExpressionValue(object, "voidChestMultiplier.get()");
        ModCommonConfiguration.INSTANCE.setVoidChestMultiplier(((Number)object).doubleValue());
        object = this.witchHutMultiplier.get();
        Intrinsics.checkNotNullExpressionValue(object, "witchHutMultiplier.get()");
        ModCommonConfiguration.INSTANCE.setWitchHutMultiplier(((Number)object).doubleValue());
        object = this.desertOasisMultiplier.get();
        Intrinsics.checkNotNullExpressionValue(object, "desertOasisMultiplier.get()");
        ModCommonConfiguration.INSTANCE.setDesertOasisMultiplier(((Number)object).doubleValue());
        object = this.observatoryMultiplier.get();
        Intrinsics.checkNotNullExpressionValue(object, "observatoryMultiplier.get()");
        ModCommonConfiguration.INSTANCE.setObservatoryMultiplier(((Number)object).doubleValue());
        object = this.eerieBiomeFrequency.get();
        Intrinsics.checkNotNullExpressionValue(object, "eerieBiomeFrequency.get()");
        ModCommonConfiguration.INSTANCE.setEerieBiomeFrequency(((Number)object).intValue());
        object = this.cacheStructures.get();
        Intrinsics.checkNotNullExpressionValue(object, "cacheStructures.get()");
        ModCommonConfiguration.INSTANCE.setCacheStructures((Boolean)object);
        object = this.cacheTimeout.get();
        Intrinsics.checkNotNullExpressionValue(object, "cacheTimeout.get()");
        ModCommonConfiguration.INSTANCE.setCacheTimeout(((Number)object).longValue());
    }
}

