/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.bolt;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B7\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020+H\u0014R\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006,"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/bolt/BoltEntity;", "Lnet/minecraft/entity/projectile/AbstractArrowEntity;", "entityType", "Lnet/minecraft/entity/EntityType;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", "x", "", "y", "z", "(Lnet/minecraft/entity/EntityType;DDDLnet/minecraft/world/World;)V", "thrower", "Lnet/minecraft/entity/LivingEntity;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/world/World;)V", "chanceToDropHitEntity", "getChanceToDropHitEntity", "()D", "chanceToDropHitGround", "getChanceToDropHitGround", "damage", "", "getDamage", "()I", "damageSourceProducer", "Lkotlin/Function1;", "Lnet/minecraft/entity/player/PlayerEntity;", "Lnet/minecraft/util/DamageSource;", "getDamageSourceProducer", "()Lkotlin/jvm/functions/Function1;", "drop", "Lnet/minecraft/item/Item;", "getDrop", "()Lnet/minecraft/item/Item;", "createSpawnPacket", "Lnet/minecraft/network/IPacket;", "func_213868_a", "", "result", "Lnet/minecraft/util/math/EntityRayTraceResult;", "getArrowStack", "Lnet/minecraft/item/ItemStack;", "onHit", "Lnet/minecraft/util/math/RayTraceResult;", "afraidofthedark"})
public abstract class BoltEntity
extends AbstractArrowEntity {
    private final int damage;
    private final double chanceToDropHitEntity;
    private final double chanceToDropHitGround;

    @NotNull
    public abstract Function1<PlayerEntity, DamageSource> getDamageSourceProducer();

    @NotNull
    public abstract Item getDrop();

    public int getDamage() {
        return this.damage;
    }

    public double getChanceToDropHitEntity() {
        return this.chanceToDropHitEntity;
    }

    public double getChanceToDropHitGround() {
        return this.chanceToDropHitGround;
    }

    public BoltEntity(@NotNull EntityType<? extends BoltEntity> entityType, @NotNull World world) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        Intrinsics.checkNotNullParameter(world, "world");
        super(entityType, world);
        this.damage = 6;
        this.chanceToDropHitEntity = 0.4;
        this.chanceToDropHitGround = 0.8;
    }

    public BoltEntity(@NotNull EntityType<? extends BoltEntity> entityType, double x, double y, double z, @NotNull World world) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        Intrinsics.checkNotNullParameter(world, "world");
        super(entityType, x, y, z, world);
        this.damage = 6;
        this.chanceToDropHitEntity = 0.4;
        this.chanceToDropHitGround = 0.8;
    }

    public BoltEntity(@NotNull EntityType<? extends BoltEntity> entityType, @NotNull LivingEntity thrower, @NotNull World world) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        Intrinsics.checkNotNullParameter(thrower, "thrower");
        Intrinsics.checkNotNullParameter(world, "world");
        super(entityType, thrower, world);
        this.damage = 6;
        this.chanceToDropHitEntity = 0.4;
        this.chanceToDropHitGround = 0.8;
    }

    protected void func_184549_a(@NotNull RayTraceResult result) {
        Intrinsics.checkNotNullParameter(result, "result");
        super.func_184549_a(result);
        if (!this.field_70170_p.field_72995_K) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entityHit = ((EntityRayTraceResult)result).func_216348_a();
                if (this.func_212360_k() instanceof PlayerEntity) {
                    Entity entity = this.func_212360_k();
                    if (entity == null) {
                        throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.PlayerEntity");
                    }
                    entityHit.func_70097_a(this.getDamageSourceProducer().invoke((PlayerEntity)entity), (float)this.getDamage());
                }
                if (Math.random() >= this.getChanceToDropHitEntity()) {
                    this.func_70106_y();
                }
            } else if (Math.random() >= this.getChanceToDropHitGround()) {
                this.func_70106_y();
            }
        }
    }

    protected void func_213868_a(@NotNull EntityRayTraceResult result) {
        Intrinsics.checkNotNullParameter(result, "result");
    }

    @NotNull
    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)this.getDrop());
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        IPacket iPacket = NetworkHooks.getEntitySpawningPacket((Entity)((Entity)this));
        Intrinsics.checkNotNullExpressionValue(iPacket, "getEntitySpawningPacket(this)");
        return iPacket;
    }
}

