/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib;

import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple4f;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\"\u0010\b\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u0002*\u00020\u0002\u00a8\u0006\u000e"}, d2={"intoArray", "", "Ljavax/vecmath/Matrix4f;", "isEmptyRotationMatrix", "", "setAndReturn", "quat4f", "Ljavax/vecmath/Quat4f;", "slerp", "q1", "q2", "t", "", "transposeAndReturn", "afraidofthedark"})
public final class MathExtensionsKt {
    @NotNull
    public static final Matrix4f setAndReturn(@NotNull Matrix4f $this$setAndReturn, @NotNull Quat4f quat4f) {
        Intrinsics.checkNotNullParameter($this$setAndReturn, "<this>");
        Intrinsics.checkNotNullParameter(quat4f, "quat4f");
        $this$setAndReturn.set(quat4f);
        return $this$setAndReturn;
    }

    @NotNull
    public static final Matrix4f transposeAndReturn(@NotNull Matrix4f $this$transposeAndReturn) {
        Intrinsics.checkNotNullParameter($this$transposeAndReturn, "<this>");
        $this$transposeAndReturn.transpose();
        return $this$transposeAndReturn;
    }

    @NotNull
    public static final Quat4f slerp(@NotNull Quat4f $this$slerp, @NotNull Quat4f q1, @NotNull Quat4f q2, float t) {
        Intrinsics.checkNotNullParameter($this$slerp, "<this>");
        Intrinsics.checkNotNullParameter(q1, "q1");
        Intrinsics.checkNotNullParameter(q2, "q2");
        if (q1.x == q2.x && q1.y == q2.y && q1.z == q2.z && q1.w == q2.w) {
            $this$slerp.set((Tuple4f)q1);
            return $this$slerp;
        }
        float result = q1.x * q2.x + q1.y * q2.y + q1.z * q2.z + q1.w * q2.w;
        if (result < 0.0f) {
            q2.x = -q2.x;
            q2.y = -q2.y;
            q2.z = -q2.z;
            q2.w = -q2.w;
            result = -result;
        }
        float scale0 = 1.0f - t;
        float scale1 = t;
        if (1.0f - result > 0.1f) {
            boolean bl = false;
            float theta = (float)Math.acos(result);
            boolean bl2 = false;
            float invSinTheta = 1.0f / (float)Math.sin(theta);
            float f = (1.0f - t) * theta;
            boolean bl3 = false;
            scale0 = (float)Math.sin(f) * invSinTheta;
            f = t * theta;
            bl3 = false;
            scale1 = (float)Math.sin(f) * invSinTheta;
        }
        $this$slerp.x = scale0 * q1.x + scale1 * q2.x;
        $this$slerp.y = scale0 * q1.y + scale1 * q2.y;
        $this$slerp.z = scale0 * q1.z + scale1 * q2.z;
        $this$slerp.w = scale0 * q1.w + scale1 * q2.w;
        return $this$slerp;
    }

    @NotNull
    public static final float[] intoArray(@NotNull Matrix4f $this$intoArray) {
        Intrinsics.checkNotNullParameter($this$intoArray, "<this>");
        float[] fArray = new float[]{$this$intoArray.m00, $this$intoArray.m01, $this$intoArray.m02, $this$intoArray.m03, $this$intoArray.m10, $this$intoArray.m11, $this$intoArray.m12, $this$intoArray.m13, $this$intoArray.m20, $this$intoArray.m21, $this$intoArray.m22, $this$intoArray.m23, $this$intoArray.m30, $this$intoArray.m31, $this$intoArray.m32, $this$intoArray.m33};
        return fArray;
    }

    public static final boolean isEmptyRotationMatrix(@NotNull Matrix4f $this$isEmptyRotationMatrix) {
        Intrinsics.checkNotNullParameter($this$isEmptyRotationMatrix, "<this>");
        if ($this$isEmptyRotationMatrix.m00 == 1.0f && $this$isEmptyRotationMatrix.m11 == 1.0f && $this$isEmptyRotationMatrix.m22 == 1.0f) {
            float[] m = MathExtensionsKt.intoArray($this$isEmptyRotationMatrix);
            boolean isEmptyRotationMatrix = true;
            int n = 0;
            int n2 = m.length + -1;
            if (n <= n2) {
                do {
                    int i;
                    if ((i = n++) == 0 || i == 5 || i == 10 || i > 10 || m[i] == 0.0f) continue;
                    isEmptyRotationMatrix = false;
                    break;
                } while (n <= n2);
            }
            return isEmptyRotationMatrix;
        }
        return false;
    }
}

