/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib;

import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.MathExtensionsKt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/Utils;", "", "()V", "getQuat4fFromMatrix", "Ljavax/vecmath/Quat4f;", "matrix", "Ljavax/vecmath/Matrix4f;", "makeFloatBuffer", "Ljava/nio/FloatBuffer;", "arr", "", "afraidofthedark"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @NotNull
    public final FloatBuffer makeFloatBuffer(@NotNull float[] arr) {
        Intrinsics.checkNotNullParameter(arr, "arr");
        ByteBuffer bb = ByteBuffer.allocateDirect(arr.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(arr);
        fb.position(0);
        Intrinsics.checkNotNullExpressionValue(fb, "fb");
        return fb;
    }

    @NotNull
    public final Quat4f getQuat4fFromMatrix(@NotNull Matrix4f matrix) {
        Intrinsics.checkNotNullParameter(matrix, "matrix");
        Matrix4f copy = MathExtensionsKt.transposeAndReturn(new Matrix4f(matrix));
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float w = 0.0f;
        double t = 1.0 + (double)copy.m00 + (double)copy.m11 + (double)copy.m22;
        double s = 0.0;
        if (t > 1.0E-8) {
            boolean bl = false;
            s = Math.sqrt(t) * (double)2;
            x = (float)((double)(copy.m12 - copy.m21) / s);
            y = (float)((double)(copy.m02 - copy.m20) / s);
            z = (float)((double)(copy.m10 - copy.m01) / s);
            w = (float)(0.25 * s);
        } else if (t == 0.0) {
            if (copy.m00 > copy.m11 && copy.m00 > copy.m22) {
                double d = 1.0 + (double)copy.m00 - (double)copy.m11 - (double)copy.m22;
                boolean bl = false;
                s = Math.sqrt(d) * (double)2;
                x = (float)(0.25 * s);
                y = (float)((double)(copy.m10 + copy.m01) / s);
                z = (float)((double)(copy.m02 + copy.m20) / s);
                w = (float)((double)(copy.m21 - copy.m12) / s);
            } else if (copy.m11 > copy.m22) {
                double d = 1.0 + (double)copy.m11 - (double)copy.m00 - (double)copy.m22;
                boolean bl = false;
                s = Math.sqrt(d) * (double)2;
                x = (float)((double)(copy.m10 + copy.m01) / s);
                y = (float)(0.25 * s);
                z = (float)((double)(copy.m21 + copy.m12) / s);
                w = (float)((double)(copy.m02 - copy.m20) / s);
            } else {
                double d = 1.0 + (double)copy.m22 - (double)copy.m00 - (double)copy.m11;
                boolean bl = false;
                s = Math.sqrt(d) * (double)2;
                x = (float)((double)(copy.m02 + copy.m20) / s);
                y = (float)((double)(copy.m21 + copy.m12) / s);
                z = (float)(0.25 * s);
                w = (float)((double)(copy.m10 - copy.m01) / s);
            }
        }
        return new Quat4f(x, y, z, w);
    }
}

