/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.splinterDrone;

import com.davidm1a2.afraidofthedark.common.constants.ModDamageSources;
import com.davidm1a2.afraidofthedark.common.constants.ModEntities;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.IMCAnimatedModel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.AnimationHandler;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.Channel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.ChannelMode;
import com.davidm1a2.afraidofthedark.common.entity.splinterDrone.SplinterDroneEntity;
import com.davidm1a2.afraidofthedark.common.entity.splinterDrone.animation.SpingChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bB\u001d\u0012\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0001H\u0014J\f\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\b\u0010 \u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\u0018H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0017J\b\u0010#\u001a\u00020\u0018H\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020\u001aH\u0014J\b\u0010+\u001a\u00020\u001aH\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0014R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/splinterDrone/SplinterDroneProjectileEntity;", "Lnet/minecraft/entity/Entity;", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/IMCAnimatedModel;", "world", "Lnet/minecraft/world/World;", "shootingEntity", "Lcom/davidm1a2/afraidofthedark/common/entity/splinterDrone/SplinterDroneEntity;", "xVelocity", "", "yVelocity", "zVelocity", "(Lnet/minecraft/world/World;Lcom/davidm1a2/afraidofthedark/common/entity/splinterDrone/SplinterDroneEntity;DDD)V", "entityType", "Lnet/minecraft/entity/EntityType;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", "animHandler", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/AnimationHandler;", "ticksInAir", "", "attackEntityFrom", "", "source", "Lnet/minecraft/util/DamageSource;", "amount", "", "baseTick", "", "canBeCollidedWith", "canBeRidden", "entityIn", "createSpawnPacket", "Lnet/minecraft/network/IPacket;", "getAnimationHandler", "getBrightness", "getBrightnessForRender", "getCollisionBorderSize", "onImpact", "result", "Lnet/minecraft/util/math/RayTraceResult;", "readAdditional", "compound", "Lnet/minecraft/nbt/CompoundNBT;", "registerData", "tick", "writeAdditional", "Companion", "afraidofthedark"})
public final class SplinterDroneProjectileEntity
extends Entity
implements IMCAnimatedModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SplinterDroneEntity shootingEntity;
    @NotNull
    private final AnimationHandler animHandler;
    private int ticksInAir;
    private static final double PROJECTILE_SPEED = 0.5;

    public SplinterDroneProjectileEntity(@NotNull EntityType<? extends SplinterDroneProjectileEntity> entityType, @NotNull World world) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        Intrinsics.checkNotNullParameter(world, "world");
        super(entityType, world);
        Channel[] channelArray = new Channel[]{new SpingChannel("Sping", 100.0f, 100, ChannelMode.LINEAR)};
        this.animHandler = new AnimationHandler(channelArray);
    }

    public SplinterDroneProjectileEntity(@NotNull World world, @NotNull SplinterDroneEntity shootingEntity, double xVelocity, double yVelocity, double zVelocity) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(shootingEntity, "shootingEntity");
        this(ModEntities.INSTANCE.getSPLINTER_DRONE_PROJECTILE(), world);
        this.shootingEntity = shootingEntity;
        this.func_70012_b(shootingEntity.field_70165_t, shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e(), shootingEntity.field_70161_v, shootingEntity.field_70177_z, shootingEntity.field_70125_A);
        double d = xVelocity * xVelocity + yVelocity * yVelocity + zVelocity * zVelocity;
        boolean bl = false;
        double velocityMagnitude = Math.sqrt(d);
        this.func_213317_d(new Vec3d(xVelocity / velocityMagnitude * 0.5, yVelocity / velocityMagnitude * 0.5, zVelocity / velocityMagnitude * 0.5));
    }

    protected void func_70088_a() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70071_h_() {
        block7: {
            block6: {
                super.func_70071_h_();
                if (this.field_70170_p.field_72995_K) {
                    this.animHandler.update();
                }
                if (this.field_70170_p.field_72995_K) return;
                if (this.shootingEntity == null) break block6;
                SplinterDroneEntity splinterDroneEntity = this.shootingEntity;
                Intrinsics.checkNotNull(splinterDroneEntity);
                if (!splinterDroneEntity.func_70089_S()) break block7;
            }
            if (this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
                ++this.ticksInAir;
                RayTraceResult rayTraceResult = ProjectileHelper.func_221266_a((Entity)this, (boolean)true, (this.ticksInAir >= 25 ? 1 : 0) != 0, (Entity)((Entity)this.shootingEntity), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER);
                if (rayTraceResult.func_216346_c() != RayTraceResult.Type.MISS) {
                    Intrinsics.checkNotNullExpressionValue(rayTraceResult, "rayTraceResult");
                    this.onImpact(rayTraceResult);
                }
                this.func_70107_b(this.field_70165_t + this.func_213322_ci().field_72450_a, this.field_70163_u + this.func_213322_ci().field_72448_b, this.field_70161_v + this.func_213322_ci().field_72449_c);
                return;
            }
        }
        this.func_70106_y();
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K && !this.animHandler.isAnimationActive("Sping")) {
            AnimationHandler.playAnimation$default(this.animHandler, "Sping", 0.0f, 2, null);
        }
    }

    private final void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result instanceof EntityRayTraceResult && ((EntityRayTraceResult)result).func_216348_a().func_70097_a(ModDamageSources.INSTANCE.causePlasmaBallDamage(this, this.shootingEntity), 1.0f) && ((EntityRayTraceResult)result).func_216348_a() instanceof PlayerEntity) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                if (entity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.PlayerEntity");
                }
                PlayerEntity entityPlayer = (PlayerEntity)entity;
                entityPlayer.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 2, false, false));
            }
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 0.4f;
    }

    public boolean func_70097_a(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter(source, "source");
        return false;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    protected boolean func_184228_n(@NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter(entityIn, "entityIn");
        return false;
    }

    @Override
    @NotNull
    public AnimationHandler getAnimationHandler() {
        return this.animHandler;
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        IPacket iPacket = NetworkHooks.getEntitySpawningPacket((Entity)this);
        Intrinsics.checkNotNullExpressionValue(iPacket, "getEntitySpawningPacket(this)");
        return iPacket;
    }

    protected void func_213281_b(@NotNull CompoundNBT compound) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        this.ticksInAir = compound.func_74762_e("ticks_in_air");
    }

    protected void func_70037_a(@NotNull CompoundNBT compound) {
        Intrinsics.checkNotNullParameter(compound, "compound");
        compound.func_74768_a("ticks_in_air", this.ticksInAir);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/splinterDrone/SplinterDroneProjectileEntity$Companion;", "", "()V", "PROJECTILE_SPEED", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

