/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityProvider;
import com.davidm1a2.afraidofthedark.common.capabilities.player.basics.IAOTDPlayerBasics;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IPlayerNightmareData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IPlayerVoidChestData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IPlayerResearch;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.component.IPlayerSpellCharmData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.component.IPlayerSpellFreezeData;
import com.davidm1a2.afraidofthedark.common.capabilities.world.islandVisitors.IWorldIslandVisitors;
import com.davidm1a2.afraidofthedark.common.capabilities.world.spell.IWorldSpellStates;
import com.davidm1a2.afraidofthedark.common.capabilities.world.structureCollisionMap.IWorldStructureCollisionMap;
import com.davidm1a2.afraidofthedark.common.capabilities.world.structureMissCounter.IWorldStructureMissCounter;
import com.davidm1a2.afraidofthedark.common.constants.ModCapabilities;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/CapabilityHandler;", "", "()V", "onAttachCapabilitiesEntity", "", "event", "Lnet/minecraftforge/event/AttachCapabilitiesEvent;", "Lnet/minecraft/entity/Entity;", "onAttachCapabilitiesWorld", "Lnet/minecraft/world/World;", "onClonePlayer", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "onEntityJoinWorld", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "afraidofthedark"})
public final class CapabilityHandler {
    @SubscribeEvent
    public final void onAttachCapabilitiesWorld(@NotNull AttachCapabilitiesEvent<World> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = (World)event.getObject();
        if (!world.field_72995_K) {
            event.addCapability(new ResourceLocation("afraidofthedark", "spell_states"), (ICapabilityProvider)new CapabilityProvider<IWorldSpellStates>(ModCapabilities.INSTANCE.getWORLD_SPELL_STATES()));
            event.addCapability(new ResourceLocation("afraidofthedark", "structure_collision_map"), (ICapabilityProvider)new CapabilityProvider<IWorldStructureCollisionMap>(ModCapabilities.INSTANCE.getWORLD_STRUCTURE_COLLISION_MAP()));
            event.addCapability(new ResourceLocation("afraidofthedark", "structure_miss_counter"), (ICapabilityProvider)new CapabilityProvider<IWorldStructureMissCounter>(ModCapabilities.INSTANCE.getWORLD_STRUCTURE_MISS_COUNTER()));
            if (Intrinsics.areEqual(world.field_73011_w.func_186058_p(), ModDimensions.INSTANCE.getNIGHTMARE_TYPE()) || Intrinsics.areEqual(world.field_73011_w.func_186058_p(), ModDimensions.INSTANCE.getVOID_CHEST_TYPE())) {
                event.addCapability(new ResourceLocation("afraidofthedark", "island_visitors"), (ICapabilityProvider)new CapabilityProvider<IWorldIslandVisitors>(ModCapabilities.INSTANCE.getWORLD_ISLAND_VISITORS()));
            }
        }
    }

    @SubscribeEvent
    public final void onAttachCapabilitiesEntity(@NotNull AttachCapabilitiesEvent<Entity> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("afraidofthedark", "player_basics"), (ICapabilityProvider)new CapabilityProvider<IAOTDPlayerBasics>(ModCapabilities.INSTANCE.getPLAYER_BASICS()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_research"), (ICapabilityProvider)new CapabilityProvider<IPlayerResearch>(ModCapabilities.INSTANCE.getPLAYER_RESEARCH()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_void_chest_data"), (ICapabilityProvider)new CapabilityProvider<IPlayerVoidChestData>(ModCapabilities.INSTANCE.getPLAYER_VOID_CHEST_DATA()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_nightmare_data"), (ICapabilityProvider)new CapabilityProvider<IPlayerNightmareData>(ModCapabilities.INSTANCE.getPLAYER_NIGHTMARE_DATA()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_spell_manager"), (ICapabilityProvider)new CapabilityProvider<IPlayerSpellManager>(ModCapabilities.INSTANCE.getPLAYER_SPELL_MANAGER()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_spell_freeze_data"), (ICapabilityProvider)new CapabilityProvider<IPlayerSpellFreezeData>(ModCapabilities.INSTANCE.getPLAYER_SPELL_FREEZE_DATA()));
            event.addCapability(new ResourceLocation("afraidofthedark", "player_spell_charm_data"), (ICapabilityProvider)new CapabilityProvider<IPlayerSpellCharmData>(ModCapabilities.INSTANCE.getPLAYER_SPELL_CHARM_DATA()));
        }
    }

    @SubscribeEvent
    public final void onEntityJoinWorld(@NotNull EntityJoinWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntity() instanceof PlayerEntity) {
            Entity entity = event.getEntity();
            if (entity == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.PlayerEntity");
            }
            PlayerEntity entityPlayer = (PlayerEntity)entity;
            if (!event.getWorld().field_72995_K) {
                CapabilityExtensionsKt.getBasics(entityPlayer).syncAll(entityPlayer);
                CapabilityExtensionsKt.getResearch(entityPlayer).sync(entityPlayer, false);
                CapabilityExtensionsKt.getSpellManager(entityPlayer).syncAll(entityPlayer);
                CapabilityExtensionsKt.getSpellFreezeData(entityPlayer).sync(entityPlayer);
            }
        }
    }

    @SubscribeEvent
    public final void onClonePlayer(@NotNull PlayerEvent.Clone event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.isWasDeath()) {
            event.getOriginal().revive();
            PlayerEntity playerEntity = event.getOriginal();
            Intrinsics.checkNotNullExpressionValue(playerEntity, "event.original");
            IAOTDPlayerBasics originalPlayerBasics = CapabilityExtensionsKt.getBasics(playerEntity);
            PlayerEntity playerEntity2 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(playerEntity2, "event.player");
            IAOTDPlayerBasics newPlayerBasics = CapabilityExtensionsKt.getBasics(playerEntity2);
            PlayerEntity playerEntity3 = event.getOriginal();
            Intrinsics.checkNotNullExpressionValue(playerEntity3, "event.original");
            IPlayerResearch originalPlayerResearch = CapabilityExtensionsKt.getResearch(playerEntity3);
            PlayerEntity playerEntity4 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(playerEntity4, "event.player");
            IPlayerResearch newPlayerResearch = CapabilityExtensionsKt.getResearch(playerEntity4);
            PlayerEntity playerEntity5 = event.getOriginal();
            Intrinsics.checkNotNullExpressionValue(playerEntity5, "event.original");
            IPlayerVoidChestData originalPlayerVoidChestData = CapabilityExtensionsKt.getVoidChestData(playerEntity5);
            PlayerEntity playerEntity6 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(playerEntity6, "event.player");
            IPlayerVoidChestData newPlayerVoidChestData = CapabilityExtensionsKt.getVoidChestData(playerEntity6);
            PlayerEntity playerEntity7 = event.getOriginal();
            Intrinsics.checkNotNullExpressionValue(playerEntity7, "event.original");
            IPlayerNightmareData originalPlayerNightmareData = CapabilityExtensionsKt.getNightmareData(playerEntity7);
            PlayerEntity playerEntity8 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(playerEntity8, "event.player");
            IPlayerNightmareData newPlayerNightmareData = CapabilityExtensionsKt.getNightmareData(playerEntity8);
            PlayerEntity playerEntity9 = event.getOriginal();
            Intrinsics.checkNotNullExpressionValue(playerEntity9, "event.original");
            IPlayerSpellManager originalPlayerSpellManager = CapabilityExtensionsKt.getSpellManager(playerEntity9);
            PlayerEntity playerEntity10 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(playerEntity10, "event.player");
            IPlayerSpellManager newPlayerSpellManager = CapabilityExtensionsKt.getSpellManager(playerEntity10);
            event.getOriginal().func_70106_y();
            INBT iNBT = ModCapabilities.INSTANCE.getPLAYER_BASICS().getStorage().writeNBT(ModCapabilities.INSTANCE.getPLAYER_BASICS(), (Object)originalPlayerBasics, null);
            if (iNBT == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundNBT");
            }
            CompoundNBT originalPlayerBasicsNBT = (CompoundNBT)iNBT;
            INBT iNBT2 = ModCapabilities.INSTANCE.getPLAYER_RESEARCH().getStorage().writeNBT(ModCapabilities.INSTANCE.getPLAYER_RESEARCH(), (Object)originalPlayerResearch, null);
            if (iNBT2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundNBT");
            }
            CompoundNBT originalPlayerResearchNBT = (CompoundNBT)iNBT2;
            INBT iNBT3 = ModCapabilities.INSTANCE.getPLAYER_VOID_CHEST_DATA().getStorage().writeNBT(ModCapabilities.INSTANCE.getPLAYER_VOID_CHEST_DATA(), (Object)originalPlayerVoidChestData, null);
            if (iNBT3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundNBT");
            }
            CompoundNBT originalPlayerVoidChestDataNBT = (CompoundNBT)iNBT3;
            INBT iNBT4 = ModCapabilities.INSTANCE.getPLAYER_NIGHTMARE_DATA().getStorage().writeNBT(ModCapabilities.INSTANCE.getPLAYER_NIGHTMARE_DATA(), (Object)originalPlayerNightmareData, null);
            if (iNBT4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundNBT");
            }
            CompoundNBT originalPlayerNightmareDataNBT = (CompoundNBT)iNBT4;
            INBT iNBT5 = ModCapabilities.INSTANCE.getPLAYER_SPELL_MANAGER().getStorage().writeNBT(ModCapabilities.INSTANCE.getPLAYER_SPELL_MANAGER(), (Object)originalPlayerSpellManager, null);
            if (iNBT5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundNBT");
            }
            CompoundNBT originalPlayerSpellManagerNBT = (CompoundNBT)iNBT5;
            ModCapabilities.INSTANCE.getPLAYER_BASICS().getStorage().readNBT(ModCapabilities.INSTANCE.getPLAYER_BASICS(), (Object)newPlayerBasics, null, (INBT)originalPlayerBasicsNBT);
            ModCapabilities.INSTANCE.getPLAYER_RESEARCH().getStorage().readNBT(ModCapabilities.INSTANCE.getPLAYER_RESEARCH(), (Object)newPlayerResearch, null, (INBT)originalPlayerResearchNBT);
            ModCapabilities.INSTANCE.getPLAYER_VOID_CHEST_DATA().getStorage().readNBT(ModCapabilities.INSTANCE.getPLAYER_VOID_CHEST_DATA(), (Object)newPlayerVoidChestData, null, (INBT)originalPlayerVoidChestDataNBT);
            ModCapabilities.INSTANCE.getPLAYER_NIGHTMARE_DATA().getStorage().readNBT(ModCapabilities.INSTANCE.getPLAYER_NIGHTMARE_DATA(), (Object)newPlayerNightmareData, null, (INBT)originalPlayerNightmareDataNBT);
            ModCapabilities.INSTANCE.getPLAYER_SPELL_MANAGER().getStorage().readNBT(ModCapabilities.INSTANCE.getPLAYER_SPELL_MANAGER(), (Object)newPlayerSpellManager, null, (INBT)originalPlayerSpellManagerNBT);
        }
    }
}

