/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.client.gui.screens.BloodStainedJournalResearchScreen;
import com.davidm1a2.afraidofthedark.client.gui.screens.BloodStainedJournalSignScreen;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a8\u0006 "}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/JournalItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "fillItemGroup", "group", "Lnet/minecraft/item/ItemGroup;", "items", "Lnet/minecraft/util/NonNullList;", "isCheatSheet", "", "itemStack", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "setOwner", "owner", "", "Companion", "afraidofthedark"})
public final class JournalItem
extends AOTDItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_OWNER = "owner";
    @NotNull
    private static final String NBT_CHEAT_SHEET = "cheatsheet";

    public JournalItem() {
        Item.Properties properties = new Item.Properties().func_200917_a(1);
        Intrinsics.checkNotNullExpressionValue(properties, "Properties().maxStackSize(1)");
        super("journal", properties, false, 4, null);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(hand, "hand");
        ItemStack heldItemStack = player.func_184586_b(hand);
        Intrinsics.checkNotNullExpressionValue(heldItemStack, "heldItemStack");
        if (!NBTHelper.INSTANCE.hasTag(heldItemStack, NBT_OWNER)) {
            if (CapabilityExtensionsKt.getBasics(player).getStartedAOTD()) {
                this.setOwner(heldItemStack, player.func_146103_bH().getName());
                if (world.field_72995_K) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new BloodStainedJournalResearchScreen(this.isCheatSheet(heldItemStack)));
                }
            } else if (world.field_72995_K) {
                Minecraft.func_71410_x().func_147108_a((Screen)new BloodStainedJournalSignScreen());
            }
        } else if (Intrinsics.areEqual(player.func_146103_bH().getName(), NBTHelper.INSTANCE.getString(heldItemStack, NBT_OWNER))) {
            if (CapabilityExtensionsKt.getBasics(player).getStartedAOTD()) {
                if (world.field_72995_K) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new BloodStainedJournalResearchScreen(this.isCheatSheet(heldItemStack)));
                }
            } else {
                if (world.field_72995_K) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new BloodStainedJournalSignScreen());
                }
                this.setOwner(heldItemStack, null);
            }
        } else if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.journal.cant_comprehend", new Object[0]));
        }
        ActionResult actionResult = ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)heldItemStack);
        Intrinsics.checkNotNullExpressionValue(actionResult, "newResult(ActionResultType.SUCCESS, heldItemStack)");
        return actionResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCheatSheet(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_CHEAT_SHEET)) return false;
        Boolean bl = NBTHelper.INSTANCE.getBoolean(itemStack, NBT_CHEAT_SHEET);
        Intrinsics.checkNotNull(bl);
        if (bl == false) return false;
        return true;
    }

    public final void setOwner(@NotNull ItemStack itemStack, @Nullable String owner) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (owner == null) {
            NBTHelper.INSTANCE.removeTag(itemStack, NBT_OWNER);
        } else {
            NBTHelper.INSTANCE.setString(itemStack, NBT_OWNER, owner);
        }
    }

    public void func_150895_a(@NotNull ItemGroup group, @NotNull NonNullList<ItemStack> items) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(items, "items");
        if (this.func_194125_a(group)) {
            ItemStack standardJournal = new ItemStack((IItemProvider)this);
            ItemStack cheatsheetJournal = new ItemStack((IItemProvider)this);
            NBTHelper.INSTANCE.setBoolean(cheatsheetJournal, NBT_CHEAT_SHEET, true);
            items.add((Object)standardJournal);
            items.add((Object)cheatsheetJournal);
        }
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        if (NBTHelper.INSTANCE.hasTag(stack, NBT_OWNER)) {
            Object[] objectArray = new Object[]{NBTHelper.INSTANCE.getString(stack, NBT_OWNER)};
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.journal.bound", objectArray));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.journal.unbound", new Object[0]));
        }
        if (NBTHelper.INSTANCE.hasTag(stack, NBT_CHEAT_SHEET)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.journal.cheatsheet.line1", new Object[0]));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.journal.cheatsheet.line2", new Object[0]));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/JournalItem$Companion;", "", "()V", "NBT_CHEAT_SHEET", "", "NBT_OWNER", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

