/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModDamageSources;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.constants.ModToolMaterials;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDChargeableSwordItem;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J0\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006 "}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/StarMetalKhopeshItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDChargeableSwordItem;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "decrementSpinTicks", "itemStack", "inventoryTick", "entity", "Lnet/minecraft/entity/Entity;", "itemSlot", "", "isSelected", "", "onLeftClickEntity", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "target", "performChargeAttack", "entityPlayer", "resetSpin", "shouldSpin", "Companion", "afraidofthedark"})
public final class StarMetalKhopeshItem
extends AOTDChargeableSwordItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int HIT_RANGE = 5;
    @NotNull
    private static final String NBT_SPIN_TICKS_LEFT = "spin_ticks_left";
    private static final int TICKS_TO_SPIN = 6;
    private static final float DEGREES_PER_TICK = 60.0f;

    public StarMetalKhopeshItem() {
        super("star_metal_khopesh", ModToolMaterials.INSTANCE.getSTAR_METAL(), 3, -2.4f, new Item.Properties(), false, 32, null);
        this.setPercentChargePerAttack(35.0);
    }

    @Override
    public boolean onLeftClickEntity(@NotNull ItemStack stack, @NotNull PlayerEntity player, @NotNull Entity target) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(target, "target");
        if (!CapabilityExtensionsKt.getResearch(player).isResearched(ModResearches.INSTANCE.getSTAR_METAL())) {
            return true;
        }
        target.func_70097_a(ModDamageSources.INSTANCE.getSilverDamage((Entity)player), this.func_200894_d());
        return super.onLeftClickEntity(stack, player, target);
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((PlayerEntity)player).isResearched(ModResearches.INSTANCE.getSTAR_METAL())) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.magic_items_never_break", new Object[0]));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.star_metal_khopesh.effect1", new Object[0]));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.star_metal_khopesh.effect2", new Object[0]));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.dont_know_how_to_use", new Object[0]));
        }
    }

    @Override
    public boolean performChargeAttack(@NotNull ItemStack itemStack, @NotNull World world, @NotNull PlayerEntity entityPlayer) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        List nearbyEntities = world.func_72839_b((Entity)entityPlayer, entityPlayer.func_174813_aQ().func_186662_g(5.0));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof PlayerEntity) && !(entity instanceof MobEntity)) continue;
            double motionX = (double)entityPlayer.func_180425_c().func_177958_n() - (double)entity.func_180425_c().func_177958_n();
            double motionZ = (double)entityPlayer.func_180425_c().func_177952_p() - (double)entity.func_180425_c().func_177952_p();
            double d = motionX * motionX + motionZ * motionZ;
            boolean bl = false;
            double hypotenuse = Math.sqrt(d);
            double knockbackStrength = (double)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)itemStack) + 2.0;
            int sharpnessDamage = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)itemStack);
            entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)entityPlayer), this.func_200894_d() + 4.0f + (float)sharpnessDamage * 1.5f);
            entity.func_70024_g(-motionX * knockbackStrength * 0.6 / hypotenuse, 0.1, -motionZ * knockbackStrength * 0.6 / hypotenuse);
        }
        this.resetSpin(itemStack);
        return true;
    }

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (this.shouldSpin(stack)) {
            this.decrementSpinTicks(stack);
            entity.field_70177_z += 60.0f;
        }
    }

    private final void resetSpin(ItemStack itemStack) {
        NBTHelper.INSTANCE.setInteger(itemStack, NBT_SPIN_TICKS_LEFT, 6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldSpin(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_SPIN_TICKS_LEFT)) return false;
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_SPIN_TICKS_LEFT);
        Intrinsics.checkNotNull(n);
        if (n <= 0) return false;
        return true;
    }

    private final void decrementSpinTicks(ItemStack itemStack) {
        if (NBTHelper.INSTANCE.hasTag(itemStack, NBT_SPIN_TICKS_LEFT)) {
            Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_SPIN_TICKS_LEFT);
            Intrinsics.checkNotNull(n);
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_SPIN_TICKS_LEFT, n - 1);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/StarMetalKhopeshItem$Companion;", "", "()V", "DEGREES_PER_TICK", "", "HIT_RANGE", "", "NBT_SPIN_TICKS_LEFT", "", "TICKS_TO_SPIN", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

