/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item.core;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.network.packets.otherPackets.CooldownSyncPacket;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\nR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDPerItemCooldownItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "baseName", "", "properties", "Lnet/minecraft/item/Item$Properties;", "displayInCreative", "", "(Ljava/lang/String;Lnet/minecraft/item/Item$Properties;Z)V", "serverClientTimeDifference", "", "cooldownRemainingInSeconds", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "getCooldownInMilliseconds", "getDurabilityForDisplay", "", "stack", "getLastUseTime", "isOnCooldown", "setOnCooldown", "", "entityPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "showDurabilityBar", "updateServerClientDifference", "difference", "Companion", "afraidofthedark"})
public abstract class AOTDPerItemCooldownItem
extends AOTDItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long serverClientTimeDifference;
    @NotNull
    private static final String NBT_LAST_USE_TIME = "last_use_time";

    /*
     * WARNING - void declaration
     */
    public AOTDPerItemCooldownItem(@NotNull String baseName, @NotNull Item.Properties properties, boolean displayInCreative) {
        void $this$_init__u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(properties, "properties");
        Item.Properties properties2 = properties;
        boolean bl = false;
        boolean bl2 = false;
        Item.Properties properties3 = properties2;
        String string = baseName;
        AOTDPerItemCooldownItem aOTDPerItemCooldownItem = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u2d0.func_200917_a(1);
        Unit unit = Unit.INSTANCE;
        super(string, properties2, displayInCreative);
    }

    public /* synthetic */ AOTDPerItemCooldownItem(String string, Item.Properties properties, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, properties, bl);
    }

    public final void updateServerClientDifference(long difference) {
        this.serverClientTimeDifference = difference;
    }

    public void setOnCooldown(@NotNull ItemStack itemStack, @NotNull PlayerEntity entityPlayer) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        NBTHelper.INSTANCE.setLong(itemStack, NBT_LAST_USE_TIME, System.currentTimeMillis());
        if (!entityPlayer.field_70170_p.field_72995_K) {
            AfraidOfTheDark.Companion.getPacketHandler().sendTo(new CooldownSyncPacket(System.currentTimeMillis(), this), (ServerPlayerEntity)entityPlayer);
        }
    }

    public final boolean isOnCooldown(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        long millisecondsElapsed = System.currentTimeMillis() - this.getLastUseTime(itemStack);
        return millisecondsElapsed < (long)this.getCooldownInMilliseconds(itemStack);
    }

    public final int cooldownRemainingInSeconds(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        long millisecondsElapsed = System.currentTimeMillis() - this.getLastUseTime(itemStack);
        double d = (double)((long)this.getCooldownInMilliseconds(itemStack) - millisecondsElapsed) / 1000.0;
        boolean bl = false;
        return (int)Math.ceil(d);
    }

    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        long millisecondsElapsed = System.currentTimeMillis() - this.serverClientTimeDifference - this.getLastUseTime(stack);
        double d = 0.0;
        double d2 = 1.0 - (double)millisecondsElapsed / (double)this.getCooldownInMilliseconds(stack);
        boolean bl = false;
        return Math.max(d, d2);
    }

    private final long getLastUseTime(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_LAST_USE_TIME)) {
            NBTHelper.INSTANCE.setLong(itemStack, NBT_LAST_USE_TIME, 0L);
        }
        Long l = NBTHelper.INSTANCE.getLong(itemStack, NBT_LAST_USE_TIME);
        Intrinsics.checkNotNull(l);
        return l;
    }

    public boolean showDurabilityBar(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        return true;
    }

    public abstract int getCooldownInMilliseconds(@NotNull ItemStack var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDPerItemCooldownItem$Companion;", "", "()V", "NBT_LAST_USE_TIME", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

