/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item.crossbow;

import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.constants.ModSounds;
import com.davidm1a2.afraidofthedark.common.entity.bolt.BoltEntity;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.registry.bolt.BoltEntry;
import com.davidm1a2.afraidofthedark.common.utility.BoltOrderHelper;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0018\u0010$\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006'"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/crossbow/CrossbowItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "fireBolt", "entityPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "itemStack", "getCurrentBoltType", "Lcom/davidm1a2/afraidofthedark/common/registry/bolt/BoltEntry;", "getCurrentBoltTypeIndex", "", "getUseDuration", "isLoaded", "", "onEntitySwing", "entityLiving", "Lnet/minecraft/entity/LivingEntity;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "hand", "Lnet/minecraft/util/Hand;", "onUsingTick", "entity", "count", "selectNextBoltType", "setLoaded", "Companion", "afraidofthedark"})
public final class CrossbowItem
extends AOTDItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int RELOAD_TIME = 40;
    @NotNull
    private static final String NBT_BOLT_TYPE = "bolt_type";
    @NotNull
    private static final String NBT_LOADED = "is_loaded";

    public CrossbowItem() {
        Item.Properties properties = new Item.Properties().func_200917_a(1);
        Intrinsics.checkNotNullExpressionValue(properties, "Properties().maxStackSize(1)");
        super("crossbow", properties, false, 4, null);
        this.func_185043_a(new ResourceLocation("afraidofthedark", "charge_level"), (arg_0, arg_1, arg_2) -> CrossbowItem._init_$lambda-0(this, arg_0, arg_1, arg_2));
        this.func_185043_a(new ResourceLocation("afraidofthedark", NBT_LOADED), (arg_0, arg_1, arg_2) -> CrossbowItem._init_$lambda-1(this, arg_0, arg_1, arg_2));
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(hand, "hand");
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                Intrinsics.checkNotNullExpressionValue(itemStack, "itemStack");
                this.selectNextBoltType(itemStack, player);
            } else {
                Intrinsics.checkNotNullExpressionValue(itemStack, "itemStack");
                if (!this.isLoaded(itemStack)) {
                    if (player.func_184812_l_() || player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)this.getCurrentBoltType(itemStack).getBoltItem()))) {
                        world.func_184133_a(null, player.func_180425_c(), ModSounds.INSTANCE.getCROSSBOW_LOAD(), SoundCategory.PLAYERS, 0.9f, world.field_73012_v.nextFloat() * 0.8f + 1.2f);
                        player.func_184598_c(hand);
                    } else {
                        objectArray = new Object[]{new TranslationTextComponent(this.getCurrentBoltType(itemStack).getUnlocalizedName(), new Object[0])};
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.crossbow.no_bolt", objectArray));
                    }
                }
            }
        }
        objectArray = ActionResult.newResult((ActionResultType)ActionResultType.FAIL, (Object)itemStack);
        Intrinsics.checkNotNullExpressionValue(objectArray, "newResult(ActionResultType.FAIL, itemStack)");
        return objectArray;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull LivingEntity entity, int count) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (entity instanceof PlayerEntity && count == 2 && (((PlayerEntity)entity).func_184812_l_() || ((PlayerEntity)entity).field_71071_by.func_195408_a(arg_0 -> CrossbowItem.onUsingTick$lambda-2(this, stack, arg_0), 1) == 1)) {
            this.setLoaded(stack, true);
        }
    }

    public boolean onEntitySwing(@NotNull ItemStack stack, @NotNull LivingEntity entityLiving) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(entityLiving, "entityLiving");
        if (!entityLiving.field_70170_p.field_72995_K && entityLiving instanceof PlayerEntity && this.isLoaded(stack)) {
            this.setLoaded(stack, false);
            PlayerEntity playerEntity = (PlayerEntity)entityLiving;
            World world = entityLiving.field_70170_p;
            Intrinsics.checkNotNullExpressionValue(world, "entityLiving.world");
            this.fireBolt(playerEntity, world, stack);
        }
        return super.onEntitySwing(stack, entityLiving);
    }

    private final void fireBolt(PlayerEntity entityPlayer, World world, ItemStack itemStack) {
        world.func_184133_a(null, entityPlayer.func_180425_c(), ModSounds.INSTANCE.getCROSSBOW_FIRE(), SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        BoltEntity bolt = this.getCurrentBoltType(itemStack).getBoltEntityFactory().invoke(world, entityPlayer);
        bolt.field_70251_a = entityPlayer.func_184812_l_() ? AbstractArrowEntity.PickupStatus.DISALLOWED : AbstractArrowEntity.PickupStatus.ALLOWED;
        bolt.func_184547_a((Entity)entityPlayer, entityPlayer.field_70125_A, entityPlayer.field_70177_z, 0.0f, 5.0f, 0.0f);
        world.func_217376_c((Entity)bolt);
    }

    private final void selectNextBoltType(ItemStack itemStack, PlayerEntity entityPlayer) {
        if (!this.isLoaded(itemStack)) {
            int currentBoltTypeIndex = this.getCurrentBoltTypeIndex(itemStack);
            currentBoltTypeIndex = BoltOrderHelper.INSTANCE.getNextBoltIndex(entityPlayer, currentBoltTypeIndex);
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_BOLT_TYPE, currentBoltTypeIndex);
            if (!entityPlayer.field_70170_p.field_72995_K) {
                Object[] objectArray = new Object[]{new TranslationTextComponent(this.getCurrentBoltType(itemStack).getUnlocalizedName(), new Object[0])};
                entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.crossbow.bolt_change", objectArray));
            }
        }
    }

    private final BoltEntry getCurrentBoltType(ItemStack itemStack) {
        return BoltOrderHelper.INSTANCE.getBoltAt(this.getCurrentBoltTypeIndex(itemStack));
    }

    private final int getCurrentBoltTypeIndex(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_BOLT_TYPE)) {
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_BOLT_TYPE, 0);
        }
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_BOLT_TYPE);
        Intrinsics.checkNotNull(n);
        return n;
    }

    private final void setLoaded(ItemStack itemStack, boolean isLoaded) {
        NBTHelper.INSTANCE.setBoolean(itemStack, NBT_LOADED, isLoaded);
    }

    private final boolean isLoaded(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_LOADED)) {
            this.setLoaded(itemStack, false);
        }
        Boolean bl = NBTHelper.INSTANCE.getBoolean(itemStack, NBT_LOADED);
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        if (ModRegistries.INSTANCE.getBOLTS().isEmpty()) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.crossbow.change_bolt", new Object[0]));
        Object[] objectArray = new Object[]{new TranslationTextComponent(this.getCurrentBoltType(stack).getUnlocalizedName(), new Object[0])};
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.crossbow.fire_bolt_type", objectArray));
        if (this.isLoaded(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.crossbow.loaded", new Object[0]));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.crossbow.unloaded", new Object[0]));
        }
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return 40;
    }

    private static final float _init_$lambda-0(CrossbowItem this$0, ItemStack stack, World $noName_1, LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)this$0, "this$0");
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (entity instanceof PlayerEntity && Intrinsics.areEqual(((PlayerEntity)entity).field_71071_by.field_70462_a.get(((PlayerEntity)entity).field_71071_by.field_70461_c), stack)) {
            return (float)((PlayerEntity)entity).func_184612_cw() / (float)this$0.func_77626_a(stack);
        }
        return 0.0f;
    }

    private static final float _init_$lambda-1(CrossbowItem this$0, ItemStack stack, World $noName_1, LivingEntity $noName_2) {
        Intrinsics.checkNotNullParameter((Object)this$0, "this$0");
        Intrinsics.checkNotNullParameter(stack, "stack");
        return this$0.isLoaded(stack) ? 1.0f : 0.0f;
    }

    private static final boolean onUsingTick$lambda-2(CrossbowItem this$0, ItemStack $stack, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)this$0, "this$0");
        Intrinsics.checkNotNullParameter($stack, "$stack");
        return Intrinsics.areEqual(it.func_77973_b(), this$0.getCurrentBoltType($stack).getBoltItem());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/crossbow/CrossbowItem$Companion;", "", "()V", "NBT_BOLT_TYPE", "", "NBT_LOADED", "RELOAD_TIME", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

