/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item.telescope;

import com.davidm1a2.afraidofthedark.client.gui.screens.TelescopeScreen;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IPlayerResearch;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0015H&J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/telescope/TelescopeBaseItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "accuracy", "", "name", "", "(ILjava/lang/String;)V", "getAccuracy", "()I", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getRequiredResearch", "Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "afraidofthedark"})
public abstract class TelescopeBaseItem
extends AOTDItem {
    private final int accuracy;

    public TelescopeBaseItem(int accuracy, @NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Item.Properties properties = new Item.Properties().func_200917_a(1);
        Intrinsics.checkNotNullExpressionValue(properties, "Properties().maxStackSize(1)");
        super(name, properties, false, 4, null);
        this.accuracy = accuracy;
        boolean bl = this.accuracy >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Accuracy for telescopes must be positive!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final int getAccuracy() {
        return this.accuracy;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(hand, "hand");
        ItemStack itemStack = player.func_184586_b(hand);
        IPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(player);
        boolean highEnough = player.func_180425_c().func_177956_o() > 128;
        Research research = this.getRequiredResearch();
        if (!world.field_72995_K) {
            if (playerResearch.isResearched(research)) {
                if (!highEnough) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.telescope.not_high_enough", new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.dont_understand", new Object[0]));
            }
        }
        if (world.field_72995_K && highEnough && playerResearch.isResearched(research)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new TelescopeScreen());
        }
        ActionResult actionResult = ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)itemStack);
        Intrinsics.checkNotNullExpressionValue(actionResult, "newResult(ActionResultType.SUCCESS, itemStack)");
        return actionResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((PlayerEntity)player).isResearched(this.getRequiredResearch())) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.telescope.directions", new Object[0]));
            Object[] objectArray = new Object[]{this.accuracy};
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.telescope.accuracy", objectArray));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("message.afraidofthedark.dont_understand", new Object[0]));
        }
    }

    @NotNull
    public abstract Research getRequiredResearch();
}

