/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.network.packets.otherPackets;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.basics.IAOTDPlayerBasics;
import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.network.packets.otherPackets.UpdateWatchedMeteorPacket;
import com.davidm1a2.afraidofthedark.common.network.packets.packetHandler.PacketProcessor;
import com.davidm1a2.afraidofthedark.common.registry.meteor.MeteorEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/network/packets/otherPackets/UpdateWatchedMeteorPacketProcessor;", "Lcom/davidm1a2/afraidofthedark/common/network/packets/packetHandler/PacketProcessor;", "Lcom/davidm1a2/afraidofthedark/common/network/packets/otherPackets/UpdateWatchedMeteorPacket;", "()V", "decode", "buf", "Lnet/minecraft/network/PacketBuffer;", "encode", "", "msg", "process", "ctx", "Lnet/minecraftforge/fml/network/NetworkEvent$Context;", "afraidofthedark"})
public final class UpdateWatchedMeteorPacketProcessor
implements PacketProcessor<UpdateWatchedMeteorPacket> {
    @Override
    public void encode(@NotNull UpdateWatchedMeteorPacket msg, @NotNull PacketBuffer buf) {
        ResourceLocation resourceLocation;
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(buf, "buf");
        Object object = msg.getMeteorEntry$afraidofthedark();
        ResourceLocation resourceLocation2 = resourceLocation = object == null ? null : object.getRegistryName();
        buf.func_180714_a((String)(resourceLocation == null ? "none" : ((object = resourceLocation.toString()) == null ? "none" : object)));
        buf.writeInt(msg.getAccuracy$afraidofthedark());
        buf.writeInt(msg.getDropAngle$afraidofthedark());
        buf.writeInt(msg.getLatitude$afraidofthedark());
        buf.writeInt(msg.getLongitude$afraidofthedark());
    }

    @Override
    @NotNull
    public UpdateWatchedMeteorPacket decode(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        String meteorEntryString = buf.func_150789_c(500);
        MeteorEntry meteorEntry = Intrinsics.areEqual(meteorEntryString, "none") ? (MeteorEntry)null : (MeteorEntry)ModRegistries.INSTANCE.getMETEORS().getValue(new ResourceLocation(meteorEntryString));
        return new UpdateWatchedMeteorPacket(meteorEntry, buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void process(@NotNull UpdateWatchedMeteorPacket msg, @NotNull NetworkEvent.Context ctx) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        if (ctx.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ClientPlayerEntity clientPlayerEntity = Minecraft.func_71410_x().field_71439_g;
            Intrinsics.checkNotNullExpressionValue(clientPlayerEntity, "getInstance().player");
            CapabilityExtensionsKt.getBasics((PlayerEntity)clientPlayerEntity).setWatchedMeteor(msg.getMeteorEntry$afraidofthedark(), msg.getAccuracy$afraidofthedark(), msg.getDropAngle$afraidofthedark(), msg.getLatitude$afraidofthedark(), msg.getLongitude$afraidofthedark());
        } else if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayerEntity serverPlayerEntity;
            ServerPlayerEntity serverPlayerEntity2 = ctx.getSender();
            Intrinsics.checkNotNull(serverPlayerEntity2);
            ServerPlayerEntity player = serverPlayerEntity = serverPlayerEntity2;
            MeteorEntry watchedMeteor = msg.getMeteorEntry$afraidofthedark();
            int accuracy = msg.getAccuracy$afraidofthedark();
            int dropAngle = player.func_70681_au().nextInt(45) + 5;
            int latitude = player.func_70681_au().nextInt(50) + 5;
            int longitude = player.func_70681_au().nextInt(130) + 5;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)watchedMeteor);
            objectArray[0] = new TranslationTextComponent(watchedMeteor.getUnlocalizedName(), new Object[0]);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.falling_meteor.info.header", objectArray));
            objectArray = new Object[]{dropAngle, latitude, longitude};
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.falling_meteor.info.data", objectArray));
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.falling_meteor.info.help", new Object[0]));
            IAOTDPlayerBasics playerBasics = CapabilityExtensionsKt.getBasics((PlayerEntity)player);
            playerBasics.setWatchedMeteor(watchedMeteor, accuracy, dropAngle, latitude, longitude);
            playerBasics.syncWatchedMeteor((PlayerEntity)player);
        }
    }

    @Override
    public boolean processAsync() {
        return PacketProcessor.DefaultImpls.processAsync(this);
    }
}

