/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.constants.ModSounds;
import com.davidm1a2.afraidofthedark.common.network.packets.otherPackets.ParticlePacket;
import com.davidm1a2.afraidofthedark.common.network.packets.packetHandler.PacketHandler;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.powerSource.base.SpellPowerSource;
import com.davidm1a2.afraidofthedark.common.spell.component.powerSource.base.SpellPowerSourceInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u0004\u0018\u00010\u001a2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(J\b\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020\u0002H\u0016J\b\u0010-\u001a\u00020\fH\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/CompoundNBT;", "()V", "nbt", "(Lnet/minecraft/nbt/CompoundNBT;)V", "<set-?>", "Ljava/util/UUID;", "id", "getId", "()Ljava/util/UUID;", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "powerSource", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/powerSource/base/SpellPowerSource;", "getPowerSource", "()Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "setPowerSource", "(Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;)V", "spellStages", "", "Lcom/davidm1a2/afraidofthedark/common/spell/SpellStage;", "getSpellStages", "()Ljava/util/List;", "attemptToCast", "", "entity", "Lnet/minecraft/entity/Entity;", "direction", "Lnet/minecraft/util/math/Vec3d;", "deserializeNBT", "getCost", "", "getStage", "index", "", "hasStage", "", "isValid", "serializeNBT", "toString", "Companion", "afraidofthedark"})
public final class Spell
implements INBTSerializable<CompoundNBT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public String name;
    private UUID id;
    @Nullable
    private SpellComponentInstance<SpellPowerSource> powerSource;
    @NotNull
    private final List<SpellStage> spellStages;
    private static final Logger logger = LogManager.getLogger();
    private static final int SPELL_TIER2_CUTOFF = 100;
    private static final int SPELL_TIER3_CUTOFF = 500;
    @NotNull
    private static final String NBT_NAME = "name";
    @NotNull
    private static final String NBT_ID = "id";
    @NotNull
    private static final String NBT_POWER_SOURCE = "power_source";
    @NotNull
    private static final String NBT_SPELL_STAGES = "spell_stages";

    @NotNull
    public final String getName() {
        String string = this.name;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException(NBT_NAME);
        throw null;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @NotNull
    public final UUID getId() {
        UUID uUID = this.id;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException(NBT_ID);
        throw null;
    }

    @Nullable
    public final SpellComponentInstance<SpellPowerSource> getPowerSource() {
        return this.powerSource;
    }

    public final void setPowerSource(@Nullable SpellComponentInstance<SpellPowerSource> spellComponentInstance) {
        this.powerSource = spellComponentInstance;
    }

    @NotNull
    public final List<SpellStage> getSpellStages() {
        return this.spellStages;
    }

    public Spell() {
        boolean bl = false;
        this.spellStages = new ArrayList();
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID()");
        this.id = uUID;
        this.setName("");
    }

    public Spell(@NotNull CompoundNBT nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        boolean bl = false;
        this.spellStages = new ArrayList();
        this.deserializeNBT(nbt);
    }

    public final void attemptToCast(@NotNull Entity entity, @NotNull Vec3d direction) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(direction, "direction");
        if (!entity.field_70170_p.field_72995_K) {
            if (!Intrinsics.areEqual(entity.field_71093_bK, ModDimensions.INSTANCE.getNIGHTMARE_TYPE())) {
                if (this.isValid()) {
                    SpellComponentInstance<SpellPowerSource> spellComponentInstance = this.powerSource;
                    Intrinsics.checkNotNull(spellComponentInstance);
                    if (spellComponentInstance.getComponent().canCast(entity, this)) {
                        ArrayList<Vec3d> arrayList;
                        spellComponentInstance = this.powerSource;
                        Intrinsics.checkNotNull(spellComponentInstance);
                        spellComponentInstance.getComponent().consumePowerToCast(entity, this);
                        entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), ModSounds.INSTANCE.getSPELL_CAST(), SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.4));
                        double spellPower = this.getCost();
                        IParticleData spellParticle = (IParticleData)ModParticles.INSTANCE.getSPELL_CAST();
                        if (spellPower > 100.0) {
                            spellParticle = (IParticleData)ModParticles.INSTANCE.getSPELL_CAST2();
                        }
                        if (spellPower > 500.0) {
                            spellParticle = (IParticleData)ModParticles.INSTANCE.getSPELL_CAST3();
                        }
                        List positions = new ArrayList();
                        int n = 0;
                        int n2 = Random.Default.nextInt(2, 6);
                        if (n < n2) {
                            do {
                                int i = n++;
                                positions.add(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                            } while (n < n2);
                        }
                        n = positions.size();
                        List list = positions;
                        IParticleData iParticleData = spellParticle;
                        PacketHandler packetHandler = AfraidOfTheDark.Companion.getPacketHandler();
                        n2 = 0;
                        boolean bl = false;
                        ArrayList<Vec3d> arrayList2 = new ArrayList<Vec3d>(n);
                        boolean bl2 = false;
                        int n3 = 0;
                        n3 = 0;
                        int n4 = n;
                        while (n3 < n4) {
                            int n5 = n3++;
                            boolean bl3 = false;
                            int n6 = n5;
                            arrayList = arrayList2;
                            boolean bl4 = false;
                            Vec3d vec3d = Vec3d.field_186680_a;
                            Intrinsics.checkNotNullExpressionValue(vec3d, "ZERO");
                            Vec3d vec3d2 = vec3d;
                            arrayList.add(vec3d2);
                        }
                        ArrayList<Vec3d> arrayList3 = arrayList = (ArrayList<Vec3d>)arrayList2;
                        List list2 = list;
                        IParticleData iParticleData2 = iParticleData;
                        packetHandler.sendToAllAround(new ParticlePacket(iParticleData2, list2, arrayList3), new PacketDistributor.TargetPoint(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 100.0, entity.field_71093_bK));
                        SpellStage spellStage = this.getStage(0);
                        Intrinsics.checkNotNull(spellStage);
                        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance2 = spellStage.getDeliveryInstance();
                        Intrinsics.checkNotNull(spellComponentInstance2);
                        spellComponentInstance2.getComponent().executeDelivery(new DeliveryTransitionStateBuilder().withSpell(this).withStageIndex(0).withCasterEntity(entity).withEntity(entity).withDirection(direction).build());
                    } else {
                        spellComponentInstance = this.powerSource;
                        Intrinsics.checkNotNull(spellComponentInstance);
                        entity.func_145747_a((ITextComponent)new TranslationTextComponent(spellComponentInstance.getComponent().getUnlocalizedOutOfPowerMsg(), new Object[0]));
                        if (!(entity instanceof PlayerEntity)) {
                            logger.info("Entity '" + entity.func_200200_C_() + "' attempted to cast a spell without enough power?");
                        }
                    }
                } else {
                    entity.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.spell.invalid", new Object[0]));
                    if (!(entity instanceof PlayerEntity)) {
                        logger.info("Entity '" + entity.func_200200_C_() + "' attempted to cast an invalid spell?");
                    }
                }
            } else {
                entity.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.spell.wrong_dimension", new Object[0]));
                if (!(entity instanceof PlayerEntity)) {
                    logger.info("Entity '" + entity.func_200200_C_() + "' attempted to cast a spell in the nightmare?");
                }
            }
        }
    }

    public static /* synthetic */ void attemptToCast$default(Spell spell, Entity entity, Vec3d vec3d, int n, Object object) {
        if ((n & 2) != 0) {
            Vec3d vec3d2 = entity.func_70040_Z();
            Intrinsics.checkNotNullExpressionValue(vec3d2, "fun attemptToCast(entity: Entity, direction: Vec3d = entity.lookVec) {\n        // Server side processing only\n        if (!entity.world.isRemote) {\n            // Make sure the player isn't in the nightmare realm\n            if (entity.dimension != ModDimensions.NIGHTMARE_TYPE) {\n                // If the spell is valid continue, if not print an error\n                if (isValid()) {\n                    // Test if the spell can be cast, if not tell the player why\n                    if (powerSource!!.component.canCast(entity, this)) {\n                        // Consumer the power to cast the spell\n                        powerSource!!.component.consumePowerToCast(entity, this)\n\n                        // Play a cast sound\n                        entity.world.playSound(\n                            null,\n                            entity.position,\n                            ModSounds.SPELL_CAST,\n                            SoundCategory.PLAYERS,\n                            1.0f,\n                            (0.8f + Math.random() * 0.4).toFloat()\n                        )\n                        // Determine the particles from the strength of the spell\n                        val spellPower = this.getCost()\n                        var spellParticle : IParticleData = ModParticles.SPELL_CAST\n                        if (spellPower > SPELL_TIER2_CUTOFF) spellParticle = ModParticles.SPELL_CAST2\n                        if (spellPower > SPELL_TIER3_CUTOFF) spellParticle = ModParticles.SPELL_CAST3\n                        // Spawn 3-5 particles\n                        val positions: MutableList<Vec3d> = ArrayList()\n                        for (i in 0 until Random.nextInt(2, 6)) {\n                            positions.add(Vec3d(entity.posX, entity.posY, entity.posZ))\n                        }\n                        // Send the particle packet\n                        AfraidOfTheDark.packetHandler.sendToAllAround(\n                            ParticlePacket(\n                                spellParticle,\n                                positions,\n                                List<Vec3d>(positions.size) { Vec3d.ZERO }\n                            ),\n                            PacketDistributor.TargetPoint(\n                                entity.posX,\n                                entity.posY,\n                                entity.posZ,\n                                100.0,\n                                entity.dimension\n                            )\n                        )\n\n                        // Tell the first delivery method to fire\n                        getStage(0)!!\n                            .deliveryInstance!!\n                            .component\n                            .executeDelivery(\n                                DeliveryTransitionStateBuilder()\n                                    .withSpell(this)\n                                    .withStageIndex(0)\n                                    .withCasterEntity(entity)\n                                    .withEntity(entity)\n                                    .withDirection(direction)\n                                    .build()\n                            )\n                    } else {\n                        entity.sendMessage(TranslationTextComponent(powerSource!!.component.getUnlocalizedOutOfPowerMsg()))\n                        if (entity !is PlayerEntity) {\n                            logger.info(\"Entity '${entity.name}' attempted to cast a spell without enough power?\")\n                        }\n                    }\n                } else {\n                    entity.sendMessage(TranslationTextComponent(\"message.afraidofthedark.spell.invalid\"))\n                    if (entity !is PlayerEntity) {\n                        logger.info(\"Entity '${entity.name}' attempted to cast an invalid spell?\")\n                    }\n                }\n            } else {\n                entity.sendMessage(TranslationTextComponent(\"message.afraidofthedark.spell.wrong_dimension\"))\n                if (entity !is PlayerEntity) {\n                    logger.info(\"Entity '${entity.name}' attempted to cast a spell in the nightmare?\")\n                }\n            }\n        }\n    }");
            vec3d = vec3d2;
        }
        spell.attemptToCast(entity, vec3d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValid() {
        SpellStage it;
        if (this.powerSource == null) return false;
        Collection collection = this.spellStages;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = this.spellStages;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (SpellStage)element$iv;
            boolean bl3 = false;
        } while (it.isValid());
        return false;
    }

    public final double getCost() {
        double cost = 0.0;
        double costMultiplier = 1.0;
        for (SpellStage spellStage : this.spellStages) {
            cost += spellStage.getCost() * costMultiplier;
            costMultiplier += 0.05;
        }
        if (cost < 0.0) {
            cost = Double.MAX_VALUE;
        }
        return cost;
    }

    public final boolean hasStage(int index) {
        return index >= 0 && index < this.spellStages.size();
    }

    @Nullable
    public final SpellStage getStage(int index) {
        return this.hasStage(index) ? this.spellStages.get(index) : (SpellStage)null;
    }

    @NotNull
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(NBT_NAME, this.getName());
        nbt.func_218657_a(NBT_ID, (INBT)NBTUtil.func_186862_a((UUID)this.getId()));
        SpellComponentInstance<SpellPowerSource> spellComponentInstance = this.powerSource;
        if (spellComponentInstance != null) {
            SpellComponentInstance<SpellPowerSource> spellComponentInstance2 = spellComponentInstance;
            boolean bl = false;
            boolean bl2 = false;
            SpellComponentInstance<SpellPowerSource> it = spellComponentInstance2;
            boolean bl3 = false;
            nbt.func_218657_a(NBT_POWER_SOURCE, (INBT)it.serializeNBT());
        }
        ListNBT spellStagesNBT = new ListNBT();
        Iterable $this$forEach$iv = this.spellStages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpellStage it = (SpellStage)element$iv;
            boolean bl = false;
            spellStagesNBT.add((Object)it.serializeNBT());
        }
        nbt.func_218657_a(NBT_SPELL_STAGES, (INBT)spellStagesNBT);
        return nbt;
    }

    public void deserializeNBT(@NotNull CompoundNBT nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Object object = nbt.func_74779_i(NBT_NAME);
        Intrinsics.checkNotNullExpressionValue(object, "nbt.getString(NBT_NAME)");
        this.setName((String)object);
        object = NBTUtil.func_186860_b((CompoundNBT)nbt.func_74775_l(NBT_ID));
        Intrinsics.checkNotNullExpressionValue(object, "readUniqueId(nbt.getCompound(NBT_ID))");
        this.id = object;
        if (nbt.func_74764_b(NBT_POWER_SOURCE)) {
            object = nbt.func_74775_l(NBT_POWER_SOURCE);
            Intrinsics.checkNotNullExpressionValue(object, "nbt.getCompound(NBT_POWER_SOURCE)");
            this.powerSource = SpellPowerSourceInstance.Companion.createFromNBT((CompoundNBT)object);
        }
        ListNBT spellStagesNBT = nbt.func_150295_c(NBT_SPELL_STAGES, 10);
        this.spellStages.clear();
        int n = 0;
        int n2 = spellStagesNBT.size();
        if (n < n2) {
            do {
                int i = n++;
                CompoundNBT spellStageNBT = spellStagesNBT.func_150305_b(i);
                Intrinsics.checkNotNullExpressionValue(spellStageNBT, "spellStageNBT");
                SpellStage spellStage = new SpellStage(spellStageNBT);
                this.spellStages.add(spellStage);
            } while (n < n2);
        }
    }

    @NotNull
    public String toString() {
        SpellPowerSource spellPowerSource;
        ResourceLocation resourceLocation = this.powerSource;
        SpellPowerSource spellPowerSource2 = spellPowerSource = resourceLocation == null ? null : resourceLocation.getComponent();
        return "Spell " + this.getName() + "\nPower Source: " + (spellPowerSource == null ? null : ((resourceLocation = spellPowerSource.getRegistryName()) == null ? null : resourceLocation.func_110623_a())) + "\nSpell Stages:\n" + CollectionsKt.joinToString$default(this.spellStages, "\n", null, null, 0, null, toString.1.INSTANCE, 30, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/Spell$Companion;", "", "()V", "NBT_ID", "", "NBT_NAME", "NBT_POWER_SOURCE", "NBT_SPELL_STAGES", "SPELL_TIER2_CUTOFF", "", "SPELL_TIER3_CUTOFF", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

