/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod;

import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.AOTDSpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.property.DoubleSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import javax.vecmath.Matrix3d;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0014\u0010\f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0014\u0010\u000e\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\u0010"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/RotateSpellDeliveryMethod;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/AOTDSpellDeliveryMethod;", "()V", "executeDelivery", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/SpellDeliveryMethod;", "getPitch", "getStageCostMultiplier", "getYaw", "Companion", "afraidofthedark"})
public final class RotateSpellDeliveryMethod
extends AOTDSpellDeliveryMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_YAW = "yaw";
    @NotNull
    private static final String NBT_PITCH = "pitch";

    public RotateSpellDeliveryMethod() {
        super(new ResourceLocation("afraidofthedark", "rotate"));
        this.addEditableProperty(((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.doubleProperty().withName("Yaw")).withDescription("The yaw (left/right rotation) to apply in degrees. Yaw gets applied before pitch")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(0.0)).withMinValue(-180.0)).withMaxValue(180.0)).build());
        this.addEditableProperty(((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.doubleProperty().withName("Pitch")).withDescription("The pitch (up/down rotation) to apply in degrees. Yaw gets applied before pitch")).withSetter(3.INSTANCE)).withGetter(4.INSTANCE)).withDefaultValue(0.0)).withMinValue(-90.0)).withMaxValue(90.0)).build());
    }

    @Override
    public void executeDelivery(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
        Intrinsics.checkNotNull(spellComponentInstance);
        SpellComponentInstance<SpellDeliveryMethod> instance = spellComponentInstance;
        double yaw = Math.toRadians(this.getYaw(instance));
        double pitch = Math.toRadians(this.getPitch(instance));
        Vec3d forwardBackwardDir = state.getDirection();
        Vec3d leftRightDir = forwardBackwardDir.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
        Vec3d upDownDir = forwardBackwardDir.func_72431_c(leftRightDir).func_72432_b();
        Intrinsics.checkNotNullExpressionValue(upDownDir, "upDownDir");
        Vec3d vec3d = RotateSpellDeliveryMethod.Companion.rotateAround(forwardBackwardDir, upDownDir, yaw);
        Intrinsics.checkNotNullExpressionValue(leftRightDir, "leftRightDir");
        Vec3d finalDir = RotateSpellDeliveryMethod.Companion.rotateAround(vec3d, leftRightDir, pitch);
        DeliveryTransitionState newState = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(state.getStageIndex()).withWorld((World)state.getWorld()).withPosition(state.getPosition()).withBlockPosition(state.getBlockPosition()).withDirection(finalDir).withCasterEntity(state.getCasterEntity()).build();
        this.procEffects(newState);
        this.transitionFrom(newState);
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return 10.0;
    }

    @Override
    public double getStageCostMultiplier(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return 1.0;
    }

    public final double getYaw(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74769_h(NBT_YAW);
    }

    public final double getPitch(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74769_h(NBT_PITCH);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u00020\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002J\u001c\u0010\u000b\u001a\u00020\t*\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/RotateSpellDeliveryMethod$Companion;", "", "()V", "NBT_PITCH", "", "NBT_YAW", "cloneSafe", "Ljavax/vecmath/Matrix3d;", "mul", "Lnet/minecraft/util/math/Vec3d;", "vec", "rotateAround", "axis", "radians", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        private final Vec3d rotateAround(Vec3d $this$rotateAround, Vec3d axis, double radians) {
            Matrix3d basisMatrix = new Matrix3d(0.0, -axis.field_72449_c, axis.field_72448_b, axis.field_72449_c, 0.0, -axis.field_72450_a, -axis.field_72448_b, axis.field_72450_a, 0.0);
            Matrix3d matrix3d = this.cloneSafe(basisMatrix);
            boolean bl = false;
            boolean bl2 = false;
            Matrix3d $this$rotateAround_u24lambda_u2d0 = matrix3d;
            boolean bl3 = false;
            boolean bl4 = false;
            $this$rotateAround_u24lambda_u2d0.mul(Math.sin(radians));
            Matrix3d termTwo = matrix3d;
            Matrix3d matrix3d2 = this.cloneSafe(basisMatrix);
            bl2 = false;
            boolean bl5 = false;
            Matrix3d $this$rotateAround_u24lambda_u2d1 = matrix3d2;
            boolean bl6 = false;
            $this$rotateAround_u24lambda_u2d1.mul(Companion.cloneSafe(basisMatrix));
            boolean bl7 = false;
            $this$rotateAround_u24lambda_u2d1.mul(1.0 - Math.cos(radians));
            Matrix3d termThree = matrix3d2;
            Matrix3d matrix3d3 = new Matrix3d();
            bl5 = false;
            boolean bl8 = false;
            Matrix3d $this$rotateAround_u24lambda_u2d2 = matrix3d3;
            boolean bl9 = false;
            $this$rotateAround_u24lambda_u2d2.setIdentity();
            $this$rotateAround_u24lambda_u2d2.add(termTwo);
            $this$rotateAround_u24lambda_u2d2.add(termThree);
            Matrix3d rotationMatrix = matrix3d3;
            return this.mul(rotationMatrix, $this$rotateAround);
        }

        private final Matrix3d cloneSafe(Matrix3d $this$cloneSafe) {
            return (Matrix3d)$this$cloneSafe.clone();
        }

        private final Vec3d mul(Matrix3d $this$mul, Vec3d vec) {
            return new Vec3d($this$mul.m00 * vec.field_72450_a + $this$mul.m01 * vec.field_72448_b + $this$mul.m02 * vec.field_72449_c, $this$mul.m10 * vec.field_72450_a + $this$mul.m11 * vec.field_72448_b + $this$mul.m12 * vec.field_72449_c, $this$mul.m20 * vec.field_72450_a + $this$mul.m21 * vec.field_72448_b + $this$mul.m22 * vec.field_72449_c);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

