/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.IntSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0016\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/BurnSpellEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getBurnDuration", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getCost", "", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "reducedParticles", "", "Companion", "afraidofthedark"})
public final class BurnSpellEffect
extends AOTDSpellEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_BURN_DURATION = "burn_duration";

    public BurnSpellEffect() {
        super(new ResourceLocation("afraidofthedark", "burn"));
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Burn")).withDescription("The number of seconds to set fire to when hitting entities.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(2)).withMinValue(1)).withMaxValue(60)).build());
    }

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance, boolean reducedParticles) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(instance, "instance");
        if (state.getEntity() != null) {
            Entity entity = state.getEntity();
            Intrinsics.checkNotNull(entity);
            Vec3d vec3d = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            DimensionType dimensionType = entity.field_71093_bK;
            Intrinsics.checkNotNullExpressionValue(dimensionType, "entity.dimension");
            AOTDSpellEffect.Companion.createParticlesAt(5, 10, vec3d, dimensionType, ModParticles.INSTANCE.getFIRE());
            entity.func_70015_d(this.getBurnDuration(instance));
        } else {
            BlockState blockState;
            BlockPos position;
            ServerWorld world = state.getWorld();
            BlockState upBlockState = world.func_180495_p((position = state.getBlockPosition()).func_177984_a());
            if (upBlockState.isAir((IBlockReader)world, position.func_177984_a()) && !(blockState = world.func_180495_p(position)).isAir((IBlockReader)world, position)) {
                if (reducedParticles) {
                    Vec3d vec3d = state.getPosition();
                    DimensionType dimensionType = world.field_73011_w.func_186058_p();
                    Intrinsics.checkNotNullExpressionValue(dimensionType, "world.dimension.type");
                    AOTDSpellEffect.Companion.createParticlesAround(0, 1, vec3d, dimensionType, ModParticles.INSTANCE.getFIRE(), 0.5);
                } else {
                    Vec3d vec3d = state.getPosition();
                    DimensionType dimensionType = world.field_73011_w.func_186058_p();
                    Intrinsics.checkNotNullExpressionValue(dimensionType, "world.dimension.type");
                    AOTDSpellEffect.Companion.createParticlesAround(2, 4, vec3d, dimensionType, ModParticles.INSTANCE.getFIRE(), 0.5);
                }
                world.func_175656_a(position.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return 10.0 + (double)this.getBurnDuration(instance) * 5.0;
    }

    public final int getBurnDuration(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74762_e(NBT_BURN_DURATION);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/BurnSpellEffect$Companion;", "", "()V", "NBT_BURN_DURATION", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

