/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.world.schematic;

import com.davidm1a2.afraidofthedark.common.constants.ModCommonConfiguration;
import com.davidm1a2.afraidofthedark.common.utility.ResourceUtil;
import com.davidm1a2.afraidofthedark.common.world.schematic.Schematic;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020!H\u0002R\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/schematic/OnDemandSchematic;", "Lcom/davidm1a2/afraidofthedark/common/world/schematic/Schematic;", "schematicLocation", "Lnet/minecraft/util/ResourceLocation;", "name", "", "width", "", "height", "length", "(Lnet/minecraft/util/ResourceLocation;Ljava/lang/String;SSS)V", "blocks", "", "Lnet/minecraft/block/BlockState;", "[Lnet/minecraft/block/BlockState;", "entities", "Lnet/minecraft/nbt/ListNBT;", "lastTimeAccessed", "", "Ljava/lang/Long;", "tileEntities", "checkTimeout", "", "demandCache", "getBlocks", "()[Lnet/minecraft/block/BlockState;", "getEntities", "getHeight", "getLength", "getName", "getTileEntities", "getWidth", "isTimedOut", "", "Companion", "afraidofthedark"})
public final class OnDemandSchematic
implements Schematic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation schematicLocation;
    @NotNull
    private final String name;
    private final short width;
    private final short height;
    private final short length;
    @Nullable
    private Long lastTimeAccessed;
    @Nullable
    private ListNBT tileEntities;
    @Nullable
    private BlockState[] blocks;
    @Nullable
    private ListNBT entities;
    private static final Logger logger = LogManager.getLogger();
    @NotNull
    private static final Timer TIMEOUT_TIMER = new Timer("Schematic Cache Timeout Timer");
    @NotNull
    private static final List<OnDemandSchematic> ON_DEMAND_SCHEMATICS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnDemandSchematic(@NotNull ResourceLocation schematicLocation, @NotNull String name, short width, short height, short length) {
        Intrinsics.checkNotNullParameter(schematicLocation, "schematicLocation");
        Intrinsics.checkNotNullParameter(name, "name");
        this.schematicLocation = schematicLocation;
        this.name = name;
        this.width = width;
        this.height = height;
        this.length = length;
        List<OnDemandSchematic> list = ON_DEMAND_SCHEMATICS;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = ON_DEMAND_SCHEMATICS.add(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void demandCache() {
        boolean wasTimedOut = this.isTimedOut();
        this.lastTimeAccessed = System.currentTimeMillis();
        if (wasTimedOut) {
            try {
                void $this$toTypedArray$iv;
                Object $this$mapTo$iv$iv;
                Object object;
                Object object2;
                void $this$mapTo$iv$iv2;
                InputStream inputStream = ResourceUtil.INSTANCE.getInputStream(this.schematicLocation);
                CompoundNBT nbtData = CompressedStreamTools.func_74796_a((InputStream)inputStream);
                this.tileEntities = nbtData.func_150295_c("TileEntities", 10);
                this.entities = nbtData.func_150295_c("Entities", 10);
                int[] blockIds = nbtData.func_74759_k("BlockIds");
                ListNBT listNBT = nbtData.func_150295_c("BlockIdData", 10);
                Intrinsics.checkNotNullExpressionValue(listNBT, "nbtData.getList(\"BlockIdData\", Constants.NBT.TAG_COMPOUND)");
                Iterable $this$map$iv = (Iterable)listNBT;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    INBT iNBT = (INBT)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl = false;
                    if (it == null) {
                        throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundNBT");
                    }
                    object = (CompoundNBT)it;
                    object2.add(object);
                }
                List blockMapData = (List)destination$iv$iv;
                Object $this$map$iv2 = blockMapData;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                Object object3 = $this$mapTo$iv$iv.iterator();
                while (object3.hasNext()) {
                    void it;
                    Object item$iv$iv = object3.next();
                    CompoundNBT bl = (CompoundNBT)item$iv$iv;
                    object2 = destination$iv$iv2;
                    boolean bl2 = false;
                    object = NBTUtil.func_190008_d((CompoundNBT)it);
                    object2.add(object);
                }
                List blockMapBlocks = (List)destination$iv$iv2;
                Intrinsics.checkNotNullExpressionValue(blockIds, "blockIds");
                $this$map$iv2 = blockIds;
                object2 = this;
                $i$f$map2 = false;
                $this$mapTo$iv$iv = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(((Object)$this$map$iv2).length);
                $i$f$mapTo2 = false;
                object3 = $this$mapTo$iv$iv;
                int n = ((Object)object3).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    Object item$iv$iv;
                    Object object4 = item$iv$iv = object3[i];
                    object = destination$iv$iv2;
                    boolean bl = false;
                    BlockState blockState = (BlockState)blockMapBlocks.get((int)it);
                    object.add(blockState);
                }
                object = (List)destination$iv$iv2;
                $this$map$iv2 = (Collection)object;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                BlockState[] blockStateArray = thisCollection$iv.toArray(new BlockState[0]);
                if (blockStateArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                ((OnDemandSchematic)object2).blocks = blockStateArray;
                logger.info("Loaded " + this.name + " into memory.");
            }
            catch (IOException e) {
                logger.error(Intrinsics.stringPlus("Could not load on-demand schematic ", this.name), (Throwable)e);
            }
        }
    }

    private final synchronized void checkTimeout() {
        if (this.lastTimeAccessed != null && this.isTimedOut()) {
            this.lastTimeAccessed = null;
            this.tileEntities = null;
            this.blocks = null;
            this.entities = null;
            logger.info("Cleared " + this.name + " from memory.");
        }
    }

    private final synchronized boolean isTimedOut() {
        boolean bl;
        if (this.lastTimeAccessed == null) {
            bl = true;
        } else {
            long l = System.currentTimeMillis();
            Long l2 = this.lastTimeAccessed;
            Intrinsics.checkNotNull(l2);
            bl = l - l2 > ModCommonConfiguration.INSTANCE.getCacheTimeout();
        }
        return bl;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public synchronized ListNBT getTileEntities() {
        this.demandCache();
        ListNBT listNBT = this.tileEntities;
        Intrinsics.checkNotNull(listNBT);
        return listNBT;
    }

    @Override
    public short getWidth() {
        return this.width;
    }

    @Override
    public short getHeight() {
        return this.height;
    }

    @Override
    public short getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public synchronized BlockState[] getBlocks() {
        this.demandCache();
        BlockState[] blockStateArray = this.blocks;
        Intrinsics.checkNotNull(blockStateArray);
        return blockStateArray;
    }

    @Override
    @NotNull
    public synchronized ListNBT getEntities() {
        this.demandCache();
        ListNBT listNBT = this.entities;
        Intrinsics.checkNotNull(listNBT);
        return listNBT;
    }

    public static final /* synthetic */ List access$getON_DEMAND_SCHEMATICS$cp() {
        return ON_DEMAND_SCHEMATICS;
    }

    public static final /* synthetic */ void access$checkTimeout(OnDemandSchematic $this) {
        $this.checkTimeout();
    }

    static {
        boolean bl = false;
        ON_DEMAND_SCHEMATICS = new ArrayList();
        TIMEOUT_TIMER.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = OnDemandSchematic.access$getON_DEMAND_SCHEMATICS$cp();
                boolean bl = false;
                boolean bl2 = false;
                synchronized (list) {
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = OnDemandSchematic.access$getON_DEMAND_SCHEMATICS$cp();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        OnDemandSchematic it = (OnDemandSchematic)element$iv;
                        boolean bl4 = false;
                        OnDemandSchematic.access$checkTimeout(it);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }, 0L, 5000L);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/schematic/OnDemandSchematic$Companion;", "", "()V", "ON_DEMAND_SCHEMATICS", "", "Lcom/davidm1a2/afraidofthedark/common/world/schematic/OnDemandSchematic;", "TIMEOUT_TIMER", "Ljava/util/Timer;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

