/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.world.schematic;

import com.davidm1a2.afraidofthedark.common.world.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.world.schematic.SchematicBuilder;
import com.davidm1a2.afraidofthedark.common.world.schematic.SchematicUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012J\u001e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J.\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000eJ \u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/schematic/SchematicUtils;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "createMetaFor", "", "schematicFile", "Ljava/io/File;", "createSchematicMetaFiles", "generateMcMetaFileForDir", "schematicDir", "getBlock", "Lnet/minecraft/block/BlockState;", "schematic", "Lcom/davidm1a2/afraidofthedark/common/world/schematic/Schematic;", "x", "", "y", "z", "placeRawSchematic", "world", "Lnet/minecraft/world/World;", "position", "Lnet/minecraft/util/math/BlockPos;", "setBlock", "block", "updateStructureVoids", "add", "", "writeToFile", "file", "afraidofthedark"})
public final class SchematicUtils {
    @NotNull
    public static final SchematicUtils INSTANCE = new SchematicUtils();
    private static final Logger logger = LogManager.getLogger();

    private SchematicUtils() {
    }

    public final void setBlock(@NotNull Schematic schematic, int x, int y, int z, @NotNull BlockState block) {
        Intrinsics.checkNotNullParameter(schematic, "schematic");
        Intrinsics.checkNotNullParameter(block, "block");
        short width = schematic.getWidth();
        short length = schematic.getLength();
        schematic.getBlocks()[x + y * length * width + z * width] = block;
    }

    @NotNull
    public final BlockState getBlock(@NotNull Schematic schematic, int x, int y, int z) {
        Intrinsics.checkNotNullParameter(schematic, "schematic");
        short width = schematic.getWidth();
        short length = schematic.getLength();
        return schematic.getBlocks()[x + y * length * width + z * width];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void writeToFile(@NotNull Schematic schematic, @NotNull File file) {
        Intrinsics.checkNotNullParameter(schematic, "schematic");
        Intrinsics.checkNotNullParameter(file, "file");
        if (file.exists()) {
            logger.warn("File already exists, returning...");
            return;
        }
        try {
            Object object;
            BlockState it;
            Collection collection;
            void $this$mapTo$iv$iv;
            BlockState[] blocks;
            file.getParentFile().mkdirs();
            file.createNewFile();
            CompoundNBT schematicNBT = new CompoundNBT();
            schematicNBT.func_74777_a("Width", schematic.getWidth());
            schematicNBT.func_74777_a("Height", schematic.getHeight());
            schematicNBT.func_74777_a("Length", schematic.getLength());
            schematicNBT.func_218657_a("TileEntities", (INBT)schematic.getTileEntities());
            schematicNBT.func_218657_a("Entities", (INBT)schematic.getEntities());
            Ref.IntRef lastBlockId = new Ref.IntRef();
            boolean bl = false;
            Map stateToBlock = new LinkedHashMap();
            BlockState[] $this$map$iv = blocks = schematic.getBlocks();
            boolean $i$f$map = false;
            BlockState[] blockStateArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var13_18 = $this$mapTo$iv$iv;
            int n = ((void)var13_18).length;
            for (int i = 0; i < n; ++i) {
                void item$iv$iv;
                void var17_23 = item$iv$iv = var13_18[i];
                collection = destination$iv$iv;
                boolean bl2 = false;
                object = stateToBlock.computeIfAbsent(it, arg_0 -> SchematicUtils.writeToFile$lambda-1$lambda-0(lastBlockId, arg_0));
                collection.add(object);
            }
            int[] blockIds = CollectionsKt.toIntArray((List)destination$iv$iv);
            schematicNBT.func_218657_a("BlockIds", (INBT)new IntArrayNBT(blockIds));
            Object object2 = new ListNBT();
            boolean bl3 = false;
            boolean bl4 = false;
            destination$iv$iv = object2;
            object = "BlockIdData";
            collection = schematicNBT;
            boolean bl5 = false;
            Iterable $this$forEach$iv = stateToBlock.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$writeToFile_u24lambda_u2d3;
                it = (BlockState)element$iv;
                boolean bl6 = false;
                $this$writeToFile_u24lambda_u2d3.add((Object)NBTUtil.func_190009_a((BlockState)it));
            }
            Unit unit = Unit.INSTANCE;
            collection.func_218657_a((String)object, (INBT)object2);
            object2 = new FileOutputStream(file);
            bl3 = false;
            bl4 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it2 = (FileOutputStream)object2;
                boolean bl7 = false;
                CompressedStreamTools.func_74799_a((CompoundNBT)schematicNBT, (OutputStream)it2);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, throwable);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    public final void createSchematicMetaFiles() {
        this.generateMcMetaFileForDir(new File("../src/main/resources/assets/afraidofthedark/schematics"));
    }

    private final void generateMcMetaFileForDir(File schematicDir) {
        File[] subfiles = schematicDir.listFiles();
        if (subfiles != null) {
            File it;
            File element$iv$iv;
            int n;
            File[] $this$filterTo$iv$iv;
            Object $this$filter$iv = subfiles;
            boolean $i$f$filter = false;
            File[] fileArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var8_10 = $this$filterTo$iv$iv;
            int n2 = ((void)var8_10).length;
            for (n = 0; n < n2; ++n) {
                it = element$iv$iv = var8_10[n];
                boolean bl = false;
                if (!it.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it2 = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it2, "it");
                INSTANCE.generateMcMetaFileForDir(it2);
            }
            $this$filter$iv = subfiles;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            File[] bl = $this$filterTo$iv$iv;
            int n3 = bl.length;
            for (n = 0; n < n3; ++n) {
                it = element$iv$iv = bl[n];
                boolean bl2 = false;
                if (!it.isFile()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object e : $this$filterTo$iv$iv) {
                File it3 = (File)e;
                boolean bl3 = false;
                String string = it3.getName();
                Intrinsics.checkNotNullExpressionValue(string, "it.name");
                if (!StringsKt.endsWith$default(string, ".schematic", false, 2, null)) continue;
                destination$iv$iv.add(e);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it4 = (File)element$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue(it4, "it");
                INSTANCE.createMetaFor(it4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createMetaFor(File schematicFile) {
        File schematicMetaFile = new File(Intrinsics.stringPlus(schematicFile.getAbsolutePath(), ".meta"));
        if (schematicMetaFile.exists()) {
            schematicMetaFile.delete();
        }
        String string = schematicFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "schematicFile.absolutePath");
        String localPath = StringUtils.substringAfter((String)StringsKt.replace$default(string, "\\", "/", false, 4, null), (String)"src/main/resources/assets/afraidofthedark/");
        Schematic schematic = new SchematicBuilder().withFile(new ResourceLocation("afraidofthedark", localPath)).withCacheEnabled(true).build();
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74777_a("width", schematic.getWidth());
        nbt.func_74777_a("height", schematic.getHeight());
        nbt.func_74777_a("length", schematic.getLength());
        try {
            Closeable closeable = new FileOutputStream(schematicMetaFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl3 = false;
                CompressedStreamTools.func_74799_a((CompoundNBT)nbt, (OutputStream)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            System.err.println(Intrinsics.stringPlus("Could not write schematic .meta file:\n", ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    public final void placeRawSchematic(@NotNull Schematic schematic, @NotNull World world, @NotNull BlockPos position) {
        ListNBT entities;
        ListNBT tileEntities;
        int n;
        int indexX2;
        int n2;
        int y;
        Intrinsics.checkNotNullParameter(schematic, "schematic");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(position, "position");
        BlockState[] blocks = schematic.getBlocks();
        int width = schematic.getWidth();
        int height = schematic.getHeight();
        int length = schematic.getLength();
        int posX = 0;
        int posY = 0;
        int posZ = 0;
        int endX = width;
        int endY = height;
        int endZ = length;
        int n3 = posY;
        if (n3 < endY) {
            do {
                y = n3++;
                int indexY = (y - posY) * length * width;
                n2 = posZ;
                if (n2 >= endZ) continue;
                do {
                    int z = n2++;
                    int indexZ = (z - posZ) * width;
                    int n4 = posX;
                    if (n4 >= endX) continue;
                    do {
                        int x = n4++;
                        indexX2 = x - posX;
                        int index = indexY + indexZ + indexX2;
                        BlockState nextToPlace = blocks[index];
                        world.func_175656_a(position.func_177982_a(x, y, z), nextToPlace);
                    } while (n4 < endX);
                } while (n2 < endZ);
            } while (n3 < endY);
        }
        if ((y = 0) < (n = (tileEntities = schematic.getTileEntities()).size())) {
            do {
                int i = y++;
                CompoundNBT tileEntityCompound = tileEntities.func_150305_b(i);
                BlockPos tileEntityPosition = position.func_177982_a(tileEntityCompound.func_74762_e("x"), tileEntityCompound.func_74762_e("y"), tileEntityCompound.func_74762_e("z"));
                CompoundNBT x = tileEntityCompound.func_74737_b();
                indexX2 = 0;
                boolean bl = false;
                CompoundNBT $this$placeRawSchematic_u24lambda_u2d11 = x;
                boolean bl2 = false;
                $this$placeRawSchematic_u24lambda_u2d11.func_74768_a("x", tileEntityPosition.func_177958_n());
                $this$placeRawSchematic_u24lambda_u2d11.func_74768_a("y", tileEntityPosition.func_177956_o());
                $this$placeRawSchematic_u24lambda_u2d11.func_74768_a("z", tileEntityPosition.func_177952_p());
                CompoundNBT newTileEntityCompound = x;
                x = world.func_175625_s(tileEntityPosition);
                if (x == null) continue;
                x.func_145839_a(newTileEntityCompound);
            } while (y < n);
        }
        if ((n = 0) < (n2 = (entities = schematic.getEntities()).size())) {
            do {
                int i;
                CompoundNBT entityCompound;
                Optional entityOpt;
                if (!(entityOpt = EntityType.func_220330_a((CompoundNBT)(entityCompound = entities.func_150305_b(i = n++)), (World)world.func_201672_e())).isPresent()) continue;
                Object indexX2 = entityOpt.get();
                Intrinsics.checkNotNullExpressionValue(indexX2, "entityOpt.get()");
                Entity entity = (Entity)indexX2;
                entity.func_184221_a(UUID.randomUUID());
                double newX = (double)position.func_177958_n() + entity.field_70165_t;
                double newY = (double)position.func_177956_o() + entity.field_70163_u;
                double newZ = (double)position.func_177952_p() + entity.field_70165_t;
                entity.func_70107_b(newX, newY, newZ);
                world.func_217376_c(entity);
            } while (n < n2);
        }
    }

    public final void updateStructureVoids(@NotNull World world, @NotNull BlockPos position, boolean add) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(position, "position");
        boolean bl = false;
        Set blocksToUpdate = new LinkedHashSet();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(position);
        Function2 shouldUpdate2 = add ? (Function2)new Function2<BlockState, BlockPos, Boolean>(world){
            final /* synthetic */ World $world;
            {
                this.$world = $world;
                super(2);
            }

            public final boolean invoke(@NotNull BlockState state, @NotNull BlockPos pos) {
                Intrinsics.checkNotNullParameter(state, "state");
                Intrinsics.checkNotNullParameter(pos, "pos");
                return state.isAir((IBlockReader)this.$world, pos);
            }
        } : (Function2)updateStructureVoids.shouldUpdate.2.INSTANCE;
        while (true) {
            Collection collection = queue;
            boolean bl2 = false;
            if (!(!collection.isEmpty()) || blocksToUpdate.size() >= 1000000) break;
            BlockPos pos = (BlockPos)queue.pop();
            if (blocksToUpdate.contains(pos)) continue;
            BlockState blockState = world.func_180495_p(pos);
            Intrinsics.checkNotNullExpressionValue(blockState, "blockState");
            Intrinsics.checkNotNullExpressionValue(pos, "pos");
            if (!((Boolean)shouldUpdate2.invoke(blockState, pos)).booleanValue()) continue;
            blocksToUpdate.add(pos);
            queue.add(pos.func_177984_a());
            queue.add(pos.func_177977_b());
            queue.add(pos.func_177978_c());
            queue.add(pos.func_177968_d());
            queue.add(pos.func_177974_f());
            queue.add(pos.func_177976_e());
        }
        if (blocksToUpdate.size() < 1000000) {
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            if (add) {
                $this$forEach$iv = blocksToUpdate;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BlockPos it = (BlockPos)element$iv;
                    boolean bl3 = false;
                    world.func_175656_a(it, Blocks.field_189881_dj.func_176223_P());
                }
            } else {
                $this$forEach$iv = blocksToUpdate;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BlockPos it = (BlockPos)element$iv;
                    boolean bl4 = false;
                    world.func_175656_a(it, Blocks.field_150350_a.func_176223_P());
                }
            }
        } else {
            logger.error("OVERFLOW");
        }
    }

    public static /* synthetic */ void updateStructureVoids$default(SchematicUtils schematicUtils, World world, BlockPos blockPos, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        schematicUtils.updateStructureVoids(world, blockPos, bl);
    }

    private static final Integer writeToFile$lambda-1$lambda-0(Ref.IntRef $lastBlockId, BlockState it) {
        Intrinsics.checkNotNullParameter($lastBlockId, "$lastBlockId");
        Intrinsics.checkNotNullParameter(it, "it");
        int n = $lastBlockId.element;
        $lastBlockId.element = n + 1;
        return n;
    }
}

