/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.world.structure.base;

import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.constants.ModLootTables;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.constants.ModStructures;
import com.davidm1a2.afraidofthedark.common.world.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.world.structure.base.LootTable;
import com.davidm1a2.afraidofthedark.common.world.structure.base.SchematicStructurePiece;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BG\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0018H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010%\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010&\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020(2\u0006\u0010\b\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020(H\u0002J\u0018\u0010*\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020(2\u0006\u0010\b\u001a\u00020(H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u0003H\u0014J\u0012\u0010-\u001a\u00020$2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u000e\u0010.\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\u0006R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/base/SchematicStructurePiece;", "Lnet/minecraft/world/gen/feature/structure/StructurePiece;", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "(Lnet/minecraft/nbt/CompoundNBT;)V", "x", "", "y", "z", "random", "Ljava/util/Random;", "schematic", "Lcom/davidm1a2/afraidofthedark/common/world/schematic/Schematic;", "lootTable", "Lcom/davidm1a2/afraidofthedark/common/world/structure/base/LootTable;", "facing", "Lnet/minecraft/util/Direction;", "(IIILjava/util/Random;Lcom/davidm1a2/afraidofthedark/common/world/schematic/Schematic;Lcom/davidm1a2/afraidofthedark/common/world/structure/base/LootTable;Lnet/minecraft/util/Direction;)V", "mirror", "Lnet/minecraft/util/Mirror;", "mirrorBlockFixer", "", "Lnet/minecraft/block/Block;", "Lkotlin/Function1;", "Lnet/minecraft/block/BlockState;", "addComponentParts", "", "world", "Lnet/minecraft/world/IWorld;", "structureBoundingBox", "Lnet/minecraft/util/math/MutableBoundingBox;", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "fixStairState", "state", "generateBlocks", "", "generateEntities", "generateTileEntities", "getXWithOffset", "", "getYWithOffset", "getZWithOffset", "readAdditional", "tagCompound", "setCoordBaseMode", "updateY", "Companion", "afraidofthedark"})
public final class SchematicStructurePiece
extends StructurePiece {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Schematic schematic;
    @Nullable
    private final LootTable lootTable;
    @NotNull
    private Mirror mirror;
    @NotNull
    private final Map<Block, Function1<BlockState, BlockState>> mirrorBlockFixer;
    @NotNull
    private static final String NBT_SCHEMATIC_NAME = "schematic_name";
    @NotNull
    private static final String NBT_LOOT_TABLE_NAME = "loot_table_name";

    /*
     * WARNING - void declaration
     */
    public SchematicStructurePiece(@NotNull CompoundNBT nbt) {
        Collection<Pair<void, mirrorBlockFixer.2.1>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super(ModStructures.INSTANCE.getSCHEMATIC_STRUCTURE_PIECE(), nbt);
        this.mirror = Mirror.NONE;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(TuplesKt.to(Blocks.field_150486_ae, mirrorBlockFixer.1.INSTANCE));
        Object object = new Block[]{Blocks.field_150400_ck, Blocks.field_150487_bG, Blocks.field_150476_ad, Blocks.field_150485_bF, Blocks.field_150401_cl, Blocks.field_150481_bH, Blocks.field_203211_hf, Blocks.field_150387_bl, Blocks.field_203212_hg, Blocks.field_196659_cl, Blocks.field_150389_bf, Blocks.field_203210_he, Blocks.field_185769_cV, Blocks.field_150370_cb, Blocks.field_150372_bz, Blocks.field_180396_cN, Blocks.field_150390_bg, (Block)ModBlocks.INSTANCE.getGRAVEWOOD_STAIRS(), (Block)ModBlocks.INSTANCE.getMANGROVE_STAIRS(), (Block)ModBlocks.INSTANCE.getSACRED_MANGROVE_STAIRS()};
        object = SetsKt.setOf(object);
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        SchematicStructurePiece schematicStructurePiece = this;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Block block = (Block)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            $i$a$-map-SchematicStructurePiece$mirrorBlockFixer$2 = false;
            Pair<void, mirrorBlockFixer.2.1> pair = TuplesKt.to(it, new Function1<BlockState, BlockState>(this){

                @NotNull
                public final BlockState invoke(@NotNull BlockState p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return SchematicStructurePiece.access$fixStairState((SchematicStructurePiece)((Object)this.receiver), p0);
                }
            });
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Object $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder2.addSpread(pairArray);
        schematicStructurePiece.mirrorBlockFixer = MapsKt.mapOf((Pair[])spreadBuilder.toArray(new Pair[spreadBuilder.size()]));
        String schematicName = nbt.func_74779_i(NBT_SCHEMATIC_NAME);
        $this$toTypedArray$iv = ModSchematics.INSTANCE.getNAME_TO_SCHEMATIC().get(schematicName);
        if ($this$toTypedArray$iv == null) {
            throw new IllegalStateException("Schematic " + schematicName + " was not found");
        }
        this.schematic = $this$toTypedArray$iv;
        if (nbt.func_74764_b(NBT_LOOT_TABLE_NAME)) {
            String lootTableName = nbt.func_74779_i(NBT_LOOT_TABLE_NAME);
            LootTable lootTable = ModLootTables.INSTANCE.getNAME_TO_LOOT_TABLE().get(lootTableName);
            if (lootTable == null) {
                throw new IllegalStateException("LootTable " + lootTableName + " was not found");
            }
            this.lootTable = lootTable;
        } else {
            this.lootTable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SchematicStructurePiece(int x, int y, int z, @NotNull Random random, @NotNull Schematic schematic, @Nullable LootTable lootTable, @Nullable Direction facing) {
        void $this$toTypedArray$iv;
        Collection<Pair<void, mirrorBlockFixer.2.1>> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter(random, "random");
        Intrinsics.checkNotNullParameter(schematic, "schematic");
        super(ModStructures.INSTANCE.getSCHEMATIC_STRUCTURE_PIECE(), 0);
        this.mirror = Mirror.NONE;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add(TuplesKt.to(Blocks.field_150486_ae, mirrorBlockFixer.1.INSTANCE));
        Object object = new Block[]{Blocks.field_150400_ck, Blocks.field_150487_bG, Blocks.field_150476_ad, Blocks.field_150485_bF, Blocks.field_150401_cl, Blocks.field_150481_bH, Blocks.field_203211_hf, Blocks.field_150387_bl, Blocks.field_203212_hg, Blocks.field_196659_cl, Blocks.field_150389_bf, Blocks.field_203210_he, Blocks.field_185769_cV, Blocks.field_150370_cb, Blocks.field_150372_bz, Blocks.field_180396_cN, Blocks.field_150390_bg, (Block)ModBlocks.INSTANCE.getGRAVEWOOD_STAIRS(), (Block)ModBlocks.INSTANCE.getMANGROVE_STAIRS(), (Block)ModBlocks.INSTANCE.getSACRED_MANGROVE_STAIRS()};
        object = SetsKt.setOf(object);
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        SchematicStructurePiece schematicStructurePiece = this;
        boolean $i$f$map = false;
        void var11_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Block block = (Block)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            $i$a$-map-SchematicStructurePiece$mirrorBlockFixer$2 = false;
            Pair<void, mirrorBlockFixer.2.1> pair = TuplesKt.to(it, new /* invalid duplicate definition of identical inner class */);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        spreadBuilder2.addSpread(pairArray);
        schematicStructurePiece.mirrorBlockFixer = MapsKt.mapOf((Pair[])spreadBuilder.toArray(new Pair[spreadBuilder.size()]));
        this.schematic = schematic;
        this.lootTable = lootTable;
        boolean bl = facing == null || CollectionsKt.contains((Iterable)Direction.Plane.HORIZONTAL, facing);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        random.nextInt(4);
        Direction direction = facing;
        this.func_186164_a(direction == null ? Direction.Plane.HORIZONTAL.func_179518_a(random) : direction);
        direction = this.func_186165_e();
        this.field_74887_e = (direction == null ? null : direction.func_176740_k()) == Direction.Axis.Z ? new MutableBoundingBox(x, y, z, x + schematic.getWidth() - 1, y + schematic.getHeight() - 1, z + schematic.getLength() - 1) : new MutableBoundingBox(x, y, z, x + schematic.getLength() - 1, y + schematic.getHeight() - 1, z + schematic.getWidth() - 1);
    }

    public /* synthetic */ SchematicStructurePiece(int n, int n2, int n3, Random random, Schematic schematic, LootTable lootTable, Direction direction, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x20) != 0) {
            lootTable = null;
        }
        if ((n4 & 0x40) != 0) {
            direction = null;
        }
        this(n, n2, n3, random, schematic, lootTable, direction);
    }

    public final void updateY(int y) {
        this.field_74887_e.field_78895_b = y;
        this.field_74887_e.field_78894_e = y + this.schematic.getHeight() - 1;
    }

    public void func_186164_a(@Nullable Direction facing) {
        super.func_186164_a(facing);
        if (facing == null) {
            this.mirror = Mirror.NONE;
        } else {
            Direction direction = facing;
            int n = WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
            switch (n) {
                case 1: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    break;
                }
                case 2: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    break;
                }
                case 3: {
                    this.mirror = Mirror.NONE;
                    break;
                }
                default: {
                    this.mirror = Mirror.NONE;
                }
            }
        }
    }

    protected void func_143011_b(@NotNull CompoundNBT tagCompound) {
        Intrinsics.checkNotNullParameter(tagCompound, "tagCompound");
        tagCompound.func_74778_a(NBT_SCHEMATIC_NAME, this.schematic.getName());
        LootTable lootTable = this.lootTable;
        if (lootTable != null) {
            LootTable lootTable2 = lootTable;
            boolean bl = false;
            boolean bl2 = false;
            LootTable it = lootTable2;
            boolean bl3 = false;
            tagCompound.func_74778_a(NBT_LOOT_TABLE_NAME, it.getName());
        }
    }

    public boolean func_74875_a(@NotNull IWorld world, @NotNull Random random, @NotNull MutableBoundingBox structureBoundingBox, @NotNull ChunkPos chunkPos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(random, "random");
        Intrinsics.checkNotNullParameter(structureBoundingBox, "structureBoundingBox");
        Intrinsics.checkNotNullParameter(chunkPos, "chunkPos");
        this.generateBlocks(world, structureBoundingBox);
        this.generateTileEntities(world, random, structureBoundingBox);
        this.generateEntities(world, structureBoundingBox);
        return true;
    }

    private final void generateBlocks(IWorld world, MutableBoundingBox structureBoundingBox) {
        BlockState[] blocks = this.schematic.getBlocks();
        int width = this.schematic.getWidth();
        int height = this.schematic.getHeight();
        int length = this.schematic.getLength();
        int posX = 0;
        int posY = 0;
        int posZ = 0;
        int endX = width;
        int endY = height;
        int endZ = length;
        int n = posY;
        if (n < endY) {
            do {
                int y = n++;
                int indexY = (y - posY) * length * width;
                int n2 = posZ;
                if (n2 >= endZ) continue;
                do {
                    int z = n2++;
                    int indexZ = (z - posZ) * width;
                    int n3 = posX;
                    if (n3 >= endX) continue;
                    do {
                        int x;
                        int indexX;
                        int index;
                        BlockState nextToPlace;
                        if ((nextToPlace = blocks[index = indexY + indexZ + (indexX = (x = n3++) - posX)]).isAir((IBlockReader)world, new BlockPos(x, y, z))) continue;
                        if (Intrinsics.areEqual(nextToPlace.func_177230_c(), Blocks.field_189881_dj)) {
                            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, y, length - z - 1, structureBoundingBox);
                            continue;
                        }
                        if (this.mirror == Mirror.LEFT_RIGHT && this.mirrorBlockFixer.containsKey(nextToPlace.func_177230_c())) {
                            Function1<BlockState, BlockState> function1 = this.mirrorBlockFixer.get(nextToPlace.func_177230_c());
                            Intrinsics.checkNotNull(function1);
                            this.func_175811_a(world, function1.invoke(nextToPlace), x, y, length - z - 1, structureBoundingBox);
                            continue;
                        }
                        this.func_175811_a(world, nextToPlace, x, y, length - z - 1, structureBoundingBox);
                    } while (n3 < endX);
                } while (n2 < endZ);
            } while (n < endY);
        }
    }

    private final void generateTileEntities(IWorld world, Random random, MutableBoundingBox structureBoundingBox) {
        ListNBT tileEntities = this.schematic.getTileEntities();
        short length = this.schematic.getLength();
        int n = 0;
        int n2 = tileEntities.size();
        if (n < n2) {
            do {
                TileEntity tileEntity;
                int i = n++;
                CompoundNBT tileEntityCompound = tileEntities.func_150305_b(i);
                int posX = tileEntityCompound.func_74762_e("x");
                int posY = tileEntityCompound.func_74762_e("y");
                int posZ = tileEntityCompound.func_74762_e("z");
                BlockPos tileEntityPosition = new BlockPos(this.func_74865_a(posX, length - posZ - 1), this.func_74862_a(posY), this.func_74873_b(posX, length - posZ - 1));
                if (!structureBoundingBox.func_175898_b((Vec3i)tileEntityPosition) || (tileEntity = world.func_175625_s(tileEntityPosition)) == null) continue;
                Object object = tileEntityCompound.func_74737_b();
                boolean bl = false;
                boolean bl2 = false;
                CompoundNBT $this$generateTileEntities_u24lambda_u2d2 = object;
                boolean bl3 = false;
                $this$generateTileEntities_u24lambda_u2d2.func_74768_a("x", tileEntityPosition.func_177958_n());
                $this$generateTileEntities_u24lambda_u2d2.func_74768_a("y", tileEntityPosition.func_177956_o());
                $this$generateTileEntities_u24lambda_u2d2.func_74768_a("z", tileEntityPosition.func_177952_p());
                CompoundNBT newTileEntityCompound = object;
                tileEntity.func_145839_a(newTileEntityCompound);
                if (this.mirror != Mirror.NONE) {
                    tileEntity.func_189668_a(this.mirror);
                }
                if (this.func_214809_Y_() != Rotation.NONE) {
                    tileEntity.func_189667_a(this.func_214809_Y_());
                }
                if (!(tileEntity instanceof ChestTileEntity) || (object = this.lootTable) == null) continue;
                ChestTileEntity chestTileEntity = (ChestTileEntity)tileEntity;
                Intrinsics.checkNotNullExpressionValue(tileEntityCompound, "tileEntityCompound");
                ((LootTable)object).generate(chestTileEntity, tileEntityCompound, random);
            } while (n < n2);
        }
    }

    private final void generateEntities(IWorld world, MutableBoundingBox structureBoundingBox) {
        int n = 0;
        ListNBT entities = this.schematic.getEntities();
        int n2 = entities.size();
        if (n < n2) {
            do {
                int i;
                CompoundNBT entityCompound;
                Optional entityOpt;
                if (!(entityOpt = EntityType.func_220330_a((CompoundNBT)(entityCompound = entities.func_150305_b(i = n++)), (World)world.func_201672_e())).isPresent()) continue;
                Object t = entityOpt.get();
                Intrinsics.checkNotNullExpressionValue(t, "entityOpt.get()");
                Entity entity = (Entity)t;
                entity.func_184221_a(UUID.randomUUID());
                short length = this.schematic.getLength();
                double newX = this.getXWithOffset(entity.field_70165_t, (double)length - entity.field_70161_v - 1.0);
                double newY = this.getYWithOffset(entity.field_70163_u);
                double newZ = this.getZWithOffset(entity.field_70165_t, (double)length - entity.field_70161_v - 1.0);
                if (!structureBoundingBox.func_175898_b((Vec3i)new BlockPos(newX, newY, newZ))) continue;
                entity.func_70107_b(newX, newY, newZ);
                world.func_217376_c(entity);
            } while (n < n2);
        }
    }

    private final BlockState fixStairState(BlockState state) {
        Direction facing = (Direction)state.func_177229_b((IProperty)StairsBlock.field_176309_a);
        if (facing.func_176740_k() == Direction.Axis.X) {
            BlockState blockState;
            StairsShape stairsShape = (StairsShape)state.func_177229_b((IProperty)StairsBlock.field_176310_M);
            int n = stairsShape == null ? -1 : WhenMappings.$EnumSwitchMapping$1[stairsShape.ordinal()];
            switch (n) {
                case 1: {
                    Object object = state.func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_RIGHT);
                    Intrinsics.checkNotNullExpressionValue(object, "state.with(StairsBlock.SHAPE, StairsShape.INNER_RIGHT)");
                    blockState = (BlockState)object;
                    break;
                }
                case 2: {
                    Object object = state.func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_LEFT);
                    Intrinsics.checkNotNullExpressionValue(object, "state.with(StairsBlock.SHAPE, StairsShape.INNER_LEFT)");
                    blockState = (BlockState)object;
                    break;
                }
                case 3: {
                    Object object = state.func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_RIGHT);
                    Intrinsics.checkNotNullExpressionValue(object, "state.with(StairsBlock.SHAPE, StairsShape.OUTER_RIGHT)");
                    blockState = (BlockState)object;
                    break;
                }
                case 4: {
                    Object object = state.func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT);
                    Intrinsics.checkNotNullExpressionValue(object, "state.with(StairsBlock.SHAPE, StairsShape.OUTER_LEFT)");
                    blockState = (BlockState)object;
                    break;
                }
                default: {
                    blockState = state;
                }
            }
            return blockState;
        }
        return state;
    }

    private final double getXWithOffset(double x, double z) {
        double d;
        if (this.func_186165_e() == null) {
            d = x;
        } else {
            Direction direction = this.func_186165_e();
            int n = direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
            switch (n) {
                case 1: 
                case 4: {
                    d = (double)this.field_74887_e.field_78897_a + x;
                    break;
                }
                case 2: {
                    d = (double)this.field_74887_e.field_78893_d - z;
                    break;
                }
                case 3: {
                    d = (double)this.field_74887_e.field_78897_a + z;
                    break;
                }
                default: {
                    d = x;
                }
            }
        }
        return d;
    }

    private final double getYWithOffset(double y) {
        return this.func_186165_e() == null ? y : y + (double)this.field_74887_e.field_78895_b;
    }

    private final double getZWithOffset(double x, double z) {
        double d;
        if (this.func_186165_e() == null) {
            d = z;
        } else {
            Direction direction = this.func_186165_e();
            int n = direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
            switch (n) {
                case 4: {
                    d = (double)this.field_74887_e.field_78892_f - z;
                    break;
                }
                case 1: {
                    d = (double)this.field_74887_e.field_78896_c + z;
                    break;
                }
                case 2: 
                case 3: {
                    d = (double)this.field_74887_e.field_78896_c + x;
                    break;
                }
                default: {
                    d = z;
                }
            }
        }
        return d;
    }

    public static final /* synthetic */ BlockState access$fixStairState(SchematicStructurePiece $this, BlockState state) {
        return $this.fixStairState(state);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/base/SchematicStructurePiece$Companion;", "", "()V", "NBT_LOOT_TABLE_NAME", "", "NBT_SCHEMATIC_NAME", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Direction.values().length];
            nArray[Direction.SOUTH.ordinal()] = 1;
            nArray[Direction.WEST.ordinal()] = 2;
            nArray[Direction.EAST.ordinal()] = 3;
            nArray[Direction.NORTH.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StairsShape.values().length];
            nArray[StairsShape.INNER_LEFT.ordinal()] = 1;
            nArray[StairsShape.INNER_RIGHT.ordinal()] = 2;
            nArray[StairsShape.OUTER_LEFT.ordinal()] = 3;
            nArray[StairsShape.OUTER_RIGHT.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

