/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.world.structure.darkforest;

import com.davidm1a2.afraidofthedark.common.constants.ModLootTables;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.world.WorldHeightmap;
import com.davidm1a2.afraidofthedark.common.world.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.world.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.world.structure.base.ChunkGeneratorExtensionsKt;
import com.davidm1a2.afraidofthedark.common.world.structure.base.SchematicStructurePiece;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBA\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ4\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0017\u001a\u00020\u0005*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/darkforest/DarkForestStructureStart;", "Lnet/minecraft/world/gen/feature/structure/StructureStart;", "structure", "Lnet/minecraft/world/gen/feature/structure/Structure;", "chunkX", "", "chunkZ", "biomeIn", "Lnet/minecraft/world/biome/Biome;", "boundsIn", "Lnet/minecraft/util/math/MutableBoundingBox;", "referenceIn", "seed", "", "(Lnet/minecraft/world/gen/feature/structure/Structure;IILnet/minecraft/world/biome/Biome;Lnet/minecraft/util/math/MutableBoundingBox;IJ)V", "init", "", "generator", "Lnet/minecraft/world/gen/ChunkGenerator;", "templateManagerIn", "Lnet/minecraft/world/gen/feature/template/TemplateManager;", "centerChunkX", "centerChunkZ", "nextInt", "Ljava/util/Random;", "min", "max", "Companion", "afraidofthedark"})
public final class DarkForestStructureStart
extends StructureStart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MIN_PROPS = 35;
    private static final int MAX_PROPS = 75;
    private static final int MIN_TREES = 14;
    private static final int MAX_TREES = 20;

    public DarkForestStructureStart(@NotNull Structure<?> structure, int chunkX, int chunkZ, @NotNull Biome biomeIn, @NotNull MutableBoundingBox boundsIn, int referenceIn, long seed) {
        Intrinsics.checkNotNullParameter(structure, "structure");
        Intrinsics.checkNotNullParameter(biomeIn, "biomeIn");
        Intrinsics.checkNotNullParameter(boundsIn, "boundsIn");
        super(structure, chunkX, chunkZ, biomeIn, boundsIn, referenceIn, seed);
    }

    public void func_214625_a(@NotNull ChunkGenerator<?> generator, @NotNull TemplateManager templateManagerIn, int centerChunkX, int centerChunkZ, @NotNull Biome biomeIn) {
        int cornerHeight1;
        Intrinsics.checkNotNullParameter(generator, "generator");
        Intrinsics.checkNotNullParameter(templateManagerIn, "templateManagerIn");
        Intrinsics.checkNotNullParameter(biomeIn, "biomeIn");
        short bedHouseWidth = ModSchematics.INSTANCE.getBED_HOUSE().getWidth();
        short bedHouseLength = ModSchematics.INSTANCE.getBED_HOUSE().getLength();
        World world = ChunkGeneratorExtensionsKt.getWorld(generator);
        Structure structure = this.func_214627_k();
        if (structure == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.world.structure.base.AOTDStructure<*>");
        }
        AOTDStructure darkForest = (AOTDStructure)structure;
        int posX = this.func_143019_e() * 16;
        int posZ = this.func_143018_f() * 16;
        Integer n = SequencesKt.minOrNull(darkForest.getEdgeHeights$afraidofthedark(posX, posZ, generator, (IWorld)world, bedHouseWidth, bedHouseLength));
        Intrinsics.checkNotNull(n);
        int posY = n - 1;
        int width = darkForest.getWidth();
        int length = darkForest.getLength();
        int topGutterWidth = (length - bedHouseLength) / 2;
        int bottomGutterWidth = (length - bedHouseLength) / 2;
        int leftGutterWidth = (width - bedHouseWidth) / 2;
        int rightGutterWidth = (width - bedHouseWidth) / 2;
        int n2 = posX - bedHouseWidth / 2;
        int n3 = posZ - bedHouseLength / 2;
        SharedSeedRandom sharedSeedRandom = this.field_214631_d;
        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom, "rand");
        this.field_75075_a.add(new SchematicStructurePiece(n2, posY, n3, (Random)sharedSeedRandom, ModSchematics.INSTANCE.getBED_HOUSE(), ModLootTables.INSTANCE.getDARK_FOREST(), null, 64, null));
        SharedSeedRandom sharedSeedRandom2 = this.field_214631_d;
        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom2, "rand");
        int numProps = this.nextInt((Random)sharedSeedRandom2, 35, 75);
        int n4 = 0;
        if (n4 <= numProps) {
            int ignored;
            do {
                Pair<Integer, Integer> pair;
                ignored = n4++;
                Schematic propSchematic = ModSchematics.INSTANCE.getDARK_FOREST_PROPS()[this.field_214631_d.nextInt(ModSchematics.INSTANCE.getDARK_FOREST_PROPS().length)];
                short s = propSchematic.getWidth();
                short s2 = propSchematic.getHeight();
                boolean bl = false;
                int widthLengthMax = Math.max(s, s2);
                Direction gutter = Direction.Plane.HORIZONTAL.func_179518_a((Random)this.field_214631_d);
                Direction direction = gutter;
                int n5 = direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
                switch (n5) {
                    case 1: {
                        SharedSeedRandom sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "rand");
                        Integer n6 = posX + this.nextInt((Random)sharedSeedRandom3, -width / 2, width / 2 - widthLengthMax);
                        int n7 = posZ - bedHouseLength / 2;
                        sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "rand");
                        pair = new Pair<Integer, Integer>(n6, n7 - this.nextInt((Random)sharedSeedRandom3, widthLengthMax, topGutterWidth));
                        break;
                    }
                    case 2: {
                        SharedSeedRandom sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "rand");
                        Integer n8 = posX + this.nextInt((Random)sharedSeedRandom3, -width / 2, width / 2 - widthLengthMax);
                        int n9 = posZ + bedHouseLength / 2;
                        sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "rand");
                        pair = new Pair<Integer, Integer>(n8, n9 + this.nextInt((Random)sharedSeedRandom3, 0, bottomGutterWidth - widthLengthMax));
                        break;
                    }
                    case 3: {
                        int n10 = posX - bedHouseWidth / 2;
                        SharedSeedRandom sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "rand");
                        Integer n11 = n10 - this.nextInt((Random)sharedSeedRandom3, widthLengthMax, leftGutterWidth);
                        sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "rand");
                        pair = new Pair<Integer, Integer>(n11, posZ + this.nextInt((Random)sharedSeedRandom3, -length / 2, length / 2 - widthLengthMax));
                        break;
                    }
                    case 4: {
                        int n12 = posX + bedHouseWidth / 2;
                        SharedSeedRandom sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "rand");
                        Integer n13 = n12 + this.nextInt((Random)sharedSeedRandom3, 0, rightGutterWidth - widthLengthMax);
                        sharedSeedRandom3 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom3, "rand");
                        pair = new Pair<Integer, Integer>(n13, posZ + this.nextInt((Random)sharedSeedRandom3, -length / 2, length / 2 - widthLengthMax));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Got an invalid gutter " + gutter + ", should not be possible.");
                    }
                }
                Pair<Integer, Integer> pair2 = pair;
                int x = ((Number)pair2.component1()).intValue();
                int z = ((Number)pair2.component2()).intValue();
                SharedSeedRandom sharedSeedRandom4 = this.field_214631_d;
                Intrinsics.checkNotNullExpressionValue(sharedSeedRandom4, "rand");
                SchematicStructurePiece prop22 = new SchematicStructurePiece(x, 0, z, (Random)sharedSeedRandom4, propSchematic, null, null, 96, null);
                cornerHeight1 = WorldHeightmap.INSTANCE.getHeight(prop22.func_74874_b().field_78897_a, prop22.func_74874_b().field_78896_c, (IWorld)world, generator);
                int cornerHeight2 = WorldHeightmap.INSTANCE.getHeight(prop22.func_74874_b().field_78893_d, prop22.func_74874_b().field_78896_c, (IWorld)world, generator);
                int cornerHeight3 = WorldHeightmap.INSTANCE.getHeight(prop22.func_74874_b().field_78897_a, prop22.func_74874_b().field_78892_f, (IWorld)world, generator);
                int cornerHeight4 = WorldHeightmap.INSTANCE.getHeight(prop22.func_74874_b().field_78893_d, prop22.func_74874_b().field_78892_f, (IWorld)world, generator);
                int n14 = 0;
                n14 = Math.min(cornerHeight1, cornerHeight2);
                int n15 = 0;
                n15 = Math.min(cornerHeight3, cornerHeight4);
                boolean bl2 = false;
                prop22.updateY(Math.min(n14, n15));
                this.field_75075_a.add(prop22);
            } while (ignored != numProps);
        }
        SharedSeedRandom sharedSeedRandom5 = this.field_214631_d;
        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom5, "rand");
        int numTrees = this.nextInt((Random)sharedSeedRandom5, 14, 20);
        int n16 = 0;
        if (n16 <= numTrees) {
            int ignored;
            do {
                Pair<Integer, Integer> pair;
                ignored = n16++;
                Schematic treeSchematic = ModSchematics.INSTANCE.getDARK_FOREST_TREES()[this.field_214631_d.nextInt(ModSchematics.INSTANCE.getDARK_FOREST_TREES().length)];
                int approximateTrunkWidth = 4;
                short x = treeSchematic.getWidth();
                short s = treeSchematic.getHeight();
                boolean prop22 = false;
                int widthLengthMax = Math.max(x, s);
                Direction gutter = Direction.Plane.HORIZONTAL.func_179518_a((Random)this.field_214631_d);
                Direction prop22 = gutter;
                cornerHeight1 = prop22 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[prop22.ordinal()];
                switch (cornerHeight1) {
                    case 1: {
                        SharedSeedRandom cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "rand");
                        Integer n17 = posX + this.nextInt((Random)cornerHeight2, -width / 2, width / 2 - widthLengthMax);
                        int n18 = posZ - bedHouseLength / 2;
                        cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "rand");
                        pair = new Pair<Integer, Integer>(n17, n18 - this.nextInt((Random)cornerHeight2, approximateTrunkWidth + widthLengthMax / 2, bottomGutterWidth));
                        break;
                    }
                    case 2: {
                        SharedSeedRandom cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "rand");
                        Integer n19 = posX + this.nextInt((Random)cornerHeight2, -width / 2, width / 2 - widthLengthMax);
                        int n20 = posZ + bedHouseLength / 2;
                        cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "rand");
                        pair = new Pair<Integer, Integer>(n19, n20 + this.nextInt((Random)cornerHeight2, approximateTrunkWidth - widthLengthMax / 2, topGutterWidth - widthLengthMax));
                        break;
                    }
                    case 3: {
                        int n21 = posX - bedHouseWidth / 2;
                        SharedSeedRandom cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "rand");
                        Integer n22 = n21 - this.nextInt((Random)cornerHeight2, approximateTrunkWidth + widthLengthMax / 2, leftGutterWidth);
                        cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "rand");
                        pair = new Pair<Integer, Integer>(n22, posZ + this.nextInt((Random)cornerHeight2, -length / 2, length / 2 - widthLengthMax));
                        break;
                    }
                    case 4: {
                        int n23 = posX + bedHouseWidth / 2;
                        SharedSeedRandom cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "rand");
                        Integer n24 = n23 + this.nextInt((Random)cornerHeight2, approximateTrunkWidth - widthLengthMax / 2, rightGutterWidth - widthLengthMax);
                        cornerHeight2 = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(cornerHeight2, "rand");
                        pair = new Pair<Integer, Integer>(n24, posZ + this.nextInt((Random)cornerHeight2, -length / 2, length / 2 - widthLengthMax));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Got an invalid gutter " + gutter + ", should not be possible.");
                    }
                }
                Pair<Integer, Integer> pair3 = pair;
                int x2 = ((Number)pair3.component1()).intValue();
                int z = ((Number)pair3.component2()).intValue();
                SharedSeedRandom cornerHeight3 = this.field_214631_d;
                Intrinsics.checkNotNullExpressionValue(cornerHeight3, "rand");
                SchematicStructurePiece tree = new SchematicStructurePiece(x2, 0, z, (Random)cornerHeight3, treeSchematic, null, null, 96, null);
                int trunkHeight1 = WorldHeightmap.INSTANCE.getHeight(x2 + approximateTrunkWidth, z + approximateTrunkWidth, (IWorld)world, generator);
                int trunkHeight2 = WorldHeightmap.INSTANCE.getHeight(x2 + approximateTrunkWidth, z - approximateTrunkWidth, (IWorld)world, generator);
                int trunkHeight3 = WorldHeightmap.INSTANCE.getHeight(x2 - approximateTrunkWidth, z + approximateTrunkWidth, (IWorld)world, generator);
                int trunkHeight4 = WorldHeightmap.INSTANCE.getHeight(x2 - approximateTrunkWidth, z - approximateTrunkWidth, (IWorld)world, generator);
                int trunkHeightCenter = WorldHeightmap.INSTANCE.getHeight(x2, z, (IWorld)world, generator);
                int n25 = 0;
                n25 = Math.min(trunkHeight1, trunkHeight2);
                int n26 = 0;
                n26 = Math.min(trunkHeight3, trunkHeight4);
                boolean bl = false;
                n25 = Math.min(n25, n26);
                n26 = 0;
                tree.updateY(Math.min(n25, trunkHeightCenter) - 5);
                this.field_75075_a.add(tree);
            } while (ignored != numTrees);
        }
        this.func_202500_a();
    }

    private final int nextInt(Random $this$nextInt, int min, int max) {
        boolean bl = max > min;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return $this$nextInt.nextInt(max - min) + min;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/darkforest/DarkForestStructureStart$Companion;", "", "()V", "MAX_PROPS", "", "MAX_TREES", "MIN_PROPS", "MIN_TREES", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            nArray[Direction.NORTH.ordinal()] = 1;
            nArray[Direction.SOUTH.ordinal()] = 2;
            nArray[Direction.WEST.ordinal()] = 3;
            nArray[Direction.EAST.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

