/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.world.structure.gnomishcity;

import com.davidm1a2.afraidofthedark.common.constants.ModLootTables;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.world.WorldHeightmap;
import com.davidm1a2.afraidofthedark.common.world.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.world.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.world.structure.base.ChunkGeneratorExtensionsKt;
import com.davidm1a2.afraidofthedark.common.world.structure.base.SchematicStructurePiece;
import com.davidm1a2.afraidofthedark.common.world.structure.gnomishcity.GnomishCityStairwellClipperStructurePiece;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019BA\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ4\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/gnomishcity/GnomishCityStructureStart;", "Lnet/minecraft/world/gen/feature/structure/StructureStart;", "structure", "Lnet/minecraft/world/gen/feature/structure/Structure;", "chunkX", "", "chunkZ", "biomeIn", "Lnet/minecraft/world/biome/Biome;", "boundsIn", "Lnet/minecraft/util/math/MutableBoundingBox;", "referenceIn", "seed", "", "(Lnet/minecraft/world/gen/feature/structure/Structure;IILnet/minecraft/world/biome/Biome;Lnet/minecraft/util/math/MutableBoundingBox;IJ)V", "init", "", "generator", "Lnet/minecraft/world/gen/ChunkGenerator;", "templateManagerIn", "Lnet/minecraft/world/gen/feature/template/TemplateManager;", "centerChunkX", "centerChunkZ", "Companion", "EnariaFloorSettings", "Floor", "afraidofthedark"})
public final class GnomishCityStructureStart
extends StructureStart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ROOMS_PER_ROW = 3;

    public GnomishCityStructureStart(@NotNull Structure<?> structure, int chunkX, int chunkZ, @NotNull Biome biomeIn, @NotNull MutableBoundingBox boundsIn, int referenceIn, long seed) {
        Intrinsics.checkNotNullParameter(structure, "structure");
        Intrinsics.checkNotNullParameter(biomeIn, "biomeIn");
        Intrinsics.checkNotNullParameter(boundsIn, "boundsIn");
        super(structure, chunkX, chunkZ, biomeIn, boundsIn, referenceIn, seed);
    }

    /*
     * WARNING - void declaration
     */
    public void func_214625_a(@NotNull ChunkGenerator<?> generator, @NotNull TemplateManager templateManagerIn, int centerChunkX, int centerChunkZ, @NotNull Biome biomeIn) {
        int n;
        void $this$flatMapTo$iv$iv;
        SharedSeedRandom $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(generator, "generator");
        Intrinsics.checkNotNullParameter(templateManagerIn, "templateManagerIn");
        Intrinsics.checkNotNullParameter(biomeIn, "biomeIn");
        Structure structure = this.func_214627_k();
        if (structure == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.world.structure.base.AOTDStructure<*>");
        }
        AOTDStructure gnomishCity = (AOTDStructure)structure;
        int width = gnomishCity.getWidth();
        int length = gnomishCity.getLength();
        int cornerPosX = this.func_143019_e() * 16 - width / 2;
        int cornerPosY = 5;
        int cornerPosZ = this.func_143018_f() * 16 - length / 2;
        World world = ChunkGeneratorExtensionsKt.getWorld(generator);
        int stairSurfaceTo1 = this.field_214631_d.nextInt(9);
        Integer[] integerArray = new Integer[]{1, 3, 5, 7};
        int stairs2ToEnaria = ((Number)CollectionsKt.listOf(integerArray).get(this.field_214631_d.nextInt(4))).intValue();
        int stairs1To2 = 0;
        while (stairSurfaceTo1 == (stairs1To2 = this.field_214631_d.nextInt(9)) || stairs2ToEnaria == stairs1To2) {
        }
        Direction stairs1To2Facing = Direction.Plane.HORIZONTAL.func_179518_a((Random)this.field_214631_d);
        Schematic[] schematicArray = ModSchematics.INSTANCE.getGNOMISH_CITY_ROOMS();
        boolean $i$f$flatMap = false;
        void var20_23 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var23_30 = $this$flatMapTo$iv$iv;
        int n2 = ((void)var23_30).length;
        for (n = 0; n < n2; ++n) {
            void element$iv$iv;
            void it = element$iv$iv = var23_30[n];
            boolean bl = false;
            Schematic[] schematicArray2 = new Schematic[]{it, it};
            Iterable list$iv$iv = CollectionsKt.listOf(schematicArray2);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable iterable = (List)destination$iv$iv;
        $this$flatMap$iv = this.field_214631_d;
        Intrinsics.checkNotNullExpressionValue($this$flatMap$iv, "rand");
        Iterator rooms = CollectionsKt.shuffled(iterable, (Random)$this$flatMap$iv).iterator();
        int amountOfStairRemoved = 0;
        Floor[] floorArray = Floor.values();
        int n3 = 0;
        int n4 = floorArray.length;
        while (n3 < n4) {
            Floor floor = floorArray[n3];
            ++n3;
            int n5 = 0;
            do {
                int xIndex = n5++;
                n = 0;
                do {
                    int n6;
                    int n7;
                    Direction facing;
                    int zIndex = n++;
                    int currentRoom = xIndex + zIndex * 3;
                    int roomPosX = cornerPosX + xIndex * 50;
                    int roomPosY = cornerPosY + floor.ordinal() * 15 + 15;
                    int roomPosZ = cornerPosZ + zIndex * 50;
                    if (currentRoom == stairSurfaceTo1 && floor == Floor.UPPER) {
                        facing = Direction.Plane.HORIZONTAL.func_179518_a((Random)this.field_214631_d);
                        SharedSeedRandom sharedSeedRandom = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom, "rand");
                        this.field_75075_a.add(new SchematicStructurePiece(roomPosX, roomPosY, roomPosZ, (Random)sharedSeedRandom, ModSchematics.INSTANCE.getROOM_STAIR_UP(), ModLootTables.INSTANCE.getGNOMISH_CITY(), facing));
                        int stairwellX = roomPosX + 13;
                        int stairwellY = roomPosY + 15;
                        int stairwellZ = roomPosZ + 13;
                        Schematic stairwell = ModSchematics.INSTANCE.getSTAIRWELL();
                        SharedSeedRandom sharedSeedRandom2 = new SharedSeedRandom[]{Integer.valueOf(WorldHeightmap.INSTANCE.getHeight(stairwellX, stairwellZ, (IWorld)world, generator)), Integer.valueOf(WorldHeightmap.INSTANCE.getHeight(stairwellX + stairwell.getWidth() - 1, stairwellZ, (IWorld)world, generator)), Integer.valueOf(WorldHeightmap.INSTANCE.getHeight(stairwellX, stairwellZ + stairwell.getLength() - 1, (IWorld)world, generator)), Integer.valueOf(WorldHeightmap.INSTANCE.getHeight(stairwellX + stairwell.getWidth() - 1, stairwellZ + stairwell.getLength() - 1, (IWorld)world, generator)), Integer.valueOf(WorldHeightmap.INSTANCE.getHeight(stairwellX + stairwell.getWidth() / 2, stairwellZ + stairwell.getLength() / 2, (IWorld)world, generator))};
                        Integer n8 = (Integer)CollectionsKt.maxOrNull((Iterable)CollectionsKt.listOf(sharedSeedRandom2));
                        Intrinsics.checkNotNull(n8);
                        int groundHeight = n8;
                        int stairwellTop = stairwellY;
                        while (true) {
                            n7 = 220;
                            n6 = 0;
                            if (stairwellTop >= Math.min(n7, groundHeight)) break;
                            sharedSeedRandom2 = this.field_214631_d;
                            Intrinsics.checkNotNullExpressionValue(sharedSeedRandom2, "rand");
                            this.field_75075_a.add(new SchematicStructurePiece(stairwellX, stairwellTop, stairwellZ, (Random)sharedSeedRandom2, stairwell, null, facing, 32, null));
                            stairwellTop = stairwellTop + stairwell.getHeight() - 1;
                        }
                        this.field_75075_a.add(new GnomishCityStairwellClipperStructurePiece(stairwellX, groundHeight, stairwellTop, stairwellZ));
                        amountOfStairRemoved = stairwellTop - groundHeight;
                        continue;
                    }
                    if (currentRoom == stairs1To2 && floor == Floor.UPPER) {
                        facing = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(facing, "rand");
                        this.field_75075_a.add(new SchematicStructurePiece(roomPosX, roomPosY, roomPosZ, (Random)facing, ModSchematics.INSTANCE.getROOM_STAIR_DOWN(), ModLootTables.INSTANCE.getGNOMISH_CITY(), stairs1To2Facing));
                        continue;
                    }
                    if (currentRoom == stairs1To2 && floor == Floor.LOWER) {
                        facing = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue(facing, "rand");
                        this.field_75075_a.add(new SchematicStructurePiece(roomPosX, roomPosY, roomPosZ, (Random)facing, ModSchematics.INSTANCE.getROOM_STAIR_UP(), ModLootTables.INSTANCE.getGNOMISH_CITY(), stairs1To2Facing));
                        continue;
                    }
                    if (currentRoom == stairs2ToEnaria && floor == Floor.LOWER) {
                        EnariaFloorSettings enariaFloorSettings;
                        block16: {
                            EnariaFloorSettings enariaFloorSettings2;
                            EnariaFloorSettings[] enariaFloorSettingsArray = EnariaFloorSettings.values();
                            boolean bl = false;
                            EnariaFloorSettings[] enariaFloorSettingsArray2 = enariaFloorSettingsArray;
                            boolean bl2 = false;
                            EnariaFloorSettings[] enariaFloorSettingsArray3 = enariaFloorSettingsArray2;
                            n7 = enariaFloorSettingsArray3.length;
                            for (n6 = 0; n6 < n7; ++n6) {
                                EnariaFloorSettings enariaFloorSettings3;
                                EnariaFloorSettings it = enariaFloorSettings3 = enariaFloorSettingsArray3[n6];
                                boolean bl3 = false;
                                if (!(it.getRoomId() == currentRoom)) continue;
                                enariaFloorSettings2 = enariaFloorSettings3;
                                break block16;
                            }
                            enariaFloorSettings2 = enariaFloorSettings = null;
                        }
                        if (enariaFloorSettings == null) {
                            throw new IllegalArgumentException(Intrinsics.stringPlus("Enaria floor settings can't be determined for room ", currentRoom));
                        }
                        EnariaFloorSettings enariaFloorSettings4 = enariaFloorSettings;
                        enariaFloorSettings = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue((Object)enariaFloorSettings, "rand");
                        this.field_75075_a.add(new SchematicStructurePiece(roomPosX, roomPosY, roomPosZ, (Random)((Object)enariaFloorSettings), ModSchematics.INSTANCE.getROOM_STAIR_DOWN(), ModLootTables.INSTANCE.getGNOMISH_CITY(), enariaFloorSettings4.getFacing()));
                        int n9 = cornerPosX + xIndex * 50 + enariaFloorSettings4.getXOffset();
                        int n10 = cornerPosY + floor.ordinal() * 15;
                        int n11 = cornerPosZ + zIndex * 50 + enariaFloorSettings4.getZOffset();
                        enariaFloorSettings = this.field_214631_d;
                        Intrinsics.checkNotNullExpressionValue((Object)enariaFloorSettings, "rand");
                        this.field_75075_a.add(new SchematicStructurePiece(n9, n10, n11, (Random)((Object)enariaFloorSettings), ModSchematics.INSTANCE.getENARIA_LAIR(), null, enariaFloorSettings4.getFacing(), 32, null));
                        continue;
                    }
                    SharedSeedRandom sharedSeedRandom = this.field_214631_d;
                    Intrinsics.checkNotNullExpressionValue(sharedSeedRandom, "rand");
                    this.field_75075_a.add(new SchematicStructurePiece(roomPosX, roomPosY, roomPosZ, (Random)sharedSeedRandom, (Schematic)rooms.next(), ModLootTables.INSTANCE.getGNOMISH_CITY(), null, 64, null));
                } while (n < 3);
            } while (n5 < 3);
        }
        floorArray = Floor.values();
        n3 = 0;
        n4 = floorArray.length;
        while (n3 < n4) {
            Floor floor = floorArray[n3];
            ++n3;
            int n12 = 0;
            do {
                int i = n12++;
                n = 0;
                do {
                    int j = n++;
                    int n13 = cornerPosY + floor.ordinal() * 15 + 15 + 7;
                    SharedSeedRandom sharedSeedRandom = this.field_214631_d;
                    Intrinsics.checkNotNullExpressionValue(sharedSeedRandom, "rand");
                    this.field_75075_a.add(new SchematicStructurePiece(cornerPosX + i * 50 + 13, n13, cornerPosZ + j * 50 + 32, (Random)sharedSeedRandom, ModSchematics.INSTANCE.getCONNECTOR(), null, Direction.EAST, 32, null));
                    int n14 = cornerPosY + floor.ordinal() * 15 + 15 + 7;
                    sharedSeedRandom = this.field_214631_d;
                    Intrinsics.checkNotNullExpressionValue(sharedSeedRandom, "rand");
                    this.field_75075_a.add(new SchematicStructurePiece(cornerPosX + j * 50 + 32, n14, cornerPosZ + i * 50 + 13, (Random)sharedSeedRandom, ModSchematics.INSTANCE.getCONNECTOR(), null, Direction.NORTH, 32, null));
                } while (n <= 1);
            } while (n12 < 3);
        }
        this.func_202500_a();
        this.func_75071_a().field_78894_e -= amountOfStairRemoved;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/gnomishcity/GnomishCityStructureStart$Floor;", "", "(Ljava/lang/String;I)V", "LOWER", "UPPER", "afraidofthedark"})
    private static final class Floor
    extends Enum<Floor> {
        public static final /* enum */ Floor LOWER = new Floor();
        public static final /* enum */ Floor UPPER = new Floor();
        private static final /* synthetic */ Floor[] $VALUES;

        public static Floor[] values() {
            Floor[] floorArray = $VALUES;
            return Arrays.copyOf(floorArray, floorArray.length);
        }

        public static Floor valueOf(String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return Enum.valueOf(Floor.class, value);
        }

        static {
            $VALUES = floorArray = new Floor[]{Floor.LOWER, Floor.UPPER};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/gnomishcity/GnomishCityStructureStart$EnariaFloorSettings;", "", "roomId", "", "facing", "Lnet/minecraft/util/Direction;", "xOffset", "zOffset", "(Ljava/lang/String;IILnet/minecraft/util/Direction;II)V", "getFacing", "()Lnet/minecraft/util/Direction;", "getRoomId", "()I", "getXOffset", "getZOffset", "NORTH", "SOUTH", "EAST", "WEST", "afraidofthedark"})
    private static final class EnariaFloorSettings
    extends Enum<EnariaFloorSettings> {
        private final int roomId;
        @NotNull
        private final Direction facing;
        private final int xOffset;
        private final int zOffset;
        public static final /* enum */ EnariaFloorSettings NORTH = new EnariaFloorSettings(7, Direction.NORTH, -14, -73);
        public static final /* enum */ EnariaFloorSettings SOUTH = new EnariaFloorSettings(1, Direction.SOUTH, -14, 12);
        public static final /* enum */ EnariaFloorSettings EAST = new EnariaFloorSettings(3, Direction.EAST, 12, -14);
        public static final /* enum */ EnariaFloorSettings WEST = new EnariaFloorSettings(5, Direction.WEST, -73, -14);
        private static final /* synthetic */ EnariaFloorSettings[] $VALUES;

        private EnariaFloorSettings(int roomId, Direction facing, int xOffset, int zOffset) {
            this.roomId = roomId;
            this.facing = facing;
            this.xOffset = xOffset;
            this.zOffset = zOffset;
        }

        public final int getRoomId() {
            return this.roomId;
        }

        @NotNull
        public final Direction getFacing() {
            return this.facing;
        }

        public final int getXOffset() {
            return this.xOffset;
        }

        public final int getZOffset() {
            return this.zOffset;
        }

        public static EnariaFloorSettings[] values() {
            EnariaFloorSettings[] enariaFloorSettingsArray = $VALUES;
            return Arrays.copyOf(enariaFloorSettingsArray, enariaFloorSettingsArray.length);
        }

        public static EnariaFloorSettings valueOf(String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return Enum.valueOf(EnariaFloorSettings.class, value);
        }

        static {
            $VALUES = enariaFloorSettingsArray = new EnariaFloorSettings[]{EnariaFloorSettings.NORTH, EnariaFloorSettings.SOUTH, EnariaFloorSettings.EAST, EnariaFloorSettings.WEST};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/gnomishcity/GnomishCityStructureStart$Companion;", "", "()V", "ROOMS_PER_ROW", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

