/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.world.structure.witchhut;

import com.davidm1a2.afraidofthedark.common.constants.ModBiomes;
import com.davidm1a2.afraidofthedark.common.constants.ModCommonConfiguration;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.world.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.world.structure.base.MultiplierConfig;
import com.davidm1a2.afraidofthedark.common.world.structure.witchhut.WitchHutStructure;
import com.davidm1a2.afraidofthedark.common.world.structure.witchhut.WitchHutStructureStart;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/witchhut/WitchHutStructure;", "Lcom/davidm1a2/afraidofthedark/common/world/structure/base/AOTDStructure;", "Lcom/davidm1a2/afraidofthedark/common/world/structure/base/MultiplierConfig;", "()V", "getLength", "", "getStartFactory", "Lnet/minecraft/world/gen/feature/structure/Structure$IStartFactory;", "getStructureName", "", "getWidth", "hasStartAt", "", "worldIn", "Lnet/minecraft/world/World;", "chunkGen", "Lnet/minecraft/world/gen/ChunkGenerator;", "random", "Ljava/util/Random;", "missCount", "xPos", "zPos", "setupStructureIn", "", "biome", "Lnet/minecraft/world/biome/Biome;", "Companion", "afraidofthedark"})
public final class WitchHutStructure
extends AOTDStructure<MultiplierConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double CHANCE_QUARTIC_COEFFICIENT = 0.001;

    public WitchHutStructure() {
        super(1.INSTANCE, false, 2, null);
    }

    @Override
    @NotNull
    public String func_143025_a() {
        return "afraidofthedark:witch_hut";
    }

    @Override
    public int getWidth() {
        return ModSchematics.INSTANCE.getWITCH_HUT().getWidth();
    }

    @Override
    public int getLength() {
        return ModSchematics.INSTANCE.getWITCH_HUT().getLength();
    }

    @Override
    public void setupStructureIn(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter(biome, "biome");
        if (Intrinsics.areEqual(biome, (Object)ModBiomes.INSTANCE.getEERIE_FOREST())) {
            this.addToBiome(biome, (IFeatureConfig)new MultiplierConfig(1));
        } else {
            this.addToBiome(biome, (IFeatureConfig)new MultiplierConfig(0));
        }
    }

    @NotNull
    public Structure.IStartFactory func_214557_a() {
        return WitchHutStructure::getStartFactory$lambda-0;
    }

    @Override
    public boolean hasStartAt(@NotNull World worldIn, @NotNull ChunkGenerator<?> chunkGen, @NotNull Random random, int missCount, int xPos, int zPos) {
        Intrinsics.checkNotNullParameter(worldIn, "worldIn");
        Intrinsics.checkNotNullParameter(chunkGen, "chunkGen");
        Intrinsics.checkNotNullParameter(random, "random");
        Integer n = (Integer)SequencesKt.minOrNull(SequencesKt.map(AOTDStructure.getInteriorConfigEstimate$default(this, xPos, zPos, chunkGen, 0, 0, 24, null), hasStartAt.biomeMultiplier.1.INSTANCE));
        int biomeMultiplier2 = n == null ? 0 : n;
        double chance = ModCommonConfiguration.INSTANCE.getWitchHutMultiplier() * (double)biomeMultiplier2 * this.powOptimized(0.001 * (double)missCount, 4);
        if (random.nextDouble() >= chance) {
            return false;
        }
        Sequence heights = AOTDStructure.getEdgeHeights$afraidofthedark$default(this, xPos, zPos, chunkGen, (IWorld)worldIn, 0, 0, 48, null);
        Integer n2 = (Integer)SequencesKt.maxOrNull(heights);
        Intrinsics.checkNotNull(n2);
        int maxHeight = n2;
        Integer n3 = (Integer)SequencesKt.minOrNull(heights);
        Intrinsics.checkNotNull(n3);
        int minHeight = n3;
        return maxHeight - minHeight <= 3;
    }

    private static final StructureStart getStartFactory$lambda-0(Structure structure, int chunkX, int chunkZ, Biome biome, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
        Intrinsics.checkNotNullExpressionValue(structure, "structure");
        Intrinsics.checkNotNullExpressionValue(biome, "biome");
        Intrinsics.checkNotNullExpressionValue(mutableBoundingBox, "mutableBoundingBox");
        return new WitchHutStructureStart(structure, chunkX, chunkZ, biome, mutableBoundingBox, reference, seed);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/structure/witchhut/WitchHutStructure$Companion;", "", "()V", "CHANCE_QUARTIC_COEFFICIENT", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

