/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.world.tree.feature;

import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J6\u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J6\u0010\u0013\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J6\u0010\u0015\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/tree/feature/MangroveTreeFeature;", "Lnet/minecraft/world/gen/feature/TreeFeature;", "notify", "", "(Z)V", "generateBase", "Lnet/minecraft/util/math/BlockPos;", "changedBlocks", "", "world", "Lnet/minecraft/world/gen/IWorldGenerationReader;", "pos", "random", "Ljava/util/Random;", "boundingBox", "Lnet/minecraft/util/math/MutableBoundingBox;", "generateBranches", "", "topOfTrunk", "generateLeafCluster", "location", "place", "Companion", "afraidofthedark"})
public final class MangroveTreeFeature
extends TreeFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final BlockState MANGROVE_LOG_UP = (BlockState)ModBlocks.INSTANCE.getMANGROVE().func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Y);
    private static final BlockState MANGROVE_LEAVES = ModBlocks.INSTANCE.getMANGROVE_LEAVES().func_176223_P();

    public MangroveTreeFeature(boolean notify) {
        super(MangroveTreeFeature::_init_$lambda-0, notify);
    }

    public boolean func_208519_a(@NotNull Set<BlockPos> changedBlocks, @NotNull IWorldGenerationReader world, @NotNull Random random, @NotNull BlockPos pos, @NotNull MutableBoundingBox boundingBox) {
        Intrinsics.checkNotNullParameter(changedBlocks, "changedBlocks");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(random, "random");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(boundingBox, "boundingBox");
        BlockPos topOfTrunk = this.generateBase(changedBlocks, world, pos, random, boundingBox);
        this.generateBranches(changedBlocks, world, topOfTrunk, random, boundingBox);
        return true;
    }

    private final BlockPos generateBase(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos pos, Random random, MutableBoundingBox boundingBox) {
        int heightBeforeTrunk = random.nextInt(4) + 4;
        int n = 0;
        int numRoots = random.nextInt(5) + 4;
        if (n < numRoots) {
            do {
                int i = n++;
                Direction xOffsetDirection = random.nextBoolean() ? Direction.NORTH : Direction.SOUTH;
                Direction zOffsetDirection = random.nextBoolean() ? Direction.EAST : Direction.WEST;
                int xDistanceFromTrunk = random.nextInt(3) + 3;
                int zDistanceFromTrunk = random.nextInt(3) + 3;
                BlockPos currentPos = pos.func_177967_a(xOffsetDirection, xDistanceFromTrunk).func_177967_a(zOffsetDirection, zDistanceFromTrunk);
                int n2 = 0;
                if (n2 < heightBeforeTrunk) {
                    do {
                        int n3;
                        int j = n2++;
                        if (xDistanceFromTrunk != 0 && random.nextBoolean()) {
                            currentPos = currentPos.func_177972_a(xOffsetDirection.func_176734_d());
                            n3 = xDistanceFromTrunk;
                            xDistanceFromTrunk = n3 + -1;
                        }
                        if (zDistanceFromTrunk != 0 && random.nextBoolean()) {
                            currentPos = currentPos.func_177972_a(zOffsetDirection.func_176734_d());
                            n3 = zDistanceFromTrunk;
                            zDistanceFromTrunk = n3 + -1;
                        }
                        this.func_208520_a(changedBlocks, (IWorldWriter)world, currentPos, MANGROVE_LOG_UP, boundingBox);
                        if (random.nextDouble() < 0.1) {
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, random.nextBoolean() ? currentPos.func_177984_a() : currentPos.func_177977_b(), MANGROVE_LOG_UP, boundingBox);
                        }
                        currentPos = currentPos.func_177984_a();
                    } while (n2 < heightBeforeTrunk);
                }
                while (xDistanceFromTrunk > 0 || zDistanceFromTrunk > 0) {
                    if (xDistanceFromTrunk != 0) {
                        currentPos = currentPos.func_177972_a(xOffsetDirection.func_176734_d());
                        n2 = xDistanceFromTrunk;
                        xDistanceFromTrunk = n2 + -1;
                    }
                    if (zDistanceFromTrunk != 0) {
                        currentPos = currentPos.func_177972_a(zOffsetDirection.func_176734_d());
                        n2 = zDistanceFromTrunk;
                        zDistanceFromTrunk = n2 + -1;
                    }
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, currentPos, MANGROVE_LOG_UP, boundingBox);
                }
            } while (n < numRoots);
        }
        int trunkHeight = random.nextInt(4) + 6;
        BlockPos currentPos = pos.func_177981_b(heightBeforeTrunk);
        int n4 = 0;
        if (n4 < trunkHeight) {
            do {
                int i = n4++;
                if (random.nextDouble() < 0.1) {
                    currentPos = currentPos.func_177972_a(Direction.func_176731_b((int)random.nextInt(4)));
                }
                this.func_208520_a(changedBlocks, (IWorldWriter)world, currentPos, MANGROVE_LOG_UP, boundingBox);
                currentPos = currentPos.func_177984_a();
            } while (n4 < trunkHeight);
        }
        BlockPos blockPos = currentPos;
        Intrinsics.checkNotNullExpressionValue(blockPos, "currentPos");
        return blockPos;
    }

    private final void generateBranches(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos topOfTrunk, Random random, MutableBoundingBox boundingBox) {
        this.generateLeafCluster(changedBlocks, world, topOfTrunk, random, boundingBox);
        int numBranches = random.nextInt(3) + 3;
        int n = 0;
        if (n < numBranches) {
            do {
                int i = n++;
                Direction branchDir1 = Direction.func_176731_b((int)random.nextInt(4));
                Direction branchDir2 = random.nextBoolean() ? branchDir1.func_176746_e() : branchDir1.func_176735_f();
                int branchLength = random.nextInt(5) + 3;
                BlockPos currentBranchPos = topOfTrunk.func_177972_a(random.nextBoolean() ? branchDir1 : branchDir2);
                int n2 = 0;
                if (n2 < branchLength) {
                    do {
                        int j = n2++;
                        this.func_208520_a(changedBlocks, (IWorldWriter)world, currentBranchPos, MANGROVE_LOG_UP, boundingBox);
                        if (random.nextDouble() < 0.1) {
                            BlockPos blockPos = currentBranchPos;
                            Intrinsics.checkNotNullExpressionValue(blockPos, "currentBranchPos");
                            this.generateLeafCluster(changedBlocks, world, blockPos, random, boundingBox);
                        }
                        currentBranchPos = currentBranchPos.func_177972_a(random.nextBoolean() ? branchDir1 : branchDir2);
                        if (!(random.nextDouble() < 0.2)) continue;
                        currentBranchPos = currentBranchPos.func_177984_a();
                    } while (n2 < branchLength);
                }
                BlockPos blockPos = currentBranchPos;
                Intrinsics.checkNotNullExpressionValue(blockPos, "currentBranchPos");
                this.generateLeafCluster(changedBlocks, world, blockPos, random, boundingBox);
            } while (n < numBranches);
        }
    }

    private final void generateLeafCluster(Set<BlockPos> changedBlocks, IWorldGenerationReader world, BlockPos location, Random random, MutableBoundingBox boundingBox) {
        this.func_208520_a(changedBlocks, (IWorldWriter)world, location, MANGROVE_LOG_UP, boundingBox);
        int n = -2;
        do {
            int x = n++;
            int n2 = -1;
            do {
                int y = n2++;
                int n3 = -2;
                do {
                    int z = n3++;
                    BlockPos leafPos = location.func_177982_a(x, y, z);
                    double d = leafPos.func_177951_i((Vec3i)location);
                    boolean bl = false;
                    double d2 = Math.sqrt(d);
                    double d3 = y == 0 ? 2.5 : 2.0;
                    if (!(d2 < d3) || !(random.nextDouble() < 0.9)) continue;
                    if (random.nextDouble() < 0.03) {
                        int i;
                        this.func_208520_a(changedBlocks, (IWorldWriter)world, leafPos, MANGROVE_LOG_UP, boundingBox);
                        int vineLength = random.nextInt(3) + 2;
                        int n4 = 1;
                        if (n4 > vineLength) continue;
                        do {
                            i = n4++;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, leafPos.func_177979_c(i), MANGROVE_LEAVES, boundingBox);
                        } while (i != vineLength);
                        continue;
                    }
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, leafPos, MANGROVE_LEAVES, boundingBox);
                } while (n3 <= 2);
            } while (n2 <= 1);
        } while (n <= 2);
    }

    private static final NoFeatureConfig _init_$lambda-0(Dynamic it) {
        return NoFeatureConfig.field_202429_e;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/davidm1a2/afraidofthedark/common/world/tree/feature/MangroveTreeFeature$Companion;", "", "()V", "MANGROVE_LEAVES", "Lnet/minecraft/block/BlockState;", "kotlin.jvm.PlatformType", "MANGROVE_LOG_UP", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

