/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.customControls;

import com.davidm1a2.afraidofthedark.client.gui.customControls.SpellListItem;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseEvent;
import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.layout.Gravity;
import com.davidm1a2.afraidofthedark.client.gui.layout.Position;
import com.davidm1a2.afraidofthedark.client.gui.layout.Spacing;
import com.davidm1a2.afraidofthedark.client.gui.layout.TextAlignment;
import com.davidm1a2.afraidofthedark.client.gui.screens.SpellCraftingScreen;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDGuiComponent;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ButtonPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ImagePane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.LabelComponent;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.StackPane;
import com.davidm1a2.afraidofthedark.client.settings.ClientData;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\tJ\u0014\u0010\u0010\u001a\u00020\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u0011\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/customControls/SpellListItem;", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/StackPane;", "prefSize", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "(Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;Lcom/davidm1a2/afraidofthedark/common/spell/Spell;)V", "deleteCallback", "Lkotlin/Function0;", "", "keybindCallback", "lblKeybind", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/LabelComponent;", "getSpell", "()Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "refreshLabels", "setDeleteCallback", "setKeybindCallback", "afraidofthedark"})
public final class SpellListItem
extends StackPane {
    @NotNull
    private final Spell spell;
    @NotNull
    private final LabelComponent lblKeybind;
    @NotNull
    private Function0<Unit> keybindCallback;
    @NotNull
    private Function0<Unit> deleteCallback;

    public SpellListItem(@NotNull Dimensions prefSize, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(prefSize, "prefSize");
        Intrinsics.checkNotNullParameter(spell, "spell");
        super(prefSize, null, new Spacing(0.0, 0.0, 0.0, 0.0, false, 16, null), null, null, null, false, 122, null);
        this.spell = spell;
        this.keybindCallback = keybindCallback.1.INSTANCE;
        this.deleteCallback = deleteCallback.1.INSTANCE;
        ImagePane background = new ImagePane("afraidofthedark:textures/gui/spell_list/spell_background.png", ImagePane.DispMode.STRETCH);
        this.add(background);
        StackPane spellNameContainer = new StackPane(new Dimensions(0.8, 0.5, false, 4, null), null, null, null, null, null, false, 126, null);
        LabelComponent lblSpellName = new LabelComponent(ClientData.INSTANCE.getOrCreate(36.0f), new Dimensions(1.0, 1.0, false, 4, null), null, 4, null);
        lblSpellName.setText(this.spell.getName());
        lblSpellName.setTextColor(new Color(245, 61, 199));
        lblSpellName.setTextAlignment(TextAlignment.ALIGN_CENTER);
        spellNameContainer.setHoverText(lblSpellName.getText());
        spellNameContainer.setGravity(Gravity.TOP_CENTER);
        spellNameContainer.add(lblSpellName);
        this.add(spellNameContainer);
        ButtonPane btnEdit = new ButtonPane(new ImagePane("afraidofthedark:textures/gui/spell_list/spell_edit.png", null, 2, null), new ImagePane("afraidofthedark:textures/gui/spell_list/spell_edit_hovered.png", null, 2, null), false, null, null, null, null, new Dimensions(0.145, 0.35, false, 4, null), new Position(0.82, 0.52, false, 4, null), null, 636, null);
        btnEdit.setHoverText("Edit Spell");
        btnEdit.addMouseListener((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == MouseEvent.EventType.Click && it.getSource().isHovered() && it.getClickedButton() == 0) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new SpellCraftingScreen(this.getSpell()));
                }
            }
        });
        this.add(btnEdit);
        ButtonPane btnDelete = new ButtonPane(new ImagePane("afraidofthedark:textures/gui/spell_list/spell_delete.png", null, 2, null), new ImagePane("afraidofthedark:textures/gui/spell_list/spell_delete_hovered.png", null, 2, null), false, null, null, null, null, new Dimensions(0.145, 0.35, false, 4, null), new Position(0.035, 0.52, false, 4, null), null, 636, null);
        String[] stringArray = new String[]{"Delete Spell", "This cannot be undone"};
        btnDelete.setHoverTexts(stringArray);
        btnDelete.addMouseListener((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == MouseEvent.EventType.Click && it.getSource().isHovered() && it.getSource().isVisible() && it.getClickedButton() == 0) {
                    it.consume();
                    deleteCallback.invoke();
                }
            }
        });
        this.add(btnDelete);
        this.lblKeybind = new LabelComponent(ClientData.INSTANCE.getOrCreate(30.0f), new Dimensions(0.6, 0.3, false, 4, null), null, 4, null);
        this.lblKeybind.setTextAlignment(TextAlignment.ALIGN_CENTER);
        this.lblKeybind.setOffset(new Position(0.2, 0.5, false, 4, null));
        this.lblKeybind.addMouseListener((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == MouseEvent.EventType.Click && it.getSource().isHovered() && it.getSource().isVisible() && it.getClickedButton() == 0) {
                    lblKeybind.setHoverText("Awaiting keypress...");
                    lblKeybind.setText("Awaiting keypress...");
                    keybindCallback.invoke();
                }
            }
        });
        this.add(this.lblKeybind);
        this.refreshLabels();
    }

    @NotNull
    public final Spell getSpell() {
        return this.spell;
    }

    public final void refreshLabels() {
        IPlayerSpellManager spellManager = CapabilityExtensionsKt.getSpellManager((PlayerEntity)AOTDGuiComponent.Companion.getEntityPlayer());
        String keybindingForSpell = spellManager.getKeybindingForSpell(this.spell);
        if (keybindingForSpell != null) {
            this.lblKeybind.setHoverText(Intrinsics.stringPlus("Spell is bound to: ", keybindingForSpell));
            this.lblKeybind.setText(keybindingForSpell);
        } else {
            this.lblKeybind.setHoverText("Spell is unbound.");
            this.lblKeybind.setText("");
        }
    }

    public final void setKeybindCallback(@NotNull Function0<Unit> keybindCallback2) {
        Intrinsics.checkNotNullParameter(keybindCallback2, "keybindCallback");
        this.keybindCallback = keybindCallback2;
    }

    public final void setDeleteCallback(@NotNull Function0<Unit> deleteCallback2) {
        Intrinsics.checkNotNullParameter(deleteCallback2, "deleteCallback");
        this.deleteCallback = deleteCallback2;
    }
}

