/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.capabilities.player.spell;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.network.packets.capabilityPackets.ClearSpellsPacket;
import com.davidm1a2.afraidofthedark.common.network.packets.capabilityPackets.SpellPacket;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/player/spell/PlayerSpellManager;", "Lcom/davidm1a2/afraidofthedark/common/capabilities/player/spell/IPlayerSpellManager;", "()V", "keybindToSpellId", "Lcom/google/common/collect/BiMap;", "", "Ljava/util/UUID;", "spellIdToSpell", "", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "addOrUpdateSpell", "", "spell", "clearSpells", "deleteSpell", "getKeybindingForSpell", "getSpellById", "spellId", "getSpellForKeybinding", "key", "getSpells", "", "isServerSide", "", "entityPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "keybindExists", "keybindSpell", "sync", "syncAll", "unbindSpell", "Companion", "afraidofthedark"})
public final class PlayerSpellManager
implements IPlayerSpellManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BiMap<String, UUID> keybindToSpellId;
    @NotNull
    private final Map<UUID, Spell> spellIdToSpell;
    private static final Logger logger = LogManager.getLogger();

    public PlayerSpellManager() {
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue(hashBiMap, "create()");
        this.keybindToSpellId = (BiMap)hashBiMap;
        boolean bl = false;
        this.spellIdToSpell = new LinkedHashMap();
    }

    @Override
    public void addOrUpdateSpell(@NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(spell, "spell");
        Map<UUID, Spell> map = this.spellIdToSpell;
        UUID uUID = spell.getId();
        boolean bl = false;
        map.put(uUID, spell);
    }

    @Override
    public void deleteSpell(@NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(spell, "spell");
        this.spellIdToSpell.remove(spell.getId());
        this.keybindToSpellId.inverse().remove((Object)spell.getId());
    }

    @Override
    public void clearSpells() {
        this.spellIdToSpell.clear();
        this.keybindToSpellId.clear();
    }

    @Override
    @NotNull
    public List<Spell> getSpells() {
        return CollectionsKt.toList((Iterable)this.spellIdToSpell.values());
    }

    @Override
    public void keybindSpell(@NotNull String key, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(spell, "spell");
        if (this.spellIdToSpell.containsKey(spell.getId())) {
            this.keybindToSpellId.forcePut((Object)key, (Object)spell.getId());
        } else {
            logger.error("Cannot bind a spell that isn't registered!");
        }
    }

    @Override
    public void unbindSpell(@NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(spell, "spell");
        this.keybindToSpellId.inverse().remove((Object)spell.getId());
    }

    @Override
    public boolean keybindExists(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.keybindToSpellId.containsKey((Object)key);
    }

    @Override
    @Nullable
    public String getKeybindingForSpell(@NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(spell, "spell");
        return (String)this.keybindToSpellId.inverse().getOrDefault((Object)spell.getId(), null);
    }

    @Override
    @Nullable
    public Spell getSpellForKeybinding(@NotNull String key) {
        Spell spell;
        Intrinsics.checkNotNullParameter(key, "key");
        UUID spellUUID = (UUID)this.keybindToSpellId.getOrDefault((Object)key, null);
        if (spellUUID != null) {
            Map<UUID, Spell> map = this.spellIdToSpell;
            UUID uUID = spellUUID;
            Object v = null;
            boolean bl = false;
            Map<UUID, Spell> map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            spell = map2.getOrDefault(uUID, (Spell)v);
        } else {
            spell = null;
        }
        return spell;
    }

    @Override
    @Nullable
    public Spell getSpellById(@NotNull UUID spellId) {
        Intrinsics.checkNotNullParameter(spellId, "spellId");
        Map<UUID, Spell> map = this.spellIdToSpell;
        Object v = null;
        boolean bl = false;
        Map<UUID, Spell> map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        return map2.getOrDefault(spellId, (Spell)v);
    }

    @Override
    public void syncAll(@NotNull PlayerEntity entityPlayer) {
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        if (this.isServerSide(entityPlayer)) {
            AfraidOfTheDark.Companion.getPacketHandler().sendTo(new ClearSpellsPacket(), (ServerPlayerEntity)entityPlayer);
        } else {
            AfraidOfTheDark.Companion.getPacketHandler().sendToServer(new ClearSpellsPacket());
        }
        Iterable $this$forEach$iv = this.spellIdToSpell.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Spell it = (Spell)element$iv;
            boolean bl = false;
            this.sync(entityPlayer, it);
        }
    }

    @Override
    public void sync(@NotNull PlayerEntity entityPlayer, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        Intrinsics.checkNotNullParameter(spell, "spell");
        String keybind = this.getKeybindingForSpell(spell);
        SpellPacket syncSpellPacket = new SpellPacket(spell, keybind);
        if (this.isServerSide(entityPlayer)) {
            AfraidOfTheDark.Companion.getPacketHandler().sendTo(syncSpellPacket, (ServerPlayerEntity)entityPlayer);
        } else {
            AfraidOfTheDark.Companion.getPacketHandler().sendToServer(syncSpellPacket);
        }
    }

    private final boolean isServerSide(PlayerEntity entityPlayer) {
        return !entityPlayer.field_70170_p.field_72995_K;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/player/spell/PlayerSpellManager$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

