/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation;

import com.davidm1a2.afraidofthedark.client.entity.mcAnimatorLib.MCAModelRenderer;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.MathExtensionsKt;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.Channel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.ChannelMode;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.CustomChannel;
import com.davidm1a2.afraidofthedark.common.entity.mcAnimatorLib.animation.KeyFrame;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nJ\b\u0010\u0013\u001a\u00020\u0011H\u0003J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u000fH\u0007J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u001b\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0004H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/AnimationHandler;", "", "animChannels", "", "Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/Channel;", "([Lcom/davidm1a2/afraidofthedark/common/entity/mcAnimatorLib/animation/Channel;)V", "animCurrentChannels", "", "animCurrentFrame", "", "", "", "animPrevTime", "", "availableAnimChannels", "", "isAnimationActive", "", "name", "isGamePaused", "performAnimationInModel", "", "parts", "Lcom/davidm1a2/afraidofthedark/client/entity/mcAnimatorLib/MCAModelRenderer;", "playAnimation", "startingFrame", "stopAnimation", "update", "updateAnimation", "channel", "afraidofthedark"})
public final class AnimationHandler {
    @NotNull
    private final Set<Channel> animCurrentChannels;
    @NotNull
    private final Map<String, Long> animPrevTime;
    @NotNull
    private final Map<String, Float> animCurrentFrame;
    @NotNull
    private final Map<String, Channel> availableAnimChannels;

    /*
     * WARNING - void declaration
     */
    public AnimationHandler(Channel ... animChannels) {
        Map map;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(animChannels, "animChannels");
        boolean bl = false;
        this.animCurrentChannels = new LinkedHashSet();
        bl = false;
        this.animPrevTime = new LinkedHashMap();
        bl = false;
        this.animCurrentFrame = new LinkedHashMap();
        Channel[] channelArray = animChannels;
        AnimationHandler animationHandler = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(((void)$this$associateBy$iv).length), 16);
        void var5_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        void var8_10 = $this$associateByTo$iv$iv;
        int n = ((void)var8_10).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var12_14 = element$iv$iv = var8_10[i];
            map = destination$iv$iv;
            boolean bl2 = false;
            String string = it.getName();
            map.put(string, element$iv$iv);
        }
        animationHandler.availableAnimChannels = map = destination$iv$iv;
    }

    public final void update() {
        Iterator<Channel> it = this.animCurrentChannels.iterator();
        while (it.hasNext()) {
            Channel anim = it.next();
            boolean animStatus = this.updateAnimation(anim);
            if (animStatus) continue;
            this.animPrevTime.remove(anim.getName());
            this.animCurrentFrame.remove(anim.getName());
            it.remove();
        }
    }

    public final void playAnimation(@NotNull String name, float startingFrame) {
        Intrinsics.checkNotNullParameter(name, "name");
        Channel channel = this.availableAnimChannels.get(name);
        if (channel != null) {
            this.animCurrentChannels.add(channel);
            Map<String, Number> map = this.animPrevTime;
            Number number = System.nanoTime();
            boolean bl = false;
            map.put(name, number);
            map = this.animCurrentFrame;
            number = Float.valueOf(startingFrame);
            bl = false;
            map.put(name, number);
        } else {
            String string = "The animation called " + name + " doesn't exist!";
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    public static /* synthetic */ void playAnimation$default(AnimationHandler animationHandler, String string, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        animationHandler.playAnimation(string, f);
    }

    public final void stopAnimation(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Channel channel = this.availableAnimChannels.get(name);
        if (channel != null) {
            if (this.animCurrentChannels.contains(channel)) {
                this.animCurrentChannels.remove(channel);
                this.animPrevTime.remove(name);
                this.animCurrentFrame.remove(name);
            }
        } else {
            String string = "The animation called " + name + " doesn't exist!";
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    public final boolean isAnimationActive(@NotNull String name) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(name, "name");
            Iterable $this$any$iv = this.animCurrentChannels;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Channel it = (Channel)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getName(), name)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean updateAnimation(Channel channel) {
        boolean bl;
        LogicalSide side = EffectiveSide.get();
        if (side == LogicalSide.SERVER || side == LogicalSide.CLIENT && !this.isGamePaused()) {
            if (channel.getMode() != ChannelMode.CUSTOM) {
                Long l = this.animPrevTime.get(channel.getName());
                Intrinsics.checkNotNull(l);
                long prevTime = l;
                Float f = this.animCurrentFrame.get(channel.getName());
                Intrinsics.checkNotNull(f);
                float prevFrame = f.floatValue();
                long currentTime = System.nanoTime();
                double deltaTime = (double)(currentTime - prevTime) / 1.0E9;
                float numberOfSkippedFrames = (float)(deltaTime * (double)channel.getFps());
                float currentFrame = prevFrame + numberOfSkippedFrames;
                if (currentFrame < (float)(channel.getTotalFrames() - 1)) {
                    Map<String, Number> map = this.animPrevTime;
                    String string = channel.getName();
                    Number number = currentTime;
                    boolean bl2 = false;
                    map.put(string, number);
                    map = this.animCurrentFrame;
                    string = channel.getName();
                    number = Float.valueOf(currentFrame);
                    bl2 = false;
                    map.put(string, number);
                    bl = true;
                } else {
                    if (channel.getMode() == ChannelMode.LOOP) {
                        Map<String, Number> map = this.animPrevTime;
                        String string = channel.getName();
                        Number number = currentTime;
                        boolean bl3 = false;
                        map.put(string, number);
                        map = this.animCurrentFrame;
                        string = channel.getName();
                        number = Float.valueOf(0.0f);
                        bl3 = false;
                        map.put(string, number);
                        return true;
                    }
                    bl = false;
                }
            } else {
                bl = true;
            }
        } else {
            long currentTime = System.nanoTime();
            Map<String, Long> map = this.animPrevTime;
            String string = channel.getName();
            Long l = currentTime;
            boolean bl4 = false;
            map.put(string, l);
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @OnlyIn(value=Dist.CLIENT)
    private final boolean isGamePaused() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!minecraft.func_71356_B()) return false;
        if (minecraft.field_71462_r == null) return false;
        Screen screen = minecraft.field_71462_r;
        Intrinsics.checkNotNull(screen);
        if (!screen.isPauseScreen()) return false;
        screen = minecraft.func_71401_C();
        Intrinsics.checkNotNull(screen);
        if (screen.func_71344_c()) return false;
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void performAnimationInModel(@NotNull Map<String, MCAModelRenderer> parts) {
        Intrinsics.checkNotNullParameter(parts, "parts");
        Object object = parts;
        boolean bl = false;
        Iterator<Map.Entry<String, MCAModelRenderer>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2 = object = iterator2.next();
            boolean bl2 = false;
            String boxName = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            MCAModelRenderer box = (MCAModelRenderer)((Object)object3.getValue());
            boolean anyRotationApplied = false;
            boolean anyTranslationApplied = false;
            boolean anyCustomAnimationRunning = false;
            for (Channel channel : this.animCurrentChannels) {
                if (channel.getMode() != ChannelMode.CUSTOM) {
                    Vector3f currentPosition;
                    int n;
                    KeyFrame nextTranslationKeyFrame;
                    KeyFrame it4;
                    int n2;
                    KeyFrame prevTranslationKeyFrame;
                    int n3;
                    KeyFrame it2;
                    int n4;
                    KeyFrame nextRotationKeyFrame;
                    int n52;
                    KeyFrame it32;
                    int n6;
                    KeyFrame keyFrame;
                    int n7;
                    KeyFrame prevRotationKeyFrame;
                    Float f = this.animCurrentFrame.get(channel.getName());
                    Intrinsics.checkNotNull(f);
                    float currentFrame = f.floatValue();
                    Float f2 = this.animCurrentFrame.get(channel.getName());
                    Intrinsics.checkNotNull(f2);
                    KeyFrame keyFrame2 = prevRotationKeyFrame = channel.getPreviousRotationKeyFrameForBox(boxName, f2.floatValue());
                    if (keyFrame2 == null) {
                        n7 = 0;
                    } else {
                        int n8;
                        keyFrame = keyFrame2;
                        n6 = 0;
                        boolean bl4 = false;
                        it32 = keyFrame;
                        n52 = 0;
                        n7 = n8 = channel.getKeyFramePosition(it32);
                    }
                    int prevRotationKeyFramePosition = n7;
                    Float f3 = this.animCurrentFrame.get(channel.getName());
                    Intrinsics.checkNotNull(f3);
                    keyFrame = nextRotationKeyFrame = channel.getNextRotationKeyFrameForBox(boxName, f3.floatValue());
                    if (keyFrame == null) {
                        n4 = 0;
                    } else {
                        KeyFrame keyFrame3 = keyFrame;
                        boolean it32 = false;
                        n52 = 0;
                        it2 = keyFrame3;
                        n3 = 0;
                        n4 = n6 = channel.getKeyFramePosition(it2);
                    }
                    int nextRotationKeyFramePosition = n4;
                    float slerpProgress = (currentFrame - (float)prevRotationKeyFramePosition) / (float)(nextRotationKeyFramePosition - prevRotationKeyFramePosition);
                    slerpProgress = RangesKt.coerceIn(slerpProgress, 0.0f, 1.0f);
                    if (prevRotationKeyFramePosition == 0 && prevRotationKeyFrame == null && nextRotationKeyFramePosition != 0) {
                        Quaternion currentQuat = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
                        Quaternion quaternion = box.getDefaultRotation();
                        Intrinsics.checkNotNull(nextRotationKeyFrame);
                        Quaternion quaternion2 = nextRotationKeyFrame.getModelRotations$afraidofthedark().get(boxName);
                        Intrinsics.checkNotNull(quaternion2);
                        MathExtensionsKt.slerp(currentQuat, quaternion, quaternion2, slerpProgress);
                        box.getRotation().func_227066_a_(currentQuat.func_195889_a(), currentQuat.func_195891_b(), currentQuat.func_195893_c(), currentQuat.func_195894_d());
                        anyRotationApplied = true;
                    } else if (prevRotationKeyFramePosition == 0 && prevRotationKeyFrame != null && nextRotationKeyFramePosition != 0) {
                        Quaternion currentQuat = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
                        Quaternion quaternion = prevRotationKeyFrame.getModelRotations$afraidofthedark().get(boxName);
                        Intrinsics.checkNotNull(quaternion);
                        Quaternion quaternion3 = quaternion;
                        Intrinsics.checkNotNull(nextRotationKeyFrame);
                        quaternion = nextRotationKeyFrame.getModelRotations$afraidofthedark().get(boxName);
                        Intrinsics.checkNotNull(quaternion);
                        MathExtensionsKt.slerp(currentQuat, quaternion3, quaternion, slerpProgress);
                        box.getRotation().func_227066_a_(currentQuat.func_195889_a(), currentQuat.func_195891_b(), currentQuat.func_195893_c(), currentQuat.func_195894_d());
                        anyRotationApplied = true;
                    } else if (prevRotationKeyFramePosition != 0 && nextRotationKeyFramePosition != 0) {
                        Quaternion currentQuat = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
                        Intrinsics.checkNotNull(prevRotationKeyFrame);
                        Quaternion quaternion = prevRotationKeyFrame.getModelRotations$afraidofthedark().get(boxName);
                        Intrinsics.checkNotNull(quaternion);
                        Quaternion quaternion4 = quaternion;
                        Intrinsics.checkNotNull(nextRotationKeyFrame);
                        quaternion = nextRotationKeyFrame.getModelRotations$afraidofthedark().get(boxName);
                        Intrinsics.checkNotNull(quaternion);
                        MathExtensionsKt.slerp(currentQuat, quaternion4, quaternion, slerpProgress);
                        box.getRotation().func_227066_a_(currentQuat.func_195889_a(), currentQuat.func_195891_b(), currentQuat.func_195893_c(), currentQuat.func_195894_d());
                        anyRotationApplied = true;
                    }
                    Float f4 = this.animCurrentFrame.get(channel.getName());
                    Intrinsics.checkNotNull(f4);
                    it32 = prevTranslationKeyFrame = channel.getPreviousTranslationKeyFrameForBox(boxName, f4.floatValue());
                    if (it32 == null) {
                        n2 = 0;
                    } else {
                        it2 = it32;
                        n3 = 0;
                        boolean bl5 = false;
                        it4 = it2;
                        boolean bl6 = false;
                        n2 = n52 = channel.getKeyFramePosition(it4);
                    }
                    int prevTranslationsKeyFramePosition = n2;
                    Float n52 = this.animCurrentFrame.get(channel.getName());
                    Intrinsics.checkNotNull(n52);
                    it2 = nextTranslationKeyFrame = channel.getNextTranslationKeyFrameForBox(boxName, n52.floatValue());
                    if (it2 == null) {
                        n = 0;
                    } else {
                        KeyFrame keyFrame4 = it2;
                        boolean it4 = false;
                        boolean bl7 = false;
                        KeyFrame it5 = keyFrame4;
                        boolean bl8 = false;
                        n = n3 = channel.getKeyFramePosition(it5);
                    }
                    int nextTranslationsKeyFramePosition = n;
                    float lerpProgress = (currentFrame - (float)prevTranslationsKeyFramePosition) / (float)(nextTranslationsKeyFramePosition - prevTranslationsKeyFramePosition);
                    lerpProgress = RangesKt.coerceAtMost(lerpProgress, 1.0f);
                    if (prevTranslationsKeyFramePosition == 0 && prevTranslationKeyFrame == null && nextTranslationsKeyFramePosition != 0) {
                        Vector3f startPosition = box.getRotationPointAsVector();
                        Intrinsics.checkNotNull(nextTranslationKeyFrame);
                        it4 = nextTranslationKeyFrame.getModelTranslations$afraidofthedark().get(boxName);
                        Intrinsics.checkNotNull(it4);
                        KeyFrame endPosition = it4;
                        currentPosition = startPosition.func_229195_e_();
                        Intrinsics.checkNotNullExpressionValue(currentPosition, "currentPosition");
                        MathExtensionsKt.interpolate(currentPosition, (Vector3f)endPosition, lerpProgress);
                        box.func_78793_a(currentPosition.func_195899_a(), currentPosition.func_195900_b(), currentPosition.func_195902_c());
                        anyTranslationApplied = true;
                        continue;
                    }
                    if (prevTranslationsKeyFramePosition == 0 && prevTranslationKeyFrame != null && nextTranslationsKeyFramePosition != 0) {
                        Vector3f endPosition = prevTranslationKeyFrame.getModelTranslations$afraidofthedark().get(boxName);
                        Intrinsics.checkNotNull(endPosition);
                        Vector3f startPosition = endPosition;
                        Intrinsics.checkNotNull(nextTranslationKeyFrame);
                        currentPosition = nextTranslationKeyFrame.getModelTranslations$afraidofthedark().get(boxName);
                        Intrinsics.checkNotNull(currentPosition);
                        endPosition = currentPosition;
                        currentPosition = startPosition.func_229195_e_();
                        Intrinsics.checkNotNullExpressionValue(currentPosition, "currentPosition");
                        MathExtensionsKt.interpolate(currentPosition, endPosition, lerpProgress);
                        box.func_78793_a(currentPosition.func_195899_a(), currentPosition.func_195900_b(), currentPosition.func_195902_c());
                        anyTranslationApplied = true;
                        continue;
                    }
                    if (prevTranslationsKeyFramePosition == 0 || nextTranslationsKeyFramePosition == 0) continue;
                    Intrinsics.checkNotNull(prevTranslationKeyFrame);
                    Vector3f endPosition = prevTranslationKeyFrame.getModelTranslations$afraidofthedark().get(boxName);
                    Intrinsics.checkNotNull(endPosition);
                    Vector3f startPosition = endPosition;
                    Intrinsics.checkNotNull(nextTranslationKeyFrame);
                    currentPosition = nextTranslationKeyFrame.getModelTranslations$afraidofthedark().get(boxName);
                    Intrinsics.checkNotNull(currentPosition);
                    endPosition = currentPosition;
                    currentPosition = startPosition.func_229195_e_();
                    Intrinsics.checkNotNullExpressionValue(currentPosition, "currentPosition");
                    MathExtensionsKt.interpolate(currentPosition, endPosition, lerpProgress);
                    box.func_78793_a(currentPosition.func_195899_a(), currentPosition.func_195900_b(), currentPosition.func_195902_c());
                    anyTranslationApplied = true;
                    continue;
                }
                anyCustomAnimationRunning = true;
                ((CustomChannel)channel).update(parts, this);
            }
            if (!anyRotationApplied && !anyCustomAnimationRunning) {
                box.resetRotationQuaternion();
            }
            if (anyTranslationApplied || anyCustomAnimationRunning) continue;
            box.resetRotationPoint();
        }
    }
}

