/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IPlayerVoidChestData;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.dimension.IslandUtility;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/VoidChestHandler;", "", "()V", "onPlayerRespawnEvent", "", "event", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerRespawnEvent;", "onPostEntityTravelToDimension", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerChangedDimensionEvent;", "onPreEntityTravelToDimension", "Lnet/minecraftforge/event/entity/EntityTravelToDimensionEvent;", "processPostTeleport", "entityPlayer", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "dimensionFrom", "Lnet/minecraft/world/dimension/DimensionType;", "dimensionTo", "processPreTeleport", "", "Companion", "afraidofthedark"})
public final class VoidChestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int VALID_SPAWN_SEARCH_DISTANCE = 6;

    @SubscribeEvent
    public final void onPlayerRespawnEvent(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getPlayer().field_70170_p.field_72995_K && Intrinsics.areEqual(event.getPlayer().field_71093_bK, ModDimensions.INSTANCE.getVOID_CHEST_TYPE())) {
            int n;
            MinecraftServer minecraftServer;
            PlayerEntity playerEntity = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(playerEntity, "event.player");
            IPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData(playerEntity);
            if (playerVoidChestData.getFriendsIndex() == -1) {
                minecraftServer = event.getPlayer().func_184102_h();
                Intrinsics.checkNotNull(minecraftServer);
                ServerWorld serverWorld = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getVOID_CHEST_TYPE());
                Intrinsics.checkNotNullExpressionValue(serverWorld, "event.player.server!!.getWorld(ModDimensions.VOID_CHEST_TYPE)");
                n = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex((World)serverWorld, playerVoidChestData);
            } else {
                n = playerVoidChestData.getFriendsIndex();
            }
            int indexToGoTo = n;
            int playerXBase = indexToGoTo * 1000;
            minecraftServer = event.getPlayer();
            if (minecraftServer == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
            }
            ((ServerPlayerEntity)minecraftServer).field_71135_a.func_147364_a((double)playerXBase + 24.5, 104.0, 3.0, 0.0f, 0.0f);
        }
    }

    @SubscribeEvent
    public final void onPreEntityTravelToDimension(@NotNull EntityTravelToDimensionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getEntity().field_70170_p.field_72995_K) {
            DimensionType fromDimension = event.getEntity().field_71093_bK;
            DimensionType toDimension = event.getDimension();
            if (event.getEntity() instanceof ServerPlayerEntity) {
                Entity entity = event.getEntity();
                if (entity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
                }
                ServerPlayerEntity entityPlayer = (ServerPlayerEntity)entity;
                Intrinsics.checkNotNullExpressionValue(fromDimension, "fromDimension");
                Intrinsics.checkNotNullExpressionValue(toDimension, "toDimension");
                if (this.processPreTeleport(entityPlayer, fromDimension, toDimension)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private final boolean processPreTeleport(ServerPlayerEntity entityPlayer, DimensionType dimensionFrom, DimensionType dimensionTo) {
        if (Intrinsics.areEqual(dimensionTo, ModDimensions.INSTANCE.getVOID_CHEST_TYPE())) {
            if (Intrinsics.areEqual(dimensionFrom, ModDimensions.INSTANCE.getVOID_CHEST_TYPE())) {
                return true;
            }
            IPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData((PlayerEntity)entityPlayer);
            World world = entityPlayer.field_70170_p;
            Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.world");
            World world2 = world;
            world = entityPlayer.func_180425_c();
            Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.position");
            if (IslandUtility.INSTANCE.isValidSpawnLocation(world2, (BlockPos)world)) {
                playerVoidChestData.setPreTeleportPosition(entityPlayer.func_180425_c());
            } else {
                World world3 = entityPlayer.field_70170_p;
                Intrinsics.checkNotNullExpressionValue(world3, "entityPlayer.world");
                World world4 = world3;
                world3 = entityPlayer.func_180425_c();
                Intrinsics.checkNotNullExpressionValue(world3, "entityPlayer.position");
                BlockPos preTeleportPosition = IslandUtility.INSTANCE.findValidSpawnLocation(world4, (BlockPos)world3, 6);
                if (preTeleportPosition == null) {
                    entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.dimension.void_chest.no_spawn", new Object[0]));
                    return true;
                }
                playerVoidChestData.setPreTeleportPosition(preTeleportPosition);
            }
            playerVoidChestData.setPreTeleportDimension(dimensionFrom);
        }
        return false;
    }

    @SubscribeEvent
    public final void onPostEntityTravelToDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            DimensionType fromDimension = event.getFrom();
            DimensionType toDimension = event.getTo();
            PlayerEntity playerEntity = event.getPlayer();
            if (playerEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
            }
            ServerPlayerEntity entityPlayer = (ServerPlayerEntity)playerEntity;
            Intrinsics.checkNotNullExpressionValue(fromDimension, "fromDimension");
            Intrinsics.checkNotNullExpressionValue(toDimension, "toDimension");
            this.processPostTeleport(entityPlayer, fromDimension, toDimension);
        }
    }

    private final void processPostTeleport(ServerPlayerEntity entityPlayer, DimensionType dimensionFrom, DimensionType dimensionTo) {
        if (Intrinsics.areEqual(dimensionTo, ModDimensions.INSTANCE.getVOID_CHEST_TYPE())) {
            int n;
            IPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData((PlayerEntity)entityPlayer);
            if (playerVoidChestData.getFriendsIndex() == -1) {
                MinecraftServer minecraftServer = entityPlayer.field_71133_b;
                Intrinsics.checkNotNull(minecraftServer);
                ServerWorld serverWorld = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getVOID_CHEST_TYPE());
                Intrinsics.checkNotNullExpressionValue(serverWorld, "entityPlayer.server!!.getWorld(ModDimensions.VOID_CHEST_TYPE)");
                n = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex((World)serverWorld, playerVoidChestData);
            } else {
                n = playerVoidChestData.getFriendsIndex();
            }
            int indexToGoTo = n;
            int playerXBase = indexToGoTo * 1000;
            entityPlayer.field_71135_a.func_147364_a((double)playerXBase + 24.5, 104.0, 3.0, 0.0f, 0.0f);
        }
        if (Intrinsics.areEqual(dimensionFrom, ModDimensions.INSTANCE.getVOID_CHEST_TYPE())) {
            BlockPos blockPos = CapabilityExtensionsKt.getVoidChestData((PlayerEntity)entityPlayer).getPreTeleportPosition();
            Intrinsics.checkNotNull(blockPos);
            BlockPos preTeleportPosition = blockPos;
            entityPlayer.field_71135_a.func_147364_a((double)preTeleportPosition.func_177958_n() + 0.5, (double)preTeleportPosition.func_177956_o() + 1.5, (double)preTeleportPosition.func_177952_p() + 0.5, 0.0f, 0.0f);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/VoidChestHandler$Companion;", "", "()V", "VALID_SPAWN_SEARCH_DISTANCE", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

