/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.feature.structure.gnomishcity;

import com.davidm1a2.afraidofthedark.common.constants.ModCommonConfiguration;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.feature.structure.gnomishcity.GnomishCityStructureStart;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/structure/gnomishcity/GnomishCityStructure;", "Lcom/davidm1a2/afraidofthedark/common/feature/structure/base/AOTDStructure;", "Lnet/minecraft/world/gen/feature/NoFeatureConfig;", "()V", "length", "", "width", "canFitAt", "", "chunkGen", "Lnet/minecraft/world/gen/ChunkGenerator;", "biomeManager", "Lnet/minecraft/world/biome/BiomeManager;", "random", "Ljava/util/Random;", "xPos", "zPos", "getLength", "getStartFactory", "Lnet/minecraft/world/gen/feature/structure/Structure$IStartFactory;", "getStructureName", "", "getWidth", "setupStructureIn", "", "biome", "Lnet/minecraft/world/biome/Biome;", "Companion", "afraidofthedark"})
public final class GnomishCityStructure
extends AOTDStructure<NoFeatureConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int length;
    @NotNull
    private static final List<Biome.Category> VALID_BIOME_CATEGORIES;

    public GnomishCityStructure() {
        super(1.INSTANCE, false, 2, null);
        short connectorWidth = ModSchematics.INSTANCE.getCONNECTOR().getWidth();
        short roomWidth = ModSchematics.INSTANCE.getROOM_CAVE().getWidth();
        this.width = roomWidth * 3 + connectorWidth * 2 - 4;
        short roomLength = ModSchematics.INSTANCE.getROOM_CAVE().getLength();
        this.length = roomLength * 3 + connectorWidth * 2 - 4;
    }

    @Override
    @NotNull
    public String func_143025_a() {
        return "afraidofthedark:gnomish_city";
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setupStructureIn(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter(biome, "biome");
        if (VALID_BIOME_CATEGORIES.contains(biome.func_201856_r())) {
            NoFeatureConfig noFeatureConfig = IFeatureConfig.field_202429_e;
            Intrinsics.checkNotNullExpressionValue(noFeatureConfig, "NO_FEATURE_CONFIG");
            this.addToBiome(biome, (IFeatureConfig)noFeatureConfig);
        }
    }

    @NotNull
    public Structure.IStartFactory func_214557_a() {
        return GnomishCityStructure::getStartFactory$lambda-0;
    }

    @Override
    public boolean canFitAt(@NotNull ChunkGenerator<?> chunkGen, @NotNull BiomeManager biomeManager, @NotNull Random random, int xPos, int zPos) {
        Intrinsics.checkNotNullParameter(chunkGen, "chunkGen");
        Intrinsics.checkNotNullParameter(biomeManager, "biomeManager");
        Intrinsics.checkNotNullParameter(random, "random");
        double chance = this.getOneInNValidChunks(3500) * ModCommonConfiguration.INSTANCE.getGnomishCityFrequency();
        return !(random.nextDouble() >= chance);
    }

    private static final StructureStart getStartFactory$lambda-0(Structure structure, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
        Intrinsics.checkNotNullExpressionValue(structure, "structure");
        Intrinsics.checkNotNullExpressionValue(mutableBoundingBox, "mutableBoundingBox");
        return new GnomishCityStructureStart(structure, chunkX, chunkZ, mutableBoundingBox, reference, seed);
    }

    static {
        Biome.Category[] categoryArray = new Biome.Category[]{Biome.Category.TAIGA, Biome.Category.EXTREME_HILLS, Biome.Category.JUNGLE, Biome.Category.MESA, Biome.Category.PLAINS, Biome.Category.SAVANNA, Biome.Category.ICY, Biome.Category.BEACH, Biome.Category.FOREST, Biome.Category.OCEAN, Biome.Category.DESERT, Biome.Category.RIVER, Biome.Category.SWAMP, Biome.Category.MUSHROOM};
        VALID_BIOME_CATEGORIES = CollectionsKt.listOf(categoryArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/structure/gnomishcity/GnomishCityStructure$Companion;", "", "()V", "VALID_BIOME_CATEGORIES", "", "Lnet/minecraft/world/biome/Biome$Category;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

