/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModEntities;
import com.davidm1a2.afraidofthedark.common.constants.ModItems;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.entity.enchantedSkeleton.EnchantedSkeletonEntity;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/EnchantedSkeletonBoneItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "()V", "onEntityItemUpdate", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "entityItem", "Lnet/minecraft/entity/item/ItemEntity;", "Companion", "afraidofthedark"})
public final class EnchantedSkeletonBoneItem
extends AOTDItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int BONES_PER_SKELETON = 4;
    private static final int COMBINE_RADIUS = 4;
    private static final int UPDATE_TIME_IN_TICKS = 120;
    private static final int RESEARCH_UNLOCK_RADIUS = 7;

    public EnchantedSkeletonBoneItem() {
        super("enchanted_skeleton_bone", new Item.Properties(), false, 4, null);
    }

    public boolean onEntityItemUpdate(@NotNull ItemStack itemStack, @NotNull ItemEntity entityItem) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(entityItem, "entityItem");
        if (!entityItem.field_70170_p.field_72995_K && entityItem.field_70173_aa % 120 == 0) {
            List surroundingItems = entityItem.field_70170_p.func_217357_a(ItemEntity.class, entityItem.func_174813_aQ().func_186662_g(4.0));
            int numberOfBones = 0;
            boolean bl = false;
            List surroundingBones = new ArrayList();
            for (ItemEntity otherItem : surroundingItems) {
                if (!(otherItem.func_92059_d().func_77973_b() instanceof EnchantedSkeletonBoneItem) || !otherItem.field_70122_E) continue;
                Intrinsics.checkNotNullExpressionValue(otherItem, "otherItem");
                surroundingBones.add(otherItem);
                numberOfBones += otherItem.func_92059_d().func_190916_E();
            }
            if (numberOfBones >= 4) {
                PlayerEntity it;
                Iterable $this$forEach$iv;
                int numberOfSkeletonsToSpawn = numberOfBones / 4;
                int bonesRemaining = numberOfBones % 4;
                World world = entityItem.field_70170_p;
                int n = 0;
                if (n < numberOfSkeletonsToSpawn) {
                    do {
                        int i = n++;
                        EntityType<EnchantedSkeletonEntity> entityType = ModEntities.INSTANCE.getENCHANTED_SKELETON();
                        Intrinsics.checkNotNullExpressionValue(world, "world");
                        EnchantedSkeletonEntity skeleton = new EnchantedSkeletonEntity(entityType, world);
                        skeleton.func_70012_b(entityItem.func_226277_ct_(), entityItem.func_226278_cu_() + 0.01, entityItem.func_226281_cx_(), entityItem.field_70177_z, 0.0f);
                        skeleton.func_195064_c(new EffectInstance(Effects.field_76441_p, 2));
                        world.func_217376_c((Entity)skeleton);
                    } while (n < numberOfSkeletonsToSpawn);
                }
                Iterable iterable = world.func_217357_a(PlayerEntity.class, entityItem.func_174813_aQ().func_186662_g(7.0));
                Intrinsics.checkNotNullExpressionValue(iterable, "world.getEntitiesWithinAABB(\n                    PlayerEntity::class.java,\n                    entityItem.boundingBox.grow(RESEARCH_UNLOCK_RADIUS.toDouble())\n                )");
                iterable = iterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (PlayerEntity)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    IPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(it);
                    if (!playerResearch.canResearch(ModResearches.INSTANCE.getENCHANTED_SKELETON())) continue;
                    playerResearch.setResearch(ModResearches.INSTANCE.getENCHANTED_SKELETON(), true);
                    playerResearch.sync(it, true);
                }
                if (bonesRemaining > 0) {
                    ItemEntity leftOver = new ItemEntity(world, entityItem.func_226277_ct_(), entityItem.func_226278_cu_(), entityItem.func_226281_cx_(), new ItemStack((IItemProvider)ModItems.INSTANCE.getENCHANTED_SKELETON_BONE(), bonesRemaining));
                    world.func_217376_c((Entity)leftOver);
                }
                $this$forEach$iv = surroundingBones;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ItemEntity)element$iv;
                    boolean bl3 = false;
                    it.func_70106_y();
                }
            }
        }
        return super.onEntityItemUpdate(itemStack, entityItem);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/EnchantedSkeletonBoneItem$Companion;", "", "()V", "BONES_PER_SKELETON", "", "COMBINE_RADIUS", "RESEARCH_UNLOCK_RADIUS", "UPDATE_TIME_IN_TICKS", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

