/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDSharedCooldownItem;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006H\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\tH\u0016J \u0010!\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\tH\u0016J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0019H\u0002J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0004H\u0002\u00a8\u0006)"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/StarMetalStaffItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDSharedCooldownItem;", "()V", "canContinueUsing", "", "oldStack", "Lnet/minecraft/item/ItemStack;", "newStack", "getCooldownInMilliseconds", "", "itemStack", "getUseDuration", "stack", "inventoryTick", "", "world", "Lnet/minecraft/world/World;", "entity", "Lnet/minecraft/entity/Entity;", "itemSlot", "isSelected", "isInUse", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "onItemUseFinish", "entityLiving", "Lnet/minecraft/entity/LivingEntity;", "onPlayerStoppedUsing", "timeLeft", "onUsingTick", "entityLivingBase", "count", "performKnockback", "entityPlayer", "setInUse", "inUse", "Companion", "afraidofthedark"})
public final class StarMetalStaffItem
extends AOTDSharedCooldownItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double KNOCKBACK_STRENGTH = 4.0;
    private static final int MAX_TROLL_POLE_TIME_IN_TICKS = 60;
    @NotNull
    private static final String NBT_IN_USE = "in_use";
    @NotNull
    private static final String NBT_X_POSITION = "x_position";
    @NotNull
    private static final String NBT_Y_POSITION = "y_position";
    @NotNull
    private static final String NBT_Z_POSITION = "z_position";

    public StarMetalStaffItem() {
        super("star_metal_staff", new Item.Properties(), false, 4, null);
    }

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (entity instanceof PlayerEntity && !isSelected && (((PlayerEntity)entity).func_184600_cs() != Hand.OFF_HAND || !Intrinsics.areEqual(((PlayerEntity)entity).func_184607_cu(), stack)) && !((PlayerEntity)entity).func_184812_l_() && ((PlayerEntity)entity).field_71075_bZ.field_75102_a && this.isInUse(stack)) {
            ((PlayerEntity)entity).field_71075_bZ.field_75102_a = false;
            this.setInUse(stack, false);
        }
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(hand, "hand");
        ItemStack heldItem = player.func_184586_b(hand);
        if (CapabilityExtensionsKt.getResearch(player).isResearched(ModResearches.INSTANCE.getSTAR_METAL())) {
            Object[] objectArray;
            Intrinsics.checkNotNullExpressionValue(heldItem, "heldItem");
            if (!this.isOnCooldown(heldItem)) {
                if (!player.func_184812_l_()) {
                    player.field_71075_bZ.field_75102_a = true;
                }
                if (!world.field_72995_K) {
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(player.func_145782_y(), new Vec3d(0.0, 0.5, 0.0)));
                }
                this.setOnCooldown(heldItem, player);
                this.setInUse(heldItem, true);
                player.func_184598_c(hand);
                ActionResult actionResult = ActionResult.func_226248_a_((Object)heldItem);
                Intrinsics.checkNotNullExpressionValue(actionResult, "resultSuccess(heldItem)");
                return actionResult;
            }
            if (!world.field_72995_K) {
                objectArray = new Object[]{this.cooldownRemainingInSeconds(heldItem)};
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.star_metal_staff.on_cooldown", objectArray));
            }
            objectArray = ActionResult.func_226251_d_((Object)heldItem);
            Intrinsics.checkNotNullExpressionValue(objectArray, "resultFail(heldItem)");
            return objectArray;
        }
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.dont_understand", new Object[0]));
        }
        ActionResult actionResult = ActionResult.func_226250_c_((Object)heldItem);
        Intrinsics.checkNotNullExpressionValue(actionResult, "resultPass(heldItem)");
        return actionResult;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull LivingEntity entityLivingBase, int count) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(entityLivingBase, "entityLivingBase");
        int count2 = count;
        if (!entityLivingBase.field_70170_p.field_72995_K && entityLivingBase instanceof PlayerEntity) {
            count2 = this.func_77626_a(stack) - count2;
            if (count2 == 1) {
                entityLivingBase.field_70143_R = 0.0f;
            }
            if (count2 == 4) {
                NBTHelper.INSTANCE.setDouble(stack, NBT_X_POSITION, ((PlayerEntity)entityLivingBase).func_226277_ct_());
                NBTHelper.INSTANCE.setDouble(stack, NBT_Y_POSITION, ((PlayerEntity)entityLivingBase).func_226278_cu_());
                NBTHelper.INSTANCE.setDouble(stack, NBT_Z_POSITION, ((PlayerEntity)entityLivingBase).func_226281_cx_());
            }
            if (count2 >= 5) {
                Double d = NBTHelper.INSTANCE.getDouble(stack, NBT_X_POSITION);
                Intrinsics.checkNotNull(d);
                double x = d;
                Double d2 = NBTHelper.INSTANCE.getDouble(stack, NBT_Y_POSITION);
                Intrinsics.checkNotNull(d2);
                double y = d2;
                SPlayerPositionLookPacket.Flags[] flagsArray = NBTHelper.INSTANCE.getDouble(stack, NBT_Z_POSITION);
                Intrinsics.checkNotNull(flagsArray);
                double z = flagsArray.doubleValue();
                flagsArray = new SPlayerPositionLookPacket.Flags[]{SPlayerPositionLookPacket.Flags.X_ROT, SPlayerPositionLookPacket.Flags.Y_ROT};
                ((ServerPlayerEntity)entityLivingBase).field_71135_a.func_175089_a(x, y, z, entityLivingBase.field_70177_z, entityLivingBase.field_70125_A, SetsKt.setOf(flagsArray));
            }
        }
    }

    @NotNull
    public ItemStack func_77654_b(@NotNull ItemStack stack, @NotNull World world, @NotNull LivingEntity entityLiving) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(entityLiving, "entityLiving");
        this.setInUse(stack, false);
        if (entityLiving instanceof PlayerEntity) {
            if (!((PlayerEntity)entityLiving).func_184812_l_()) {
                ((PlayerEntity)entityLiving).field_71075_bZ.field_75102_a = false;
            }
            if (!entityLiving.field_70170_p.field_72995_K) {
                this.performKnockback(world, (PlayerEntity)entityLiving);
            }
        }
        ItemStack itemStack = super.func_77654_b(stack, world, entityLiving);
        Intrinsics.checkNotNullExpressionValue(itemStack, "super.onItemUseFinish(stack, world, entityLiving)");
        return itemStack;
    }

    public void func_77615_a(@NotNull ItemStack stack, @NotNull World world, @NotNull LivingEntity entityLiving, int timeLeft) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(entityLiving, "entityLiving");
        this.setInUse(stack, false);
        if (entityLiving instanceof PlayerEntity) {
            if (!((PlayerEntity)entityLiving).func_184812_l_()) {
                ((PlayerEntity)entityLiving).field_71075_bZ.field_75102_a = false;
            }
            if (timeLeft < 5 && !world.field_72995_K) {
                this.performKnockback(world, (PlayerEntity)entityLiving);
            }
        }
    }

    private final void performKnockback(World world, PlayerEntity entityPlayer) {
        List entityList = world.func_72839_b((Entity)entityPlayer, entityPlayer.func_174813_aQ().func_186662_g(10.0));
        for (Entity entity : entityList) {
            if (!(entity instanceof PlayerEntity) && !(entity instanceof MobEntity)) continue;
            Vec3d direction = entity.func_174791_d().func_178788_d(entityPlayer.func_174791_d()).func_72432_b().func_186678_a(4.0);
            entity.func_70024_g(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
        }
    }

    @Override
    public int getCooldownInMilliseconds(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        return 5000;
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        return 60;
    }

    public boolean canContinueUsing(@NotNull ItemStack oldStack, @NotNull ItemStack newStack) {
        Intrinsics.checkNotNullParameter(oldStack, "oldStack");
        Intrinsics.checkNotNullParameter(newStack, "newStack");
        return Intrinsics.areEqual(newStack.func_77973_b(), (Object)this) && this.isInUse(newStack);
    }

    private final void setInUse(ItemStack itemStack, boolean inUse) {
        NBTHelper.INSTANCE.setBoolean(itemStack, NBT_IN_USE, inUse);
    }

    private final boolean isInUse(ItemStack itemStack) {
        boolean bl;
        if (NBTHelper.INSTANCE.hasTag(itemStack, NBT_IN_USE)) {
            Boolean bl2 = NBTHelper.INSTANCE.getBoolean(itemStack, NBT_IN_USE);
            Intrinsics.checkNotNull(bl2);
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/StarMetalStaffItem$Companion;", "", "()V", "KNOCKBACK_STRENGTH", "", "MAX_TROLL_POLE_TIME_IN_TICKS", "", "NBT_IN_USE", "", "NBT_X_POSITION", "NBT_Y_POSITION", "NBT_Z_POSITION", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

