/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.schematic;

import com.davidm1a2.afraidofthedark.common.schematic.CachedSchematic;
import com.davidm1a2.afraidofthedark.common.schematic.OnDemandSchematic;
import com.davidm1a2.afraidofthedark.common.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.utility.ResourceUtil;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/schematic/SchematicBuilder;", "", "()V", "cacheEnabled", "", "resourceLocation", "Lnet/minecraft/util/ResourceLocation;", "build", "Lcom/davidm1a2/afraidofthedark/common/schematic/Schematic;", "createCached", "createOnDemand", "withCacheEnabled", "withFile", "Companion", "afraidofthedark"})
public final class SchematicBuilder {
    @NotNull
    public static final Companion Companion;
    private boolean cacheEnabled = true;
    @Nullable
    private ResourceLocation resourceLocation;
    private static final Logger LOG;
    private static final boolean USE_CACHE;

    @NotNull
    public final SchematicBuilder withCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        return this;
    }

    @NotNull
    public final SchematicBuilder withFile(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter(resourceLocation, "resourceLocation");
        this.resourceLocation = resourceLocation;
        return this;
    }

    @NotNull
    public final Schematic build() {
        ResourceLocation resourceLocation = this.resourceLocation;
        boolean bl = false;
        boolean bl2 = false;
        if (resourceLocation == null) {
            boolean bl3 = false;
            String string = "Resource location must be specified!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return USE_CACHE ? this.createCached() : this.createOnDemand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Schematic createCached() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        CompoundNBT compoundNBT;
        Collection collection;
        INBT iNBT;
        void $this$mapTo$iv$iv3;
        ResourceLocation resourceLocation = this.resourceLocation;
        Intrinsics.checkNotNull(resourceLocation);
        String schematicName = FilenameUtils.getBaseName((String)resourceLocation.func_110623_a());
        Object object = this.resourceLocation;
        Intrinsics.checkNotNull(object);
        object = ResourceUtil.INSTANCE.getInputStream((ResourceLocation)object);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)object;
            boolean bl3 = false;
            it = CompressedStreamTools.func_74796_a((InputStream)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        InputStream nbtData = it;
        short width = nbtData.func_74765_d("Width");
        short height = nbtData.func_74765_d("Height");
        short length = nbtData.func_74765_d("Length");
        ListNBT tileEntities = nbtData.func_150295_c("TileEntities", 10);
        ListNBT entities = nbtData.func_150295_c("Entities", 10);
        int[] blockIds = nbtData.func_74759_k("BlockIds");
        ListNBT listNBT = nbtData.func_150295_c("BlockIdData", 10);
        Intrinsics.checkNotNullExpressionValue(listNBT, "nbtData.getList(\"BlockIdData\", Constants.NBT.TAG_COMPOUND)");
        Iterable $this$map$iv = (Iterable)listNBT;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            iNBT = (INBT)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            if (it == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundNBT");
            }
            compoundNBT = (CompoundNBT)it;
            collection.add(compoundNBT);
        }
        List blockMapData = (List)destination$iv$iv;
        Iterable $this$map$iv2 = blockMapData;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            CompoundNBT bl4 = (CompoundNBT)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            compoundNBT = NBTUtil.func_190008_d((CompoundNBT)it);
            collection.add(compoundNBT);
        }
        List blockMapBlocks = (List)destination$iv$iv2;
        Intrinsics.checkNotNullExpressionValue(blockIds, "blockIds");
        Object $this$map$iv3 = blockIds;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(((int[])$this$map$iv3).length);
        boolean $i$f$mapTo3 = false;
        iNBT = $this$mapTo$iv$iv;
        int n = ((INBT)iNBT).length;
        for (int i = 0; i < n; ++i) {
            void it;
            INBT item$iv$iv;
            INBT iNBT2 = item$iv$iv = iNBT[i];
            collection = destination$iv$iv3;
            boolean bl6 = false;
            compoundNBT = (BlockState)blockMapBlocks.get((int)it);
            collection.add(compoundNBT);
        }
        $this$map$iv3 = (List)destination$iv$iv3;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        BlockState[] blockStateArray = thisCollection$iv.toArray(new BlockState[0]);
        if (blockStateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        BlockState[] blocks = blockStateArray;
        Intrinsics.checkNotNullExpressionValue(schematicName, "schematicName");
        Intrinsics.checkNotNullExpressionValue(tileEntities, "tileEntities");
        Intrinsics.checkNotNullExpressionValue(entities, "entities");
        return new CachedSchematic(schematicName, tileEntities, width, height, length, blocks, entities);
    }

    private final Schematic createOnDemand() {
        ResourceLocation resourceLocation = this.resourceLocation;
        Intrinsics.checkNotNull(resourceLocation);
        String schematicName = FilenameUtils.getBaseName((String)resourceLocation.func_110623_a());
        ResourceLocation resourceLocation2 = this.resourceLocation;
        Intrinsics.checkNotNull(resourceLocation2);
        String string = resourceLocation2.func_110624_b();
        resourceLocation2 = this.resourceLocation;
        Intrinsics.checkNotNull(resourceLocation2);
        ResourceLocation metaLocation = new ResourceLocation(string, Intrinsics.stringPlus(resourceLocation2.func_110623_a(), ".meta"));
        InputStream inputStream = ResourceUtil.INSTANCE.getInputStream(metaLocation);
        CompoundNBT nbtData = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        short width = nbtData.func_74765_d("width");
        short height = nbtData.func_74765_d("height");
        short length = nbtData.func_74765_d("length");
        ResourceLocation resourceLocation3 = this.resourceLocation;
        Intrinsics.checkNotNull(resourceLocation3);
        Intrinsics.checkNotNullExpressionValue(schematicName, "schematicName");
        return new OnDemandSchematic(resourceLocation3, schematicName, width, height, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean bl;
        Companion = new Companion(null);
        LOG = LogManager.getLogger();
        File clientConfig = new File(((Object)FMLPaths.CONFIGDIR.get()).toString(), "afraidofthedark-common.toml");
        try {
            Boolean bl2;
            Closeable closeable = new FileInputStream(clientConfig);
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl5 = false;
                bl2 = (Boolean)((CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)it)).get("world_generation.cache_structures");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Boolean bl6 = bl2;
            Intrinsics.checkNotNullExpressionValue(bl6, "{\n                FileInputStream(clientConfig).use {\n                    TomlFormat.instance().createParser().parse(it).get(\"world_generation.cache_structures\")\n                }\n            }");
            bl = bl6;
        }
        catch (Throwable e) {
            LOG.warn("Could not parse 'afraidofthedark-common-toml', defaulting to 'cache_structures = true'");
            bl = true;
        }
        USE_CACHE = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/schematic/SchematicBuilder$Companion;", "", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "USE_CACHE", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

