/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod;

import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.AOTDSpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.helper.TargetType;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.DoubleSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.EnumSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0016J\u0014\u0010\u000f\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bJ\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0016J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bJ\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0014\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u0015\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/AOESpellDeliveryMethod;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/AOTDSpellDeliveryMethod;", "()V", "defaultEffectProc", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "effect", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "executeDelivery", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/SpellDeliveryMethod;", "getRadius", "getStageCostMultiplier", "getTargetType", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/helper/TargetType;", "performDefaultTransition", "setRadius", "radius", "Companion", "afraidofthedark"})
public final class AOESpellDeliveryMethod
extends AOTDSpellDeliveryMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_RADIUS = "radius";
    @NotNull
    private static final String NBT_TARGET_TYPE = "target_type";

    public AOESpellDeliveryMethod() {
        super(new ResourceLocation("afraidofthedark", "aoe"));
        this.addEditableProperty(((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.doubleProperty().withName("Radius")).withDescription("The area of effect radius in blocks.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(3.0)).withMinValue(1.0)).withMaxValue(20.0)).build());
        SpellComponentPropertyFactory this_$iv = SpellComponentPropertyFactory.INSTANCE;
        boolean $i$f$enumProperty = false;
        T[] TArray = TargetType.class.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, "T::class.java.enumConstants");
        this.addEditableProperty(((EnumSpellComponentPropertyBuilder)((EnumSpellComponentPropertyBuilder)((EnumSpellComponentPropertyBuilder)((EnumSpellComponentPropertyBuilder)((EnumSpellComponentPropertyBuilder)new EnumSpellComponentPropertyBuilder((Enum[])TArray).withName("Target Type")).withDescription("Should be either 'entity' or 'block'. If the target type is 'block' all nearby blocks will be affected, if it is 'entity' all nearby entities will be affected.")).withSetter(3.INSTANCE)).withGetter(4.INSTANCE)).withDefaultValue(TargetType.BLOCK)).build());
    }

    @Override
    public void executeDelivery(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.procEffects(state);
        this.transitionFrom(state);
    }

    @Override
    public void defaultEffectProc(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> effect) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(effect, "effect");
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
        Intrinsics.checkNotNull(spellComponentInstance);
        double radius = this.getRadius(spellComponentInstance);
        spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
        Intrinsics.checkNotNull(spellComponentInstance);
        if (this.getTargetType(spellComponentInstance) == TargetType.ENTITY) {
            List entitiesWithinAABB = state.getWorld().func_217357_a(Entity.class, new AxisAlignedBB(new BlockPos(state.getPosition())).func_186662_g(radius));
            Intrinsics.checkNotNullExpressionValue(entitiesWithinAABB, "entitiesWithinAABB");
            Iterable $this$forEach$iv = entitiesWithinAABB;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity it = (Entity)element$iv;
                boolean bl = false;
                DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(state.getStageIndex()).withCasterEntity(state.getCasterEntity());
                Intrinsics.checkNotNull(it);
                SpellEffect.procEffect$default(effect.getComponent(), deliveryTransitionStateBuilder.withEntity(it).build(), effect, false, 4, null);
            }
        } else {
            BlockPos basePos = new BlockPos(state.getPosition());
            boolean $i$f$forEach = false;
            int blockRadius = (int)Math.floor(radius);
            DeliveryTransitionStateBuilder transitionBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(state.getStageIndex()).withWorld((World)state.getWorld()).withCasterEntity(state.getCasterEntity());
            int n = -blockRadius;
            if (n <= blockRadius) {
                int x;
                do {
                    int y;
                    x = n++;
                    int n2 = -blockRadius;
                    if (n2 > blockRadius) continue;
                    do {
                        int z;
                        y = n2++;
                        int n3 = -blockRadius;
                        if (n3 > blockRadius) continue;
                        do {
                            BlockPos aoePos;
                            if (!((aoePos = basePos.func_177982_a(x, y, z = n3++)).func_177951_i((Vec3i)basePos) < radius * radius)) continue;
                            DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = transitionBuilder.withPosition(new Vec3d((double)aoePos.func_177958_n(), (double)aoePos.func_177956_o(), (double)aoePos.func_177952_p()));
                            Intrinsics.checkNotNullExpressionValue(aoePos, "aoePos");
                            DeliveryTransitionStateBuilder deliveryTransitionStateBuilder2 = deliveryTransitionStateBuilder.withBlockPosition(aoePos);
                            Vec3d vec3d = new Vec3d(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).func_72432_b();
                            Intrinsics.checkNotNullExpressionValue(vec3d, "Vec3d(\n                                            Math.random() - 0.5,\n                                            Math.random() - 0.5,\n                                            Math.random() - 0.5\n                                        ).normalize()");
                            effect.getComponent().procEffect(deliveryTransitionStateBuilder2.withDirection(vec3d).build(), effect, true);
                        } while (z != blockRadius);
                    } while (y != blockRadius);
                } while (x != blockRadius);
            }
        }
    }

    @Override
    public void performDefaultTransition(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        Spell spell = state.getSpell();
        int spellIndex = state.getStageIndex();
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
        Intrinsics.checkNotNull(spellComponentInstance);
        if (this.getTargetType(spellComponentInstance) == TargetType.ENTITY) {
            ServerWorld serverWorld = state.getWorld();
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB(new BlockPos(state.getPosition()));
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance2 = state.getCurrentStage().getDeliveryInstance();
            Intrinsics.checkNotNull(spellComponentInstance2);
            List entitiesWithinAABB = serverWorld.func_217357_a(Entity.class, axisAlignedBB.func_186662_g(this.getRadius(spellComponentInstance2)));
            Intrinsics.checkNotNullExpressionValue(entitiesWithinAABB, "entitiesWithinAABB");
            Iterable $this$forEach$iv = entitiesWithinAABB;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity it = (Entity)element$iv;
                boolean bl = false;
                SpellStage spellStage = spell.getStage(spellIndex + 1);
                Intrinsics.checkNotNull(spellStage);
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance3 = spellStage.getDeliveryInstance();
                Intrinsics.checkNotNull(spellComponentInstance3);
                DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(spellIndex + 1).withCasterEntity(state.getCasterEntity());
                Intrinsics.checkNotNull(it);
                spellComponentInstance3.getComponent().executeDelivery(deliveryTransitionStateBuilder.withEntity(it).build());
            }
        } else {
            DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(spellIndex + 1).withWorld((World)state.getWorld()).withBlockPosition(state.getBlockPosition()).withCasterEntity(state.getCasterEntity());
            Object $i$f$forEach = new Vec3d[]{new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(-1.0, 0.0, 0.0), new Vec3d(0.0, -1.0, 0.0), new Vec3d(0.0, 0.0, -1.0)};
            $i$f$forEach = CollectionsKt.mutableListOf($i$f$forEach);
            boolean bl = false;
            boolean bl2 = false;
            Object $this$performDefaultTransition_u24lambda_u2d2 = $i$f$forEach;
            boolean bl3 = false;
            Object object = $this$performDefaultTransition_u24lambda_u2d2;
            boolean bl4 = false;
            Collections.shuffle(object);
            List cardinalDirections = CollectionsKt.toList((Iterable)$i$f$forEach);
            Iterable $this$forEach$iv = cardinalDirections;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Vec3d it = (Vec3d)element$iv;
                boolean bl5 = false;
                SpellStage spellStage = spell.getStage(spellIndex + 1);
                Intrinsics.checkNotNull(spellStage);
                Vec3d vec3d = spellStage.getDeliveryInstance();
                Intrinsics.checkNotNull(vec3d);
                vec3d = state.getPosition().func_178787_e(it.func_186678_a(0.2));
                Intrinsics.checkNotNullExpressionValue(vec3d, "state.position.add(it.scale(0.2))");
                vec3d.getComponent().executeDelivery(deliveryTransitionStateBuilder.withPosition(vec3d).withDirection(it).build());
            }
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return (double)20 + this.getRadius(instance) * this.getRadius(instance) * this.getRadius(instance);
    }

    @Override
    public double getStageCostMultiplier(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return 6.0;
    }

    public final void setRadius(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance, double radius) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        instance.getData().func_74780_a(NBT_RADIUS, radius);
    }

    public final double getRadius(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74769_h(NBT_RADIUS);
    }

    @NotNull
    public final TargetType getTargetType(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return TargetType.values()[instance.getData().func_74762_e(NBT_TARGET_TYPE)];
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/AOESpellDeliveryMethod$Companion;", "", "()V", "NBT_RADIUS", "", "NBT_TARGET_TYPE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

