/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.AOTDSpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.property.LongSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0014\u0010\f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\u000e\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/DelaySpellDeliveryMethod;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/AOTDSpellDeliveryMethod;", "()V", "executeDelivery", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/SpellDeliveryMethod;", "getDelay", "", "getStageCostMultiplier", "Companion", "afraidofthedark"})
public final class DelaySpellDeliveryMethod
extends AOTDSpellDeliveryMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_DELAY = "delay";

    public DelaySpellDeliveryMethod() {
        super(new ResourceLocation("afraidofthedark", NBT_DELAY));
        this.addEditableProperty(((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.longProperty().withName("Delay")).withDescription("The delay of the delivery in ticks (20 ticks = 1 second).")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(20L)).withMinValue(1L)).build());
    }

    @Override
    public void executeDelivery(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        CapabilityExtensionsKt.getSpellStates((World)state.getWorld()).addDelayedDelivery(state);
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return (double)10 + (double)this.getDelay(instance) / 10.0;
    }

    @Override
    public double getStageCostMultiplier(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return 1.5;
    }

    public final long getDelay(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74763_f(NBT_DELAY);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/DelaySpellDeliveryMethod$Companion;", "", "()V", "NBT_DELAY", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

