/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod;

import com.davidm1a2.afraidofthedark.common.entity.spell.projectile.SpellProjectileEntity;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.AOTDSpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.property.DoubleSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentProperty;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0014\u0010\u000e\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u000f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0012\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\bJ\u001c\u0010\u0014\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\rJ\u001c\u0010\u0016\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\r\u00a8\u0006\u0019"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/ProjectileSpellDeliveryMethod;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/AOTDSpellDeliveryMethod;", "()V", "executeDelivery", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "getColor", "Ljava/awt/Color;", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/SpellDeliveryMethod;", "getCost", "", "getRange", "getSpeed", "getStageCostMultiplier", "performDefaultTransition", "setColor", "color", "setRange", "range", "setSpeed", "speed", "Companion", "afraidofthedark"})
public final class ProjectileSpellDeliveryMethod
extends AOTDSpellDeliveryMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_SPEED = "speed";
    @NotNull
    private static final String NBT_RANGE = "range";
    @NotNull
    private static final String NBT_COLOR = "color";

    public ProjectileSpellDeliveryMethod() {
        super(new ResourceLocation("afraidofthedark", "projectile"));
        this.addEditableProperty(((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.doubleProperty().withName("Range")).withDescription("The range of the projectile in blocks.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(50.0)).withMinValue(1.0)).withMaxValue(300.0)).build());
        this.addEditableProperty(((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)((DoubleSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.doubleProperty().withName("Speed")).withDescription("The speed of the projectile in blocks/tick.")).withSetter(3.INSTANCE)).withGetter(4.INSTANCE)).withDefaultValue(0.6)).withMinValue(0.0)).withMaxValue(10.0)).build());
        this.addEditableProperty(new SpellComponentProperty("Color", "The color of the projectile in the format 'r g b' where red, green, and blue are values between 0 and 255", 5.INSTANCE, 6.INSTANCE, 7.INSTANCE));
    }

    @Override
    public void executeDelivery(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        SpellProjectileEntity spellProjectile = new SpellProjectileEntity((World)state.getWorld(), state.getSpell(), state.getStageIndex(), state.getCasterEntity(), state.getPosition(), state.getDirection(), state.getEntity());
        state.getWorld().func_217376_c((Entity)spellProjectile);
    }

    @Override
    public void performDefaultTransition(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        Spell spell = state.getSpell();
        int spellIndex = state.getStageIndex();
        SpellStage spellStage = spell.getStage(spellIndex + 1);
        Intrinsics.checkNotNull(spellStage);
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = spellStage.getDeliveryInstance();
        Intrinsics.checkNotNull(spellComponentInstance);
        spellComponentInstance.getComponent().executeDelivery(new DeliveryTransitionStateBuilder().copyOf(state).withStageIndex(spellIndex + 1).withDeliveryEntity(null).build());
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return (double)5 + this.getSpeed(instance) + this.getRange(instance) / 15.0;
    }

    @Override
    public double getStageCostMultiplier(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return 1.5;
    }

    public final void setSpeed(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance, double speed) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        instance.getData().func_74780_a(NBT_SPEED, speed);
    }

    public final double getSpeed(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74769_h(NBT_SPEED);
    }

    public final void setRange(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance, double range) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        instance.getData().func_74780_a(NBT_RANGE, range);
    }

    public final double getRange(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return instance.getData().func_74769_h(NBT_RANGE);
    }

    public final void setColor(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        Intrinsics.checkNotNullParameter(color, NBT_COLOR);
        instance.getData().func_74778_a(NBT_COLOR, "" + color.getRed() + ' ' + color.getGreen() + ' ' + color.getBlue());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Color getColor(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(instance, "instance");
        CharSequence charSequence = instance.getData().func_74779_i(NBT_COLOR);
        Intrinsics.checkNotNullExpressionValue(charSequence, "instance.data.getString(NBT_COLOR)");
        charSequence = charSequence;
        Regex regex = new Regex("\\s+");
        int n = 0;
        boolean bl = false;
        Iterable $this$map$iv = regex.split(charSequence, n);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var12_14 = it;
            boolean bl3 = false;
            Integer n2 = Integer.parseInt((String)var12_14);
            collection.add(n2);
        }
        List rgb = (List)destination$iv$iv;
        return new Color(((Number)rgb.get(0)).intValue(), ((Number)rgb.get(1)).intValue(), ((Number)rgb.get(2)).intValue());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/ProjectileSpellDeliveryMethod$Companion;", "", "()V", "NBT_COLOR", "", "NBT_RANGE", "NBT_SPEED", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

