/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.component.IPlayerSpellCharmData;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.IntSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/CharmSpellEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "getCharmDuration", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getCost", "", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "reducedParticles", "", "setCharmDuration", "duration", "Companion", "afraidofthedark"})
public final class CharmSpellEffect
extends AOTDSpellEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_CHARM_DURATION = "charm_duration";

    public CharmSpellEffect() {
        super(new ResourceLocation("afraidofthedark", "charm"));
        this.addEditableProperty(((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)((IntSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.intProperty().withName("Charm Duration")).withDescription("The number of ticks to charm to when hitting players.")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(40)).withMinValue(1)).withMaxValue(1200)).build());
    }

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance, boolean reducedParticles) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(instance, "instance");
        Entity entity = state.getEntity();
        Entity spellOwner = state.getCasterEntity();
        if (entity instanceof AnimalEntity) {
            ((AnimalEntity)entity).func_146082_f(spellOwner instanceof PlayerEntity ? (PlayerEntity)spellOwner : null);
        } else if (entity instanceof PlayerEntity && spellOwner != null) {
            IPlayerSpellCharmData spellCharmData = CapabilityExtensionsKt.getSpellCharmData((PlayerEntity)entity);
            spellCharmData.setCharmTicks(this.getCharmDuration(instance));
            spellCharmData.setCharmingEntityId(spellOwner.func_110124_au());
            ThreadLocalRandom random = ThreadLocalRandom.current();
            double width = ((PlayerEntity)entity).func_213311_cf();
            double height = ((PlayerEntity)entity).func_213302_cg();
            int n = 0;
            do {
                int i = n++;
                state.getWorld().func_195598_a((IParticleData)ParticleTypes.field_197633_z, state.getPosition().field_72450_a + (double)random.nextFloat() * width * (double)2.0f - width, state.getPosition().field_72448_b + 0.5 + (double)random.nextFloat() * height, state.getPosition().field_72449_c + (double)random.nextFloat() * width * (double)2.0f - width, 1, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02, 0.02);
            } while (n <= 3);
        }
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        double charmDuration = (double)this.getCharmDuration(instance) / 20.0;
        return 25.0 + charmDuration * charmDuration * 5.0;
    }

    public final void setCharmDuration(@NotNull SpellComponentInstance<SpellEffect> instance, int duration) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        instance.getData().func_74768_a(NBT_CHARM_DURATION, duration);
    }

    private final int getCharmDuration(SpellComponentInstance<SpellEffect> instance) {
        return instance.getData().func_74762_e(NBT_CHARM_DURATION);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/CharmSpellEffect$Companion;", "", "()V", "NBT_CHARM_DURATION", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

