/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.utility;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.SaveHandler;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001d\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010'\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010*\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010+\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\fJ\u001e\u0010-\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0014J\u001e\u0010.\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\bJ\u001e\u0010/\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0018J\u001e\u00100\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u001bJ\u001e\u00101\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u001eJ\u001e\u00102\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020!J\u001e\u00103\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020$J\u001e\u00104\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/davidm1a2/afraidofthedark/common/utility/NBTHelper;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getAllSavedPlayerNBTs", "", "Lnet/minecraft/nbt/CompoundNBT;", "minecraftServer", "Lnet/minecraft/server/MinecraftServer;", "saveFirst", "", "getBoolean", "itemStack", "Lnet/minecraft/item/ItemStack;", "keyName", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Boolean;", "getByte", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Byte;", "getCompound", "getDouble", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Double;", "getFloat", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Float;", "getInteger", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Integer;", "getLong", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Long;", "getShort", "", "(Lnet/minecraft/item/ItemStack;Ljava/lang/String;)Ljava/lang/Short;", "getString", "hasTag", "initNBTTagCompound", "", "removeTag", "setBoolean", "keyValue", "setByte", "setCompound", "setDouble", "setFloat", "setInteger", "setLong", "setShort", "setString", "afraidofthedark"})
public final class NBTHelper {
    @NotNull
    public static final NBTHelper INSTANCE = new NBTHelper();
    private static final Logger logger = LogManager.getLogger();

    private NBTHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<CompoundNBT> getAllSavedPlayerNBTs(@NotNull MinecraftServer minecraftServer, boolean saveFirst) {
        Intrinsics.checkNotNullParameter(minecraftServer, "minecraftServer");
        if (saveFirst) {
            minecraftServer.func_184103_al().func_72389_g();
        }
        boolean bl = false;
        List toReturn = new ArrayList();
        SaveHandler saveHandler = minecraftServer.func_71218_a(DimensionType.field_223227_a_).func_217485_w();
        File playerDataDirectory = new File(saveHandler.func_75765_b(), "playerdata");
        String[] stringArray = saveHandler.func_215771_d();
        Intrinsics.checkNotNullExpressionValue(stringArray, "saveHandler.func_215771_d()");
        String[] stringArray2 = stringArray;
        int n = 0;
        int n2 = stringArray2.length;
        while (n < n2) {
            String playerUUID = stringArray2[n];
            ++n;
            File playerData = new File(playerDataDirectory, Intrinsics.stringPlus(playerUUID, ".dat"));
            if (!playerData.exists() || !playerData.isFile() || !playerData.canRead()) continue;
            try {
                Closeable closeable = new FileInputStream(playerData);
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)closeable;
                    boolean bl4 = false;
                    CompoundNBT playerDataCompound = CompressedStreamTools.func_74796_a((InputStream)it);
                    Intrinsics.checkNotNullExpressionValue(playerDataCompound, "playerDataCompound");
                    boolean bl5 = toReturn.add(playerDataCompound);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e) {
                logger.error("Could not read player data for file " + playerData.getAbsolutePath() + ", exception was:\n" + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return toReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasTag(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (itemStack.func_77978_p() == null) return false;
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        if (!compoundNBT.func_74764_b(keyName)) return false;
        return true;
    }

    public final void removeTag(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            compoundNBT.func_82580_o(keyName);
        }
    }

    private final void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new CompoundNBT());
        }
    }

    public final void setLong(@NotNull ItemStack itemStack, @NotNull String keyName, long keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74772_a(keyName, keyValue);
    }

    @Nullable
    public final Long getLong(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Long l;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            l = compoundNBT.func_74763_f(keyName);
        } else {
            l = null;
        }
        return l;
    }

    public final void setString(@NotNull ItemStack itemStack, @NotNull String keyName, @NotNull String keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        Intrinsics.checkNotNullParameter(keyValue, "keyValue");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74778_a(keyName, keyValue);
    }

    @Nullable
    public final String getString(@NotNull ItemStack itemStack, @NotNull String keyName) {
        String string;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            string = compoundNBT.func_74779_i(keyName);
        } else {
            string = null;
        }
        return string;
    }

    public final void setBoolean(@NotNull ItemStack itemStack, @NotNull String keyName, boolean keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74757_a(keyName, keyValue);
    }

    @Nullable
    public final Boolean getBoolean(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Boolean bl;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            bl = compoundNBT.func_74767_n(keyName);
        } else {
            bl = null;
        }
        return bl;
    }

    public final void setByte(@NotNull ItemStack itemStack, @NotNull String keyName, byte keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74774_a(keyName, keyValue);
    }

    @Nullable
    public final Byte getByte(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Byte by;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            by = compoundNBT.func_74771_c(keyName);
        } else {
            by = null;
        }
        return by;
    }

    public final void setShort(@NotNull ItemStack itemStack, @NotNull String keyName, short keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74777_a(keyName, keyValue);
    }

    @Nullable
    public final Short getShort(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Short s;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            s = compoundNBT.func_74765_d(keyName);
        } else {
            s = null;
        }
        return s;
    }

    public final void setInteger(@NotNull ItemStack itemStack, @NotNull String keyName, int keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74768_a(keyName, keyValue);
    }

    @Nullable
    public final Integer getInteger(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Integer n;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            n = compoundNBT.func_74762_e(keyName);
        } else {
            n = null;
        }
        return n;
    }

    public final void setFloat(@NotNull ItemStack itemStack, @NotNull String keyName, float keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74776_a(keyName, keyValue);
    }

    @Nullable
    public final Float getFloat(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Float f;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            f = Float.valueOf(compoundNBT.func_74760_g(keyName));
        } else {
            f = null;
        }
        return f;
    }

    public final void setDouble(@NotNull ItemStack itemStack, @NotNull String keyName, double keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_74780_a(keyName, keyValue);
    }

    @Nullable
    public final Double getDouble(@NotNull ItemStack itemStack, @NotNull String keyName) {
        Double d;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT);
            d = compoundNBT.func_74769_h(keyName);
        } else {
            d = null;
        }
        return d;
    }

    public final void setCompound(@NotNull ItemStack itemStack, @NotNull String keyName, @NotNull CompoundNBT keyValue) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        Intrinsics.checkNotNullParameter(keyValue, "keyValue");
        this.initNBTTagCompound(itemStack);
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        Intrinsics.checkNotNull(compoundNBT);
        compoundNBT.func_218657_a(keyName, (INBT)keyValue);
    }

    @Nullable
    public final CompoundNBT getCompound(@NotNull ItemStack itemStack, @NotNull String keyName) {
        CompoundNBT compoundNBT;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        if (this.hasTag(itemStack, keyName)) {
            CompoundNBT compoundNBT2 = itemStack.func_77978_p();
            Intrinsics.checkNotNull(compoundNBT2);
            compoundNBT = compoundNBT2.func_74775_l(keyName);
        } else {
            compoundNBT = null;
        }
        return compoundNBT;
    }
}

