/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.layout;

import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDPane;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000J\u0013\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/layout/Position;", "", "x", "", "y", "isRelative", "", "(DDZ)V", "()Z", "getX", "()D", "getY", "avg", "secondPoint", "equals", "other", "getAbsolute", "reference", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/AOTDPane;", "getRelative", "toDimension", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;", "afraidofthedark"})
public final class Position {
    private final double x;
    private final double y;
    private final boolean isRelative;

    public Position(double x, double y, boolean isRelative) {
        this.x = x;
        this.y = y;
        this.isRelative = isRelative;
    }

    public /* synthetic */ Position(double d, double d2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(d, d2, bl);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final boolean isRelative() {
        return this.isRelative;
    }

    @NotNull
    public final Position getAbsolute(@NotNull AOTDPane reference) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        return this.isRelative ? new Position(this.x * reference.getInternalWidth(), this.y * reference.getInternalHeight(), false) : new Position(this.x, this.y, false);
    }

    @NotNull
    public final Position getRelative(@NotNull AOTDPane reference) {
        Position position;
        Intrinsics.checkNotNullParameter(reference, "reference");
        if (this.isRelative) {
            position = new Position(this.x, this.y, true);
        } else {
            double internalWidth = reference.getInternalWidth();
            double internalHeight = reference.getInternalHeight();
            position = new Position(internalWidth == 0.0 ? 0.0 : this.x / reference.getInternalWidth(), internalHeight == 0.0 ? 0.0 : this.y / reference.getInternalHeight(), true);
        }
        return position;
    }

    @NotNull
    public final Dimensions toDimension(@NotNull Position secondPoint) {
        Intrinsics.checkNotNullParameter(secondPoint, "secondPoint");
        boolean bl = this.isRelative == secondPoint.isRelative;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return new Dimensions(secondPoint.x - this.x, secondPoint.y - this.y, false, 4, null);
    }

    @NotNull
    public final Position avg(@NotNull Position secondPoint) {
        Intrinsics.checkNotNullParameter(secondPoint, "secondPoint");
        boolean bl = this.isRelative == secondPoint.isRelative;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return new Position((this.x + secondPoint.x) / (double)2, (this.y + secondPoint.y) / (double)2, false, 4, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Position && ((Position)other).isRelative == this.isRelative && ((Position)other).x == this.x && ((Position)other).y == ((Position)other).y;
    }

    public Position() {
        this(0.0, 0.0, false, 7, null);
    }
}

