/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.screens;

import com.davidm1a2.afraidofthedark.client.gui.customControls.ResearchConnector;
import com.davidm1a2.afraidofthedark.client.gui.customControls.ResearchNode;
import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.layout.Gravity;
import com.davidm1a2.afraidofthedark.client.gui.layout.Position;
import com.davidm1a2.afraidofthedark.client.gui.layout.Spacing;
import com.davidm1a2.afraidofthedark.client.gui.layout.TextAlignment;
import com.davidm1a2.afraidofthedark.client.gui.screens.AOTDScreen;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDGuiComponent;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ImagePane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.LabelComponent;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.RatioPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ScrollPane;
import com.davidm1a2.afraidofthedark.client.settings.ClientData;
import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.research.Research;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/screens/BloodStainedJournalResearchScreen;", "Lcom/davidm1a2/afraidofthedark/client/gui/screens/AOTDScreen;", "isCheatSheet", "", "(Z)V", "backgroundBorder", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ImagePane;", "ratioPane", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/RatioPane;", "researchTreeBase", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ScrollPane;", "scrollBackground", "addConnector", "", "research", "Lcom/davidm1a2/afraidofthedark/common/research/Research;", "addResearchButton", "drawGradientBackground", "invalidate", "inventoryToCloseGuiScreen", "removed", "Companion", "afraidofthedark"})
public final class BloodStainedJournalResearchScreen
extends AOTDScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isCheatSheet;
    @NotNull
    private final ScrollPane researchTreeBase;
    @NotNull
    private final ImagePane scrollBackground;
    @NotNull
    private final ImagePane backgroundBorder;
    @NotNull
    private final RatioPane ratioPane;
    private static final double RESEARCH_HEIGHT = 0.06;
    private static final double RESEARCH_WIDTH = 0.06;
    private static final double TREE_WIDTH = 12.0;
    private static final double TREE_HEIGHT = 12.0;
    @NotNull
    private static Position scrollOffset = new Position(-0.25, -0.25, false, 4, null);

    public BloodStainedJournalResearchScreen(boolean isCheatSheet) {
        super((ITextComponent)new TranslationTextComponent("screen.afraidofthedark.blood_stained_journal_research"), false, 2, null);
        Research it;
        Object lblCheatSheet;
        this.isCheatSheet = isCheatSheet;
        this.researchTreeBase = new ScrollPane(2.0, 2.0, scrollOffset);
        this.scrollBackground = new ImagePane(new ResourceLocation("afraidofthedark:textures/gui/journal_tech_tree/background.png"), null, 2, null);
        this.backgroundBorder = new ImagePane(new ResourceLocation("afraidofthedark:textures/gui/journal_tech_tree/frame.png"), ImagePane.DispMode.FIT_TO_PARENT);
        this.ratioPane = new RatioPane(1, 1);
        this.ratioPane.add(this.researchTreeBase);
        this.getContentPane().add(this.ratioPane);
        this.getContentPane().add(this.backgroundBorder);
        this.getContentPane().setPadding(new Spacing(0.125, false, 2, null));
        this.ratioPane.setGravity(Gravity.CENTER);
        this.backgroundBorder.setGravity(Gravity.CENTER);
        this.researchTreeBase.add(this.scrollBackground);
        if (this.isCheatSheet) {
            lblCheatSheet = new LabelComponent(ClientData.INSTANCE.getOrCreate(32.0f), new Dimensions(1.0, 0.08, false, 4, null), null, 4, null);
            ((LabelComponent)lblCheatSheet).setTextAlignment(TextAlignment.ALIGN_CENTER);
            ((LabelComponent)lblCheatSheet).setTextColor(new Color(255, 255, 255));
            ((LabelComponent)lblCheatSheet).setText("Cheat sheet - select researches to unlock them");
            this.backgroundBorder.add((AOTDGuiComponent)lblCheatSheet);
        }
        lblCheatSheet = ModRegistries.INSTANCE.getRESEARCH().getValues();
        Intrinsics.checkNotNullExpressionValue(lblCheatSheet, "ModRegistries.RESEARCH.values");
        Iterable $this$forEach$iv = (Iterable)lblCheatSheet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Research)((Object)element$iv);
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, "it");
            this.addConnector(it);
        }
        $this$forEach$iv = ModRegistries.INSTANCE.getRESEARCH().getValues();
        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, "ModRegistries.RESEARCH.values");
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Research)((Object)element$iv);
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, "it");
            this.addResearchButton(it);
        }
    }

    @Override
    public void invalidate() {
        this.researchTreeBase.checkOutOfBounds();
        super.invalidate();
    }

    private final void addConnector(Research research) {
        Research research2 = research.getPreRequisite();
        if (research2 == null) {
            return;
        }
        Research previous = research2;
        Position pos = new Position((double)research.getXPosition() / 12.0, (double)(research.getYPosition() - 4) / 12.0, false, 4, null);
        Position prevPos = new Position((double)previous.getXPosition() / 12.0, (double)(previous.getYPosition() - 4) / 12.0, false, 4, null);
        this.researchTreeBase.add(new ResearchConnector(prevPos, pos, research));
    }

    private final void addResearchButton(Research research) {
        Position pos = new Position((double)research.getXPosition() / 12.0, (double)(research.getYPosition() - 4) / 12.0, false, 4, null);
        Dimensions dim = new Dimensions(0.06, 0.06, false, 4, null);
        ResearchNode researchNode = new ResearchNode(dim, pos, research, this.isCheatSheet);
        this.researchTreeBase.add(researchNode);
    }

    @Override
    public boolean inventoryToCloseGuiScreen() {
        return true;
    }

    @Override
    public boolean drawGradientBackground() {
        return true;
    }

    public void func_231164_f_() {
        scrollOffset = this.researchTreeBase.getCurrentOffset().getRelative(this.researchTreeBase);
        super.func_231164_f_();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/screens/BloodStainedJournalResearchScreen$Companion;", "", "()V", "RESEARCH_HEIGHT", "", "RESEARCH_WIDTH", "TREE_HEIGHT", "TREE_WIDTH", "scrollOffset", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Position;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

