/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.block;

import com.davidm1a2.afraidofthedark.common.block.core.AOTDTileEntityBlock;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.tileEntity.EnariaSpawnerTileEntity;
import com.davidm1a2.afraidofthedark.common.tileEntity.GhastlyEnariaSpawnerTileEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/EnariaSpawnerBlock;", "Lcom/davidm1a2/afraidofthedark/common/block/core/AOTDTileEntityBlock;", "()V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/state/StateContainer$Builder;", "Lnet/minecraft/block/Block;", "Lnet/minecraft/block/BlockState;", "displayInCreative", "", "getRenderShape", "Lnet/minecraft/block/BlockRenderType;", "state", "getStateForPlacement", "context", "Lnet/minecraft/item/BlockItemUseContext;", "mirror", "mirrorIn", "Lnet/minecraft/util/Mirror;", "newBlockEntity", "Lnet/minecraft/tileentity/TileEntity;", "world", "Lnet/minecraft/world/IBlockReader;", "rotate", "rotation", "Lnet/minecraft/util/Rotation;", "Lnet/minecraft/world/IWorld;", "pos", "Lnet/minecraft/util/math/BlockPos;", "Companion", "afraidofthedark"})
public final class EnariaSpawnerBlock
extends AOTDTileEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOGGER = LogManager.getLogger();

    public EnariaSpawnerBlock() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(10.0f, 50.0f).harvestLevel(3).harvestTool(ToolType.PICKAXE);
        Intrinsics.checkNotNullExpressionValue(properties, "of(Material.STONE)\n        .strength(10.0f, 50.0f)\n        .harvestLevel(3)\n        .harvestTool(ToolType.PICKAXE)");
        super("enaria_spawner", properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH));
    }

    @Override
    public boolean displayInCreative() {
        return false;
    }

    @NotNull
    public BlockRenderType func_149645_b(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        return BlockRenderType.MODEL;
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull IWorld world, @NotNull BlockPos pos, @NotNull Rotation rotation2) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(rotation2, "rotation");
        Object object = state.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)rotation2.func_185831_a((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)));
        Intrinsics.checkNotNullExpressionValue(object, "state.setValue(HorizontalBlock.FACING, rotation.rotate(state.getValue(HorizontalBlock.FACING)))");
        return (BlockState)object;
    }

    @NotNull
    public BlockState func_185499_a(@NotNull BlockState state, @NotNull Rotation rotation2) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(rotation2, "rotation");
        Object object = state.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)rotation2.func_185831_a((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)));
        Intrinsics.checkNotNullExpressionValue(object, "state.setValue(HorizontalBlock.FACING, rotation.rotate(state.getValue(HorizontalBlock.FACING)))");
        return (BlockState)object;
    }

    @NotNull
    public BlockState func_185471_a(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(mirrorIn, "mirrorIn");
        Object object = state.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)mirrorIn.func_185803_b((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)));
        Intrinsics.checkNotNullExpressionValue(object, "state.setValue(HorizontalBlock.FACING, mirrorIn.mirror(state.getValue(HorizontalBlock.FACING)))");
        return (BlockState)object;
    }

    @NotNull
    public BlockState func_196258_a(@NotNull BlockItemUseContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        Object object = this.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)context.func_195992_f());
        Intrinsics.checkNotNullExpressionValue(object, "this.defaultBlockState().setValue(HorizontalBlock.FACING, context.horizontalDirection)");
        return (BlockState)object;
    }

    protected void func_206840_a(@NotNull StateContainer.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Property[] propertyArray = new Property[]{(Property)HorizontalBlock.field_185512_D};
        builder.func_206894_a(propertyArray);
    }

    @Nullable
    public TileEntity func_196283_a_(@NotNull IBlockReader world) {
        TileEntity tileEntity;
        Intrinsics.checkNotNullParameter(world, "world");
        IBlockReader iBlockReader = world;
        if (!(iBlockReader instanceof World)) {
            throw new IllegalStateException(Intrinsics.stringPlus("Can't determine the world type for IBlockReader ", world.getClass().getSimpleName()));
        }
        RegistryKey dimType = ((World)world).func_234923_W_();
        iBlockReader = dimType;
        if (Intrinsics.areEqual(iBlockReader, World.field_234918_g_)) {
            tileEntity = new EnariaSpawnerTileEntity();
        } else if (Intrinsics.areEqual(iBlockReader, ModDimensions.INSTANCE.getNIGHTMARE_WORLD())) {
            tileEntity = new GhastlyEnariaSpawnerTileEntity();
        } else {
            LOGGER.warn("BlockEnariaSpawner should not exist in this dimension, defaulting to a NO-OP TileEntity.");
            tileEntity = null;
        }
        return tileEntity;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/EnariaSpawnerBlock$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

