/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import com.davidm1a2.afraidofthedark.client.sound.EerieEchoSound;
import com.davidm1a2.afraidofthedark.client.sound.NightmareChaseMusicSound;
import com.davidm1a2.afraidofthedark.client.sound.NightmareMusicSound;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IPlayerNightmareData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.RespawnPosition;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.constants.ModEffects;
import com.davidm1a2.afraidofthedark.common.constants.ModEntities;
import com.davidm1a2.afraidofthedark.common.constants.ModItems;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.dimension.IslandUtility;
import com.davidm1a2.afraidofthedark.common.dimension.PlayerTeleportExtensionsKt;
import com.davidm1a2.afraidofthedark.common.entity.enaria.GhastlyEnariaEntity;
import com.davidm1a2.afraidofthedark.common.event.custom.ManualResearchTriggerEvent;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.SchematicStructurePiece;
import java.util.Random;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0007J,\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010 \u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002\u00a8\u0006&"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/NightmareHandler;", "", "()V", "createNamedJournal", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "onChunkUnloadEvent", "", "event", "Lnet/minecraftforge/event/world/ChunkEvent$Unload;", "onEntityJoinWorldEvent", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "onNightmareWorldTick", "Lnet/minecraftforge/event/TickEvent$WorldTickEvent;", "onPlayerRespawnEvent", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerRespawnEvent;", "onPlayerSleepInBedEvent", "Lnet/minecraftforge/event/entity/player/PlayerSleepInBedEvent;", "onPostEntityTravelToDimension", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerChangedDimensionEvent;", "onPreEntityTravelToDimension", "Lnet/minecraftforge/event/entity/EntityTravelToDimensionEvent;", "processPostTeleport", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "dimensionFrom", "Lnet/minecraft/util/RegistryKey;", "Lnet/minecraft/world/World;", "dimensionTo", "processPreTeleport", "", "resetPlayerStats", "testForEnariasAltar", "nightmareWorld", "Lnet/minecraft/world/server/ServerWorld;", "islandPos", "Lnet/minecraft/util/math/BlockPos;", "Companion", "afraidofthedark"})
public final class NightmareHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int VALID_SPAWN_SEARCH_DISTANCE = 6;

    @SubscribeEvent
    public final void onNightmareWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        World world;
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER && Intrinsics.areEqual((world = event.world).func_234923_W_(), ModDimensions.INSTANCE.getNIGHTMARE_WORLD()) && world.func_82737_E() % (long)20 == 0L) {
            if (world == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.world.server.ServerWorld");
            }
            ((ServerWorld)world).getEntities().filter(NightmareHandler::onNightmareWorldTick$lambda-0).map(NightmareHandler::onNightmareWorldTick$lambda-1).filter(NightmareHandler::onNightmareWorldTick$lambda-2).forEach(arg_0 -> NightmareHandler.onNightmareWorldTick$lambda-3(world, arg_0));
        }
    }

    @SubscribeEvent
    public final void onPlayerSleepInBedEvent(@NotNull PlayerSleepInBedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        PlayerEntity entityPlayer = event.getPlayer();
        if (!entityPlayer.field_70170_p.field_72995_K && entityPlayer.func_193076_bZ().get((Object)ModEffects.INSTANCE.getSLEEPING()) != null) {
            Intrinsics.checkNotNullExpressionValue(entityPlayer, "entityPlayer");
            IPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(entityPlayer);
            MinecraftForge.EVENT_BUS.post((Event)new ManualResearchTriggerEvent(entityPlayer, ModResearches.INSTANCE.getNIGHTMARE()));
            if (playerResearch.isResearched(ModResearches.INSTANCE.getNIGHTMARE())) {
                event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
                PlayerTeleportExtensionsKt.teleport((ServerPlayerEntity)entityPlayer, ModDimensions.INSTANCE.getNIGHTMARE_WORLD());
            }
        }
    }

    @SubscribeEvent
    public final void onChunkUnloadEvent(@NotNull ChunkEvent.Unload event) {
        Intrinsics.checkNotNullParameter(event, "event");
        IWorld world = event.getWorld();
        if (!world.func_201670_d()) {
            IChunk chunk;
            if (!(world instanceof World)) {
                throw new IllegalStateException("Chunk unload event called with an IWorld that was not a world");
            }
            if (Intrinsics.areEqual(((World)world).func_234923_W_(), ModDimensions.INSTANCE.getNIGHTMARE_WORLD()) && (chunk = event.getChunk()) instanceof Chunk) {
                ClassInheritanceMultiMap[] classInheritanceMultiMapArray = ((Chunk)chunk).func_177429_s();
                Intrinsics.checkNotNullExpressionValue(classInheritanceMultiMapArray, "chunk.entitySections");
                ClassInheritanceMultiMap[] classInheritanceMultiMapArray2 = classInheritanceMultiMapArray;
                int n = 0;
                int n2 = classInheritanceMultiMapArray2.length;
                while (n < n2) {
                    ClassInheritanceMultiMap entityMap = classInheritanceMultiMapArray2[n];
                    ++n;
                    for (Entity entity : entityMap) {
                        if (!(entity instanceof GhastlyEnariaEntity) || !((GhastlyEnariaEntity)entity).func_70089_S()) continue;
                        entity.func_70106_y();
                        PlayerEntity entityPlayer = world.func_217362_a(entity, 500.0);
                        if (entityPlayer == null || !entityPlayer.func_70089_S()) continue;
                        Random random = entityPlayer.func_70681_au();
                        int offsetX = random.nextBoolean() ? random.nextInt(26) - 50 : random.nextInt(26) + 25;
                        int offsetZ = random.nextBoolean() ? random.nextInt(26) - 50 : random.nextInt(26) + 25;
                        double posX = entityPlayer.func_226277_ct_() + (double)offsetX;
                        double posZ = entityPlayer.func_226281_cx_() + (double)offsetZ;
                        GhastlyEnariaEntity newEnaria = new GhastlyEnariaEntity(ModEntities.INSTANCE.getGHASTLY_ENARIA(), (World)world);
                        newEnaria.setBenign(!CapabilityExtensionsKt.getResearch(entityPlayer).isResearched(ModResearches.INSTANCE.getENARIA()));
                        newEnaria.func_70107_b(posX, entityPlayer.func_226278_cu_(), posZ);
                        world.func_217376_c((Entity)newEnaria);
                        return;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public final void onPlayerRespawnEvent(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getPlayer().field_70170_p.field_72995_K && Intrinsics.areEqual(event.getPlayer().field_70170_p.func_234923_W_(), ModDimensions.INSTANCE.getNIGHTMARE_WORLD())) {
            RegistryKey<World> registryKey = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(registryKey, "event.player");
            IPlayerNightmareData nightmareData = CapabilityExtensionsKt.getNightmareData((PlayerEntity)registryKey);
            registryKey = event.getPlayer();
            if (registryKey == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
            }
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)registryKey;
            registryKey = nightmareData.getPreTeleportDimension();
            Intrinsics.checkNotNull(registryKey);
            PlayerTeleportExtensionsKt.teleport(serverPlayerEntity, registryKey);
        }
    }

    @SubscribeEvent
    public final void onEntityJoinWorldEvent(@NotNull EntityJoinWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getWorld().field_72995_K) {
            Entity entity = event.getEntity();
            if (Intrinsics.areEqual(event.getWorld().func_234923_W_(), ModDimensions.INSTANCE.getNIGHTMARE_WORLD()) && Intrinsics.areEqual(entity, Minecraft.func_71410_x().field_71439_g) && Intrinsics.areEqual(entity.field_70170_p.func_234923_W_(), ModDimensions.INSTANCE.getNIGHTMARE_WORLD())) {
                SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
                soundHandler.func_147681_a((ISound)new EerieEchoSound(), 60);
                soundHandler.func_147681_a((ISound)new NightmareMusicSound(), 140);
                soundHandler.func_147681_a((ISound)new NightmareChaseMusicSound(), 140);
            }
        }
    }

    @SubscribeEvent
    public final void onPreEntityTravelToDimension(@NotNull EntityTravelToDimensionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getEntity().field_70170_p.field_72995_K) {
            RegistryKey fromDimension = event.getEntity().field_70170_p.func_234923_W_();
            RegistryKey toDimension = event.getDimension();
            if (event.getEntity() instanceof ServerPlayerEntity) {
                Entity entity = event.getEntity();
                if (entity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
                }
                ServerPlayerEntity entityPlayer = (ServerPlayerEntity)entity;
                Intrinsics.checkNotNullExpressionValue(fromDimension, "fromDimension");
                Intrinsics.checkNotNullExpressionValue(toDimension, "toDimension");
                if (this.processPreTeleport(entityPlayer, (RegistryKey<World>)fromDimension, (RegistryKey<World>)toDimension)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private final boolean processPreTeleport(ServerPlayerEntity entityPlayer, RegistryKey<World> dimensionFrom, RegistryKey<World> dimensionTo) {
        if (Intrinsics.areEqual(dimensionTo, ModDimensions.INSTANCE.getNIGHTMARE_WORLD())) {
            World world;
            if (Intrinsics.areEqual(dimensionFrom, ModDimensions.INSTANCE.getNIGHTMARE_WORLD())) {
                return true;
            }
            IPlayerNightmareData playerNightmareData = CapabilityExtensionsKt.getNightmareData((PlayerEntity)entityPlayer);
            World world2 = entityPlayer.field_70170_p;
            Intrinsics.checkNotNullExpressionValue(world2, "entityPlayer.level");
            World world3 = world2;
            world2 = entityPlayer.func_233580_cy_();
            Intrinsics.checkNotNullExpressionValue(world2, "entityPlayer.blockPosition()");
            if (IslandUtility.INSTANCE.isValidSpawnLocation(world3, (BlockPos)world2)) {
                playerNightmareData.setPreTeleportPosition(entityPlayer.func_233580_cy_());
            } else {
                world = entityPlayer.field_70170_p;
                Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.level");
                World world4 = world;
                world = entityPlayer.func_233580_cy_();
                Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.blockPosition()");
                BlockPos preTeleportPosition = IslandUtility.INSTANCE.findValidSpawnLocation(world4, (BlockPos)world, 6);
                if (preTeleportPosition == null) {
                    entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.dimension.nightmare.no_spawn"), entityPlayer.func_110124_au());
                    return true;
                }
                playerNightmareData.setPreTeleportPosition(preTeleportPosition);
            }
            playerNightmareData.setPreTeleportDimension(dimensionFrom);
            ListNBT inventoryNBT = entityPlayer.field_71071_by.func_70442_a(new ListNBT());
            playerNightmareData.setPreTeleportPlayerInventory(inventoryNBT);
            BlockPos blockPos = entityPlayer.func_241140_K_();
            world = entityPlayer.func_241141_L_();
            Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.respawnDimension");
            playerNightmareData.setPreTeleportRespawnPosition(new RespawnPosition(blockPos, (RegistryKey<World>)world, entityPlayer.func_242109_L(), entityPlayer.func_241142_M_()));
            entityPlayer.field_71071_by.func_174888_l();
            entityPlayer.field_71069_bz.func_75142_b();
        }
        return false;
    }

    @SubscribeEvent
    public final void onPostEntityTravelToDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            RegistryKey fromDimension = event.getFrom();
            RegistryKey toDimension = event.getTo();
            PlayerEntity playerEntity = event.getPlayer();
            if (playerEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
            }
            ServerPlayerEntity entityPlayer = (ServerPlayerEntity)playerEntity;
            Intrinsics.checkNotNullExpressionValue(fromDimension, "fromDimension");
            Intrinsics.checkNotNullExpressionValue(toDimension, "toDimension");
            this.processPostTeleport(entityPlayer, (RegistryKey<World>)fromDimension, (RegistryKey<World>)toDimension);
        }
    }

    private final void processPostTeleport(ServerPlayerEntity entityPlayer, RegistryKey<World> dimensionFrom, RegistryKey<World> dimensionTo) {
        IPlayerNightmareData playerNightmareData = CapabilityExtensionsKt.getNightmareData((PlayerEntity)entityPlayer);
        if (Intrinsics.areEqual(dimensionTo, ModDimensions.INSTANCE.getNIGHTMARE_WORLD())) {
            MinecraftServer minecraftServer = entityPlayer.field_71133_b;
            Intrinsics.checkNotNull(minecraftServer);
            ServerWorld nightmareWorld = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getNIGHTMARE_WORLD());
            Intrinsics.checkNotNull(nightmareWorld);
            int indexToGoTo = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex((World)nightmareWorld, playerNightmareData);
            int playerXBase = indexToGoTo * 1000;
            entityPlayer.field_71135_a.func_147364_a((double)playerXBase + 21.5, 74.0, 44.5, 0.0f, 0.0f);
            this.resetPlayerStats((PlayerEntity)entityPlayer);
            entityPlayer.field_71071_by.func_70441_a(this.createNamedJournal((PlayerEntity)entityPlayer));
            entityPlayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.INSTANCE.getINSANITYS_HEIGHTS()));
            entityPlayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Blocks.field_150478_aa, 64));
            entityPlayer.func_242111_a(ModDimensions.INSTANCE.getNIGHTMARE_WORLD(), entityPlayer.func_233580_cy_(), 0.0f, true, false);
            this.testForEnariasAltar(entityPlayer, nightmareWorld, new BlockPos(playerXBase, 0, 0));
        }
        if (Intrinsics.areEqual(dimensionFrom, ModDimensions.INSTANCE.getNIGHTMARE_WORLD())) {
            BlockPos indexToGoTo = playerNightmareData.getPreTeleportPosition();
            Intrinsics.checkNotNull(indexToGoTo);
            BlockPos preTeleportPosition = indexToGoTo;
            entityPlayer.field_71135_a.func_147364_a((double)preTeleportPosition.func_177958_n() + 0.5, (double)preTeleportPosition.func_177956_o() + 1.5, (double)preTeleportPosition.func_177952_p() + 0.5, 0.0f, 0.0f);
            this.resetPlayerStats((PlayerEntity)entityPlayer);
            int numberNightmareStones = RangesKt.coerceAtMost(ItemStackHelper.func_233534_a_((IInventory)((IInventory)entityPlayer.field_71071_by), NightmareHandler::processPostTeleport$lambda-4, (int)-1, (boolean)true), 64);
            entityPlayer.field_71071_by.func_174888_l();
            PlayerInventory playerInventory = entityPlayer.field_71071_by;
            ListNBT playerXBase = playerNightmareData.getPreTeleportPlayerInventory();
            Intrinsics.checkNotNull(playerXBase);
            playerInventory.func_70443_b(playerXBase);
            RespawnPosition respawnPosition = playerNightmareData.getPreTeleportRespawnPosition();
            Intrinsics.checkNotNull(respawnPosition);
            RespawnPosition respawnPosition2 = respawnPosition;
            entityPlayer.func_242111_a(respawnPosition2.getRespawnDimension(), respawnPosition2.getRespawnPosition(), respawnPosition2.getRespawnAngle(), respawnPosition2.getRespawnForced(), false);
            if (numberNightmareStones > 0) {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.INSTANCE.getNIGHTMARE_STONE(), numberNightmareStones));
            }
            entityPlayer.field_71069_bz.func_75142_b();
        }
    }

    private final void resetPlayerStats(PlayerEntity entityPlayer) {
        entityPlayer.func_213317_d(new Vector3d(0.0, 0.0, 0.0));
        entityPlayer.func_70606_j(20.0f);
        entityPlayer.func_71024_bL().func_75114_a(20);
        entityPlayer.func_193076_bZ().clear();
    }

    private final ItemStack createNamedJournal(PlayerEntity entityPlayer) {
        ItemStack toReturn = new ItemStack((IItemProvider)ModItems.INSTANCE.getJOURNAL(), 1);
        ModItems.INSTANCE.getJOURNAL().setOwner(toReturn, entityPlayer.func_146103_bH().getName());
        return toReturn;
    }

    private final void testForEnariasAltar(ServerPlayerEntity entityPlayer, ServerWorld nightmareWorld, BlockPos islandPos) {
        IPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch((PlayerEntity)entityPlayer);
        if (playerResearch.isResearched(ModResearches.INSTANCE.getENARIA()) && nightmareWorld.func_180495_p(islandPos.func_177982_a(101, 74, 233)).func_177230_c() != ModBlocks.INSTANCE.getENARIAS_ALTAR()) {
            int posX = islandPos.func_177958_n() + 67;
            int posY = islandPos.func_177956_o() + 40;
            int posZ = islandPos.func_177952_p() + 179;
            Random throwawayRandom = new Random();
            SchematicStructurePiece enariasAltar = new SchematicStructurePiece(posX, posY, posZ, throwawayRandom, ModSchematics.INSTANCE.getENARIAS_ALTAR(), null, Direction.NORTH);
            ISeedReader iSeedReader = (ISeedReader)nightmareWorld;
            StructureManager structureManager = nightmareWorld.func_241112_a_();
            Intrinsics.checkNotNullExpressionValue(structureManager, "nightmareWorld.structureFeatureManager()");
            StructureManager structureManager2 = structureManager;
            structureManager = nightmareWorld.func_72863_F().field_186029_c;
            Intrinsics.checkNotNullExpressionValue(structureManager, "nightmareWorld.chunkSource.generator");
            StructureManager structureManager3 = structureManager;
            MutableBoundingBox mutableBoundingBox = new MutableBoundingBox(posX, posZ, posX + ModSchematics.INSTANCE.getENARIAS_ALTAR().getWidth(), posZ + ModSchematics.INSTANCE.getENARIAS_ALTAR().getLength());
            ChunkPos chunkPos = new ChunkPos(0, 0);
            structureManager = BlockPos.field_177992_a;
            Intrinsics.checkNotNullExpressionValue(structureManager, "ZERO");
            enariasAltar.func_230383_a_(iSeedReader, structureManager2, (ChunkGenerator)structureManager3, throwawayRandom, mutableBoundingBox, chunkPos, (BlockPos)structureManager);
        }
    }

    private static final boolean onNightmareWorldTick$lambda-0(Entity it) {
        Entity entity = it;
        return Intrinsics.areEqual(entity == null ? null : entity.func_200600_R(), ModEntities.INSTANCE.getGHASTLY_ENARIA());
    }

    private static final GhastlyEnariaEntity onNightmareWorldTick$lambda-1(Entity it) {
        if (it == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.entity.enaria.GhastlyEnariaEntity");
        }
        return (GhastlyEnariaEntity)it;
    }

    private static final boolean onNightmareWorldTick$lambda-2(GhastlyEnariaEntity it) {
        return it.getTouchedPlayer() != null;
    }

    private static final void onNightmareWorldTick$lambda-3(World $world, GhastlyEnariaEntity it) {
        ServerWorld serverWorld = (ServerWorld)$world;
        RegistryKey<World> registryKey = it.getTouchedPlayer();
        Intrinsics.checkNotNull(registryKey);
        Entity player = serverWorld.func_217461_a((UUID)registryKey);
        if (player != null && player instanceof ServerPlayerEntity) {
            it.func_174812_G();
            ((ServerPlayerEntity)player).func_184210_p();
            ((ServerPlayerEntity)player).field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.INSTANCE.getNIGHTMARE_STONE()));
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            registryKey = CapabilityExtensionsKt.getNightmareData((PlayerEntity)player).getPreTeleportDimension();
            Intrinsics.checkNotNull(registryKey);
            PlayerTeleportExtensionsKt.teleport(serverPlayerEntity, registryKey);
        }
        it.clearTouchedPlayer();
    }

    private static final boolean processPostTeleport$lambda-4(ItemStack it) {
        return Intrinsics.areEqual(it.func_77973_b(), (Object)ModItems.INSTANCE.getNIGHTMARE_STONE());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/NightmareHandler$Companion;", "", "()V", "VALID_SPAWN_SEARCH_DISTANCE", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

