/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IPlayerVoidChestData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.RespawnPosition;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.dimension.IslandUtility;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J,\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/VoidChestHandler;", "", "()V", "onPostEntityTravelToDimension", "", "event", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerChangedDimensionEvent;", "onPreEntityTravelToDimension", "Lnet/minecraftforge/event/entity/EntityTravelToDimensionEvent;", "processPostTeleport", "entityPlayer", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "dimensionFrom", "Lnet/minecraft/util/RegistryKey;", "Lnet/minecraft/world/World;", "dimensionTo", "processPreTeleport", "", "Companion", "afraidofthedark"})
public final class VoidChestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int VALID_SPAWN_SEARCH_DISTANCE = 6;

    @SubscribeEvent
    public final void onPreEntityTravelToDimension(@NotNull EntityTravelToDimensionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getEntity().field_70170_p.field_72995_K) {
            RegistryKey fromDimension = event.getEntity().field_70170_p.func_234923_W_();
            RegistryKey toDimension = event.getDimension();
            if (event.getEntity() instanceof ServerPlayerEntity) {
                Entity entity = event.getEntity();
                if (entity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
                }
                ServerPlayerEntity entityPlayer = (ServerPlayerEntity)entity;
                Intrinsics.checkNotNullExpressionValue(fromDimension, "fromDimension");
                Intrinsics.checkNotNullExpressionValue(toDimension, "toDimension");
                if (this.processPreTeleport(entityPlayer, (RegistryKey<World>)fromDimension, (RegistryKey<World>)toDimension)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private final boolean processPreTeleport(ServerPlayerEntity entityPlayer, RegistryKey<World> dimensionFrom, RegistryKey<World> dimensionTo) {
        if (Intrinsics.areEqual(dimensionTo, ModDimensions.INSTANCE.getVOID_CHEST_WORLD())) {
            if (Intrinsics.areEqual(dimensionFrom, ModDimensions.INSTANCE.getVOID_CHEST_WORLD())) {
                return true;
            }
            IPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData((PlayerEntity)entityPlayer);
            World world = entityPlayer.field_70170_p;
            Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.level");
            World world2 = world;
            world = entityPlayer.func_233580_cy_();
            Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.blockPosition()");
            if (IslandUtility.INSTANCE.isValidSpawnLocation(world2, (BlockPos)world)) {
                playerVoidChestData.setPreTeleportPosition(entityPlayer.func_233580_cy_());
            } else {
                World world3 = entityPlayer.field_70170_p;
                Intrinsics.checkNotNullExpressionValue(world3, "entityPlayer.level");
                World world4 = world3;
                world3 = entityPlayer.func_233580_cy_();
                Intrinsics.checkNotNullExpressionValue(world3, "entityPlayer.blockPosition()");
                BlockPos preTeleportPosition = IslandUtility.INSTANCE.findValidSpawnLocation(world4, (BlockPos)world3, 6);
                if (preTeleportPosition == null) {
                    entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.dimension.void_chest.no_spawn"), entityPlayer.func_110124_au());
                    return true;
                }
                playerVoidChestData.setPreTeleportPosition(preTeleportPosition);
            }
            playerVoidChestData.setPreTeleportDimension(dimensionFrom);
            BlockPos blockPos = entityPlayer.func_241140_K_();
            world = entityPlayer.func_241141_L_();
            Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.respawnDimension");
            playerVoidChestData.setPreTeleportRespawnPosition(new RespawnPosition(blockPos, (RegistryKey<World>)world, entityPlayer.func_242109_L(), entityPlayer.func_241142_M_()));
        }
        return false;
    }

    @SubscribeEvent
    public final void onPostEntityTravelToDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            RegistryKey fromDimension = event.getFrom();
            RegistryKey toDimension = event.getTo();
            PlayerEntity playerEntity = event.getPlayer();
            if (playerEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
            }
            ServerPlayerEntity entityPlayer = (ServerPlayerEntity)playerEntity;
            Intrinsics.checkNotNullExpressionValue(fromDimension, "fromDimension");
            Intrinsics.checkNotNullExpressionValue(toDimension, "toDimension");
            this.processPostTeleport(entityPlayer, (RegistryKey<World>)fromDimension, (RegistryKey<World>)toDimension);
        }
    }

    private final void processPostTeleport(ServerPlayerEntity entityPlayer, RegistryKey<World> dimensionFrom, RegistryKey<World> dimensionTo) {
        if (Intrinsics.areEqual(dimensionTo, ModDimensions.INSTANCE.getVOID_CHEST_WORLD())) {
            int n;
            IPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData((PlayerEntity)entityPlayer);
            if (playerVoidChestData.getFriendsIndex() == -1) {
                MinecraftServer minecraftServer = entityPlayer.field_71133_b;
                Intrinsics.checkNotNull(minecraftServer);
                ServerWorld serverWorld = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getVOID_CHEST_WORLD());
                Intrinsics.checkNotNull(serverWorld);
                ServerWorld serverWorld2 = serverWorld;
                n = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex((World)serverWorld2, playerVoidChestData);
            } else {
                n = playerVoidChestData.getFriendsIndex();
            }
            int indexToGoTo = n;
            int playerXBase = indexToGoTo * 1000;
            entityPlayer.field_71135_a.func_147364_a((double)playerXBase + 24.5, 104.0, 3.0, 0.0f, 0.0f);
            entityPlayer.func_242111_a(ModDimensions.INSTANCE.getVOID_CHEST_WORLD(), entityPlayer.func_233580_cy_(), 0.0f, true, false);
        }
        if (Intrinsics.areEqual(dimensionFrom, ModDimensions.INSTANCE.getVOID_CHEST_WORLD())) {
            BlockPos indexToGoTo = CapabilityExtensionsKt.getVoidChestData((PlayerEntity)entityPlayer).getPreTeleportPosition();
            Intrinsics.checkNotNull(indexToGoTo);
            BlockPos preTeleportPosition = indexToGoTo;
            entityPlayer.field_71135_a.func_147364_a((double)preTeleportPosition.func_177958_n() + 0.5, (double)preTeleportPosition.func_177956_o() + 1.5, (double)preTeleportPosition.func_177952_p() + 0.5, 0.0f, 0.0f);
            RespawnPosition respawnPosition = CapabilityExtensionsKt.getVoidChestData((PlayerEntity)entityPlayer).getPreTeleportRespawnPosition();
            Intrinsics.checkNotNull(respawnPosition);
            RespawnPosition respawnPosition2 = respawnPosition;
            entityPlayer.func_242111_a(respawnPosition2.getRespawnDimension(), respawnPosition2.getRespawnPosition(), respawnPosition2.getRespawnAngle(), respawnPosition2.getRespawnForced(), false);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/VoidChestHandler$Companion;", "", "()V", "VALID_SPAWN_SEARCH_DISTANCE", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

