/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.feature.structure.crypt;

import com.davidm1a2.afraidofthedark.common.constants.ModLootTables;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.AOTDStructureStart;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.MultiplierConfig;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.SchematicStructurePiece;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/structure/crypt/CryptStructureStart;", "Lcom/davidm1a2/afraidofthedark/common/feature/structure/base/AOTDStructureStart;", "Lcom/davidm1a2/afraidofthedark/common/feature/structure/base/MultiplierConfig;", "structure", "Lnet/minecraft/world/gen/feature/structure/Structure;", "chunkX", "", "chunkZ", "boundsIn", "Lnet/minecraft/util/math/MutableBoundingBox;", "referenceIn", "seed", "", "(Lnet/minecraft/world/gen/feature/structure/Structure;IILnet/minecraft/util/math/MutableBoundingBox;IJ)V", "init", "", "generator", "Lnet/minecraft/world/gen/ChunkGenerator;", "xPos", "zPos", "afraidofthedark"})
public final class CryptStructureStart
extends AOTDStructureStart<MultiplierConfig> {
    public CryptStructureStart(@NotNull Structure<MultiplierConfig> structure, int chunkX, int chunkZ, @NotNull MutableBoundingBox boundsIn, int referenceIn, long seed) {
        Intrinsics.checkNotNullParameter(structure, "structure");
        Intrinsics.checkNotNullParameter(boundsIn, "boundsIn");
        super(structure, chunkX, chunkZ, boundsIn, referenceIn, seed);
    }

    @Override
    public void init(@NotNull ChunkGenerator generator, int xPos, int zPos) {
        Intrinsics.checkNotNullParameter(generator, "generator");
        int centerCorner1Height = generator.func_222529_a(xPos - 3, zPos - 3, Heightmap.Type.WORLD_SURFACE_WG);
        int centerCorner2Height = generator.func_222529_a(xPos + 3, zPos - 3, Heightmap.Type.WORLD_SURFACE_WG);
        int centerCorner3Height = generator.func_222529_a(xPos - 3, zPos + 3, Heightmap.Type.WORLD_SURFACE_WG);
        int centerCorner4Height = generator.func_222529_a(xPos + 3, zPos + 3, Heightmap.Type.WORLD_SURFACE_WG);
        int yPos = MathKt.roundToInt((double)(centerCorner1Height + centerCorner2Height + centerCorner3Height + centerCorner4Height) / 4.0);
        int adjustedY = RangesKt.coerceAtLeast(yPos - ModSchematics.INSTANCE.getCRYPT().getHeight() + 3, 1);
        int n = this.func_143019_e() * 16 - ModSchematics.INSTANCE.getCRYPT().getWidth() / 2;
        int n2 = this.func_143018_f() * 16 - ModSchematics.INSTANCE.getCRYPT().getLength() / 2;
        SharedSeedRandom sharedSeedRandom = this.field_214631_d;
        Intrinsics.checkNotNullExpressionValue(sharedSeedRandom, "this.random");
        this.field_75075_a.add(new SchematicStructurePiece(n, adjustedY, n2, (Random)sharedSeedRandom, ModSchematics.INSTANCE.getCRYPT(), ModLootTables.INSTANCE.getCRYPT(), null, 64, null));
        this.func_202500_a();
    }
}

