/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.network.packets.other;

import com.davidm1a2.afraidofthedark.common.network.packets.EntityPacket;
import com.davidm1a2.afraidofthedark.common.network.packets.EntityPacketProcessor;
import com.davidm1a2.afraidofthedark.common.network.packets.other.VoidChestPacket;
import com.davidm1a2.afraidofthedark.common.tileEntity.VoidChestTileEntity;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/network/packets/other/VoidChestPacketProcessor;", "Lcom/davidm1a2/afraidofthedark/common/network/packets/EntityPacketProcessor;", "Lcom/davidm1a2/afraidofthedark/common/network/packets/other/VoidChestPacket;", "()V", "decode", "buf", "Lnet/minecraft/network/PacketBuffer;", "encode", "", "msg", "process", "ctx", "Lnet/minecraftforge/fml/network/NetworkEvent$Context;", "Companion", "afraidofthedark"})
public final class VoidChestPacketProcessor
extends EntityPacketProcessor<VoidChestPacket> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LogManager.getLogger();

    @Override
    public void encode(@NotNull VoidChestPacket msg, @NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(buf, "buf");
        this.writeEntityData((EntityPacket)msg, buf);
        buf.writeInt(msg.getChestX$afraidofthedark());
        buf.writeInt(msg.getChestY$afraidofthedark());
        buf.writeInt(msg.getChestZ$afraidofthedark());
    }

    @Override
    @NotNull
    public VoidChestPacket decode(@NotNull PacketBuffer buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Pair<UUID, Integer> pair = this.readEntityData(buf);
        UUID uuid = pair.component1();
        int id = ((Number)pair.component2()).intValue();
        return new VoidChestPacket(uuid, id, buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void process(@NotNull VoidChestPacket msg, @NotNull NetworkEvent.Context ctx) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        if (ctx.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ClientPlayerEntity clientPlayerEntity;
            ClientPlayerEntity clientPlayerEntity2 = Minecraft.func_71410_x().field_71439_g;
            Intrinsics.checkNotNull(clientPlayerEntity2);
            ClientPlayerEntity player = clientPlayerEntity = clientPlayerEntity2;
            PlayerEntity chestOpener = player.field_70170_p.func_217371_b(msg.getEntityUUID$afraidofthedark());
            if (chestOpener != null) {
                TileEntity chestTileEntity = player.field_70170_p.func_175625_s(new BlockPos(msg.getChestX$afraidofthedark(), msg.getChestY$afraidofthedark(), msg.getChestZ$afraidofthedark()));
                if (chestTileEntity != null) {
                    if (chestTileEntity instanceof VoidChestTileEntity) {
                        ((VoidChestTileEntity)chestTileEntity).openChest(chestOpener);
                    } else {
                        logger.warn("Attempted to sync a void chest opening on a non void chest tile entity!");
                    }
                } else {
                    logger.warn("Attempted to find an invalid void chest!");
                }
            } else {
                logger.warn("Attempted to update user of a void chest opening from a null player!");
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/network/packets/other/VoidChestPacketProcessor$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

