/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.registry;

import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.entity.bolt.BoltEntity;
import com.davidm1a2.afraidofthedark.common.registry.BoltEntry;
import com.davidm1a2.afraidofthedark.common.registry.CodecExtensionsKt;
import com.davidm1a2.afraidofthedark.common.research.Research;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u001f\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/davidm1a2/afraidofthedark/common/registry/BoltEntry;", "Lnet/minecraftforge/registries/ForgeRegistryEntry;", "item", "Lnet/minecraft/item/Item;", "lazyEntityType", "Lkotlin/Lazy;", "Lnet/minecraft/entity/EntityType;", "lazyPrerequisiteResearch", "Lcom/davidm1a2/afraidofthedark/common/research/Research;", "(Lnet/minecraft/item/Item;Lkotlin/Lazy;Lkotlin/Lazy;)V", "entityType", "getEntityType", "()Lnet/minecraft/entity/EntityType;", "entityType$delegate", "Lkotlin/Lazy;", "getItem", "()Lnet/minecraft/item/Item;", "prerequisiteResearch", "getPrerequisiteResearch", "()Lcom/davidm1a2/afraidofthedark/common/research/Research;", "prerequisiteResearch$delegate", "getUnlocalizedName", "", "makeBoltEntity", "Lcom/davidm1a2/afraidofthedark/common/entity/bolt/BoltEntity;", "world", "Lnet/minecraft/world/World;", "Companion", "afraidofthedark"})
public class BoltEntry
extends ForgeRegistryEntry<BoltEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Item item;
    @NotNull
    private final Lazy entityType$delegate;
    @NotNull
    private final Lazy prerequisiteResearch$delegate;
    @NotNull
    private static final Codec<BoltEntry> CODEC;

    public BoltEntry(@NotNull Item item, @NotNull Lazy<? extends EntityType<?>> lazyEntityType, @NotNull Lazy<Research> lazyPrerequisiteResearch) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(lazyEntityType, "lazyEntityType");
        Intrinsics.checkNotNullParameter(lazyPrerequisiteResearch, "lazyPrerequisiteResearch");
        this.item = item;
        this.entityType$delegate = lazyEntityType;
        this.prerequisiteResearch$delegate = lazyPrerequisiteResearch;
    }

    @NotNull
    public final Item getItem() {
        return this.item;
    }

    private final EntityType<?> getEntityType() {
        Lazy lazy = this.entityType$delegate;
        boolean bl = false;
        return (EntityType)lazy.getValue();
    }

    @Nullable
    public final Research getPrerequisiteResearch() {
        Lazy lazy = this.prerequisiteResearch$delegate;
        boolean bl = false;
        return (Research)((Object)lazy.getValue());
    }

    @NotNull
    public final BoltEntity makeBoltEntity(@NotNull World world) {
        BoltEntity boltEntity;
        Intrinsics.checkNotNullParameter(world, "world");
        Entity entity = this.getEntityType().func_200721_a(world);
        BoltEntity boltEntity2 = boltEntity = entity instanceof BoltEntity ? (BoltEntity)entity : null;
        if (boltEntity == null) {
            throw new IllegalStateException("Entity type " + this.getEntityType() + " is not a subclass of BoltEntity");
        }
        return boltEntity;
    }

    @NotNull
    public final String getUnlocalizedName() {
        StringBuilder stringBuilder = new StringBuilder().append("bolt_entry.");
        ResourceLocation resourceLocation = this.getRegistryName();
        Intrinsics.checkNotNull(resourceLocation);
        StringBuilder stringBuilder2 = stringBuilder.append((Object)resourceLocation.func_110624_b()).append('.');
        resourceLocation = this.getRegistryName();
        Intrinsics.checkNotNull(resourceLocation);
        return stringBuilder2.append((Object)resourceLocation.func_110623_a()).toString();
    }

    private static final Item CODEC$lambda-4$lambda-0(KProperty1 $tmp0, BoltEntry p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Item)((Function1)$tmp0).invoke(p0);
    }

    private static final Lazy CODEC$lambda-4$lambda-1(BoltEntry boltEntry) {
        return LazyKt.lazyOf(boltEntry.getEntityType());
    }

    private static final Optional CODEC$lambda-4$lambda-2(BoltEntry boltEntry) {
        return CodecExtensionsKt.toLazyOptional(boltEntry.getPrerequisiteResearch());
    }

    private static final BoltEntry CODEC$lambda-4$lambda-3(ResourceLocation name, Item item, Lazy entityType, Optional prerequisiteResearch) {
        Intrinsics.checkNotNullExpressionValue(item, "item");
        Intrinsics.checkNotNullExpressionValue(entityType, "entityType");
        Intrinsics.checkNotNullExpressionValue(prerequisiteResearch, "prerequisiteResearch");
        return (BoltEntry)new BoltEntry(item, entityType, CodecExtensionsKt.getOrNull(prerequisiteResearch)).setRegistryName(name);
    }

    private static final App CODEC$lambda-4(RecordCodecBuilder.Instance it) {
        App app = (App)ResourceLocation.field_240908_a_.fieldOf("forge:registry_name").forGetter(ForgeRegistryEntry::getRegistryName);
        Object object = ForgeRegistries.ITEMS;
        Intrinsics.checkNotNullExpressionValue(object, "ITEMS");
        MapCodec mapCodec = CodecExtensionsKt.codec(object).fieldOf("item");
        object = Companion.CODEC.1.2.INSTANCE;
        App app2 = (App)mapCodec.forGetter(arg_0 -> BoltEntry.CODEC$lambda-4$lambda-0((KProperty1)object, arg_0));
        object = ForgeRegistries.ENTITIES;
        Intrinsics.checkNotNullExpressionValue(object, "ENTITIES");
        return it.group(app, app2, (App)CodecExtensionsKt.lazy(CodecExtensionsKt.codec(object)).fieldOf("entity_type").forGetter(BoltEntry::CODEC$lambda-4$lambda-1), (App)CodecExtensionsKt.lazy(CodecExtensionsKt.codec(ModRegistries.INSTANCE.getRESEARCH())).optionalFieldOf("prerequisite_research").forGetter(BoltEntry::CODEC$lambda-4$lambda-2)).apply((Applicative)it, it.stable(BoltEntry::CODEC$lambda-4$lambda-3));
    }

    static {
        Codec codec = RecordCodecBuilder.create(BoltEntry::CODEC$lambda-4);
        Intrinsics.checkNotNullExpressionValue(codec, "create {\n            it.group(\n                ResourceLocation.CODEC.fieldOf(\"forge:registry_name\").forGetter(BoltEntry::getRegistryName),\n                ForgeRegistries.ITEMS.codec()\n                    .fieldOf(\"item\")\n                    .forGetter(BoltEntry::item),\n                ForgeRegistries.ENTITIES.codec()\n                    .lazy()\n                    .fieldOf(\"entity_type\")\n                    .forGetter { boltEntry -> lazyOf(boltEntry.entityType) },\n                ModRegistries.RESEARCH.codec()\n                    .lazy()\n                    .optionalFieldOf(\"prerequisite_research\")\n                    .forGetter { boltEntry -> boltEntry.prerequisiteResearch.toLazyOptional() }\n            ).apply(it, it.stable(Function4 { name, item, entityType, prerequisiteResearch ->\n                BoltEntry(item, entityType, prerequisiteResearch.getOrNull()).setRegistryName(name)\n            }))\n        }");
        CODEC = codec;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/registry/BoltEntry$Companion;", "", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Lcom/davidm1a2/afraidofthedark/common/registry/BoltEntry;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<BoltEntry> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

