/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component;

import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionStateBuilder;", "", "()V", "blockPosition", "Lnet/minecraft/util/math/BlockPos;", "casterEntity", "Lnet/minecraft/entity/Entity;", "deliveryEntity", "direction", "Lnet/minecraft/util/math/vector/Vector3d;", "entity", "position", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "stageIndex", "", "world", "Lnet/minecraft/world/World;", "build", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "copyOf", "state", "withBlockPosition", "withCasterEntity", "withDeliveryEntity", "withDirection", "withEntity", "withPosition", "withSpell", "withStageIndex", "withWorld", "afraidofthedark"})
public final class DeliveryTransitionStateBuilder {
    private Spell spell;
    private int stageIndex;
    private World world;
    private Vector3d position;
    private BlockPos blockPosition;
    private Vector3d direction;
    @Nullable
    private Entity casterEntity;
    @Nullable
    private Entity entity;
    @Nullable
    private Entity deliveryEntity;

    @NotNull
    public final DeliveryTransitionStateBuilder withSpell(@NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(spell, "spell");
        this.spell = spell;
        return this;
    }

    @NotNull
    public final DeliveryTransitionStateBuilder withStageIndex(int stageIndex) {
        this.stageIndex = stageIndex;
        return this;
    }

    @NotNull
    public final DeliveryTransitionStateBuilder withWorld(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        this.world = world;
        return this;
    }

    @NotNull
    public final DeliveryTransitionStateBuilder withPosition(@NotNull Vector3d position) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.position = position;
        return this;
    }

    @NotNull
    public final DeliveryTransitionStateBuilder withBlockPosition(@NotNull BlockPos blockPosition) {
        Intrinsics.checkNotNullParameter(blockPosition, "blockPosition");
        this.blockPosition = blockPosition;
        return this;
    }

    @NotNull
    public final DeliveryTransitionStateBuilder withDirection(@NotNull Vector3d direction) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        this.direction = direction;
        return this;
    }

    @NotNull
    public final DeliveryTransitionStateBuilder withCasterEntity(@Nullable Entity casterEntity) {
        this.casterEntity = casterEntity;
        return this;
    }

    @NotNull
    public final DeliveryTransitionStateBuilder withDeliveryEntity(@Nullable Entity deliveryEntity) {
        this.deliveryEntity = deliveryEntity;
        return this;
    }

    @NotNull
    public final DeliveryTransitionStateBuilder withEntity(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        this.entity = entity;
        World world = entity.field_70170_p;
        Intrinsics.checkNotNullExpressionValue(world, "entity.level");
        this.world = world;
        world = entity.func_174824_e(1.0f);
        Intrinsics.checkNotNullExpressionValue(world, "entity.getEyePosition(1.0f)");
        this.position = world;
        world = this.position;
        if (world == null) {
            Intrinsics.throwUninitializedPropertyAccessException("position");
            throw null;
        }
        this.blockPosition = new BlockPos((Vector3d)world);
        world = entity.func_70040_Z();
        Intrinsics.checkNotNullExpressionValue(world, "entity.lookAngle");
        this.direction = world;
        return this;
    }

    @NotNull
    public final DeliveryTransitionStateBuilder copyOf(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.spell = state.getSpell();
        this.stageIndex = state.getStageIndex();
        this.world = (World)state.getWorld();
        this.position = state.getPosition();
        this.blockPosition = state.getBlockPosition();
        this.direction = state.getDirection();
        this.casterEntity = state.getCasterEntity();
        this.entity = state.getEntity();
        this.deliveryEntity = state.getDeliveryEntity();
        return this;
    }

    @NotNull
    public final DeliveryTransitionState build() {
        Spell spell = this.spell;
        if (spell == null) {
            Intrinsics.throwUninitializedPropertyAccessException("spell");
            throw null;
        }
        Spell spell2 = spell;
        spell = this.world;
        if (spell == null) {
            Intrinsics.throwUninitializedPropertyAccessException("world");
            throw null;
        }
        Spell spell3 = spell;
        spell = this.position;
        if (spell == null) {
            Intrinsics.throwUninitializedPropertyAccessException("position");
            throw null;
        }
        Spell spell4 = spell;
        spell = this.blockPosition;
        if (spell == null) {
            Intrinsics.throwUninitializedPropertyAccessException("blockPosition");
            throw null;
        }
        Spell spell5 = spell;
        spell = this.direction;
        if (spell == null) {
            Intrinsics.throwUninitializedPropertyAccessException("direction");
            throw null;
        }
        return new DeliveryTransitionState(spell2, this.stageIndex, (World)spell3, (Vector3d)spell4, (BlockPos)spell5, (Vector3d)spell, this.casterEntity, this.entity, this.deliveryEntity);
    }
}

