/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.effect;

import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/DigSpellEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/AOTDSpellEffect;", "()V", "canBlockBeDestroyed", "", "world", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "procEffect", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "reducedParticles", "afraidofthedark"})
public final class DigSpellEffect
extends AOTDSpellEffect {
    public DigSpellEffect() {
        super(new ResourceLocation("afraidofthedark", "dig"));
    }

    @Override
    public void procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> instance, boolean reducedParticles) {
        int max;
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(instance, "instance");
        ServerWorld world = state.getWorld();
        Entity entity = state.getEntity();
        int min = reducedParticles ? 0 : 5;
        int n = max = reducedParticles ? 1 : 10;
        if (entity != null) {
            BlockPos blockPos = entity.func_233580_cy_().func_177977_b();
            World world2 = (World)world;
            Intrinsics.checkNotNullExpressionValue(blockPos, "blockPos");
            if (this.canBlockBeDestroyed(world2, blockPos)) {
                Vector3d vector3d = entity.func_213303_ch();
                Intrinsics.checkNotNullExpressionValue(vector3d, "entity.position()");
                Vector3d vector3d2 = vector3d;
                vector3d = entity.field_70170_p.func_234923_W_();
                Intrinsics.checkNotNullExpressionValue(vector3d, "entity.level.dimension()");
                AOTDSpellEffect.Companion.createParticlesAt(min, max, vector3d2, (RegistryKey<World>)vector3d, ModParticles.INSTANCE.getDIG());
                world.func_175655_b(blockPos, true);
            }
        } else {
            BlockPos position = state.getBlockPosition();
            if (this.canBlockBeDestroyed((World)world, position)) {
                if (!reducedParticles) {
                    Vector3d vector3d = state.getPosition();
                    RegistryKey registryKey = world.func_234923_W_();
                    Intrinsics.checkNotNullExpressionValue(registryKey, "world.dimension()");
                    AOTDSpellEffect.Companion.createParticlesAt(min, max, vector3d, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getDIG());
                } else if (Random.Default.nextDouble() > 0.6) {
                    Vector3d vector3d = state.getPosition();
                    RegistryKey registryKey = world.func_234923_W_();
                    Intrinsics.checkNotNullExpressionValue(registryKey, "world.dimension()");
                    AOTDSpellEffect.Companion.createParticlesAt(min, max, vector3d, (RegistryKey<World>)registryKey, ModParticles.INSTANCE.getDIG());
                }
                world.func_175655_b(position, true);
            }
        }
    }

    private final boolean canBlockBeDestroyed(World world, BlockPos blockPos) {
        BlockState blockState = world.func_180495_p(blockPos);
        return !(blockState.func_185887_b((IBlockReader)world, blockPos) == -1.0f);
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellEffect> instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        return 10.0;
    }
}

